/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.cell.alf.ui.wizard;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.window.ApplicationWindow;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ptp.cell.alf.ui.Activator;
import org.eclipse.ptp.cell.alf.ui.Messages;
import org.eclipse.ptp.cell.alf.ui.core.ALFWizardCreationAction;
import org.eclipse.ptp.cell.alf.ui.core.HelpDocumentRuntimeException;
import org.eclipse.ptp.cell.alf.ui.debug.Debug;
import org.eclipse.ptp.cell.alf.ui.wizard.ALFWizardNewProjectCreationPage;
import org.eclipse.ptp.cell.alf.ui.wizard.ALFWizardPageA;
import org.eclipse.ptp.cell.alf.ui.wizard.ALFWizardPageB;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.dialogs.WizardNewProjectCreationPage;
import org.eclipse.ui.wizards.newresource.BasicNewProjectResourceWizard;
import org.osgi.framework.Bundle;

public class ALFWizard
extends Wizard
implements INewWizard,
IExecutableExtension {
    protected IConfigurationElement wizardConfigElement;

    public void addPages() {
        ALFWizardNewProjectCreationPage projectNamePage = new ALFWizardNewProjectCreationPage(Messages.ALFWizard_projectNamePageName);
        projectNamePage.setTitle(Messages.ALFWizard_projectNamePageTitle);
        projectNamePage.setDescription(Messages.ALFWizard_projectNamePageDescription);
        this.addPage((IWizardPage)projectNamePage);
        ALFWizardPageA pageA = new ALFWizardPageA(Messages.ALFWizardPageA_pageName, Messages.ALFWizardPageA_pageTitle, Messages.ALFWizardPageA_pageDescription);
        this.addPage((IWizardPage)pageA);
        ALFWizardPageB pageB = new ALFWizardPageB(Messages.ALFWizardPageB_pageName, Messages.ALFWizardPageB_pageTitle, Messages.ALFWizardPageB_pageDescription);
        this.addPage((IWizardPage)pageB);
    }

    public boolean canFinish() {
        IWizardPage namePage = this.getPage(Messages.ALFWizard_projectNamePageName);
        IWizardPage pageA = this.getPage(Messages.ALFWizardPageA_pageName);
        if (namePage == null || pageA == null) {
            return false;
        }
        return namePage.isPageComplete() && pageA.isPageComplete();
    }

    public static Text createWhatsThisHelpText(Composite parent, final Shell shell, final IWizard wizard, final String urlPath, final int width, final int height) {
        Text helpText = new Text(parent, 76);
        helpText.setLayoutData((Object)new GridData(36));
        Font parentFont = parent.getFont();
        FontData[] parentData = parentFont.getFontData();
        int h = 7;
        if (parentData.length == 1 && parentData[0].height > 0.0f) {
            h = parentData[0].getHeight() - 3;
        }
        Font font = new Font(parentFont.getDevice(), "MyFont", h, 2);
        helpText.setFont(font);
        helpText.setForeground(new Color(parentFont.getDevice(), 0, 0, 255));
        helpText.setBackground(helpText.getDisplay().getSystemColor(22));
        helpText.setText(Messages.ALFWizard_whatsThisText);
        helpText.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
            }

            public void mouseUp(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
                try {
                    ApplicationWindow helpAppWindow = new ApplicationWindow(shell){

                        protected Control createContents(Composite parent) {
                            Browser helpAppBrowser = new Browser(parent, 0);
                            URL url = FileLocator.find((Bundle)Activator.getDefault().getBundle(), (IPath)new Path(urlPath), null);
                            String temp = null;
                            try {
                                if (url == null) {
                                    throw new IOException();
                                }
                                temp = FileLocator.toFileURL((URL)url).toString();
                                helpAppBrowser.setUrl(temp);
                            }
                            catch (IOException iOException) {
                                throw new HelpDocumentRuntimeException();
                            }
                            return helpAppBrowser;
                        }
                    };
                    helpAppWindow.create();
                    helpAppWindow.getShell().setMinimumSize(width, height);
                    helpAppWindow.setBlockOnOpen(true);
                    helpAppWindow.open();
                }
                catch (HelpDocumentRuntimeException helpDocumentRuntimeException) {
                    ALFWizard alfWizard = (ALFWizard)wizard;
                    alfWizard.logErrorMessage(Messages.ALFWizard_errorHelpDocTitle, Messages.ALFWizard_errorHelpDocMessage);
                }
                catch (Exception ee) {
                    Debug.POLICY.logError((Throwable)ee);
                }
            }
        });
        return helpText;
    }

    public IWizard getWizard() {
        return this;
    }

    public boolean performFinish() {
        boolean question;
        if (!this.canFinish()) {
            this.logErrorMessage(Messages.ALFWizard_projectNamePageTitle, Messages.ALFWizard_errorCannotFinishMessage);
            return false;
        }
        WizardNewProjectCreationPage namePage = (WizardNewProjectCreationPage)this.getPage(Messages.ALFWizard_projectNamePageName);
        ALFWizardPageA pageA = (ALFWizardPageA)this.getPage(Messages.ALFWizardPageA_pageName);
        ALFWizardPageB pageB = (ALFWizardPageB)this.getPage(Messages.ALFWizardPageB_pageName);
        if (namePage == null || pageA == null || pageB == null) {
            return false;
        }
        pageB.updateAndValidateBuffers();
        ArrayList buffers = pageB.getBuffers();
        if (buffers.size() == 0 && !(question = this.queryYesNoQuestion(Messages.ALFWizard_projectNamePageTitle, Messages.ALFWizard_warningNoBuffersExist))) {
            return false;
        }
        if (!pageB.isPageComplete() && !(question = this.queryYesNoQuestion(Messages.ALFWizard_projectNamePageTitle, Messages.ALFWizard_warningBufferErrorsExist))) {
            return false;
        }
        if (!pageB.updateNumDTEntries() && !(question = this.queryYesNoQuestion(Messages.ALFWizard_projectNamePageTitle, Messages.ALFWizard_warningUnequalNumDT))) {
            return false;
        }
        if (!pageB.updateLocalMemorySize() && !(question = this.queryYesNoQuestion(Messages.ALFWizard_projectNamePageTitle, Messages.ALFWizard_warningNoRemainingMemory))) {
            return false;
        }
        ProgressMonitorDialog monitor = new ProgressMonitorDialog(this.getContainer().getShell());
        ALFWizardCreationAction action = new ALFWizardCreationAction(this, namePage.getLocationPath(), namePage.getProjectName(), pageA.getExpStackSize(), pageA.getExpAccelNum(), pageA.getPartitionMethod(), pageB.getBuffers(), pageA.is64bit());
        try {
            monitor.run(true, true, (IRunnableWithProgress)action);
            BasicNewProjectResourceWizard.updatePerspective((IConfigurationElement)this.wizardConfigElement);
        }
        catch (InvocationTargetException e) {
            if (e.getMessage() == null) {
                MessageDialog.openError((Shell)this.getContainer().getShell(), (String)Messages.ALFWizard_errorWizardFinish, (String)Messages.ALFWizard_errorUnknown);
                this.getContainer().updateButtons();
                return false;
            }
            MessageDialog.openError((Shell)this.getContainer().getShell(), (String)Messages.ALFWizard_errorWizardFinish, (String)e.getMessage());
            this.getContainer().updateButtons();
            return false;
        }
        catch (InterruptedException interruptedException) {
            MessageDialog.openInformation((Shell)this.getContainer().getShell(), (String)Messages.ALFWizard_projectNamePageTitle, (String)Messages.ALFWizard_errorWizardCanceled);
            this.getContainer().updateButtons();
            return false;
        }
        return true;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.setWindowTitle(Messages.ALFWizard_title);
        this.setNeedsProgressMonitor(true);
    }

    public String queryPathLocation(String title, String message, String defaultValue) {
        final InputDialog dialog = new InputDialog(this.getShell(), title, message, defaultValue, new IInputValidator(){

            public String isValid(String newText) {
                File file = new File(newText);
                if (!file.exists()) {
                    return Messages.ALFWizard_errorDirDoesNotExist;
                }
                return null;
            }
        });
        this.getShell().getDisplay().syncExec(new Runnable(){

            public void run() {
                dialog.setBlockOnOpen(true);
                dialog.open();
            }
        });
        if (dialog.getReturnCode() == 1) {
            return null;
        }
        return dialog.getValue();
    }

    public boolean queryYesNoQuestion(String title, String message) {
        final MessageDialog dialog = new MessageDialog(this.getShell(), title, null, message, 3, new String[]{Messages.ALFWizard_yes, Messages.ALFWizard_no}, 0);
        this.getShell().getDisplay().syncExec(new Runnable(){

            public void run() {
                dialog.open();
            }
        });
        int returnCode = dialog.getReturnCode();
        return returnCode == 0;
    }

    public void logWarningMessage(String title, String message) {
        Debug.POLICY.logStatus((IStatus)new Status(2, Activator.getDefault().getBundle().getSymbolicName(), 0, message, null));
    }

    public void openWarningMessage(String title, String message) {
        final MessageDialog dialog = new MessageDialog(this.getShell(), title, null, message, 4, new String[]{Messages.ALFWizard_ok}, 0);
        this.getShell().getDisplay().syncExec(new Runnable(){

            public void run() {
                dialog.open();
            }
        });
    }

    public void logErrorMessage(String title, String message) {
        Debug.POLICY.logStatus((IStatus)new Status(4, Activator.getDefault().getBundle().getSymbolicName(), 0, message, null));
    }

    public void openErrorMessage(String title, String message) {
        final MessageDialog dialog = new MessageDialog(this.getShell(), title, null, message, 1, new String[]{Messages.ALFWizard_ok}, 0);
        this.getShell().getDisplay().syncExec(new Runnable(){

            public void run() {
                dialog.open();
            }
        });
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        this.wizardConfigElement = config;
    }

    class MyDirectoryDialog
    extends DirectoryDialog {
        String selectedDir;

        public MyDirectoryDialog(Shell parent) {
            super(parent);
            this.selectedDir = null;
        }

        public void openDialog() {
            this.selectedDir = this.open();
        }

        public String getResult() {
            return this.selectedDir;
        }
    }
}

