/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.remotetools.utils.verification;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.ptp.remotetools.utils.verification.IllegalAttributeException;
import org.eclipse.ptp.remotetools.utils.verification.Messages;

public class ControlAttributes
implements Cloneable {
    Map currentMap = null;
    Map defaultMap = null;

    public ControlAttributes(Map config) {
        this.currentMap = config;
        this.defaultMap = new HashMap();
    }

    public ControlAttributes(Map currentMap, Map defaultMap) {
        this.currentMap = currentMap;
        this.defaultMap = defaultMap;
    }

    private String getCurrent(String attributeName) {
        if (this.currentMap == null) {
            return null;
        }
        return (String)this.currentMap.get(attributeName);
    }

    private String getDefault(String attributeName) {
        if (this.defaultMap == null) {
            return null;
        }
        return (String)this.defaultMap.get(attributeName);
    }

    public Object clone() throws CloneNotSupportedException {
        ControlAttributes newObject = new ControlAttributes(null);
        if (this.currentMap != null) {
            newObject.currentMap = new HashMap(this.currentMap);
        }
        if (this.defaultMap != null) {
            newObject.defaultMap = new HashMap(this.defaultMap);
        }
        return newObject;
    }

    public String getAttributeOrDefault(String attributeName) {
        String value = this.getCurrent(attributeName);
        if (value == null) {
            return this.getDefault(attributeName);
        }
        return value;
    }

    public String getString(String attributeKey) {
        return this.getString(attributeKey, "");
    }

    public String getString(String attributeKey, String defaultValue) {
        String stringValue = this.getAttributeOrDefault(attributeKey);
        if (stringValue == null) {
            return defaultValue;
        }
        return stringValue;
    }

    public String getText(String attributeKey) {
        return this.getText(attributeKey, "");
    }

    public String getText(String attributeKey, String defaultValue) {
        String textValue = this.getAttributeOrDefault(attributeKey);
        if (textValue == null) {
            textValue = defaultValue;
        }
        textValue = textValue.replaceAll("\\n", "\n");
        textValue = textValue.replaceAll("\\\\", "\\");
        return textValue;
    }

    public boolean getBoolean(String attributeKey) {
        return this.getBoolean(attributeKey, false);
    }

    public boolean getBoolean(String attributeKey, boolean defaultValue) {
        String string = this.getAttributeOrDefault(attributeKey);
        if (string == null) {
            return defaultValue;
        }
        return Boolean.valueOf(string);
    }

    public int getInteger(String attributeKey) {
        return this.getInteger(attributeKey, 0);
    }

    public int getInteger(String attributeKey, int defaultValue) {
        String string = this.getAttributeOrDefault(attributeKey);
        if (string == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            try {
                string = this.getDefault(attributeKey);
                if (string == null) {
                    return defaultValue;
                }
                return Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException2) {
                return defaultValue;
            }
        }
    }

    public double getDouble(String attributeKey) {
        return this.getDoubleAttribute(attributeKey, 0.0);
    }

    public double getDouble(String attributeKey, double defaultValue) {
        String string = this.getAttributeOrDefault(attributeKey);
        if (string == null) {
            return defaultValue;
        }
        try {
            return Double.parseDouble(string);
        }
        catch (NumberFormatException numberFormatException) {
            try {
                string = this.getDefault(attributeKey);
                if (string == null) {
                    return defaultValue;
                }
                return Double.parseDouble(string);
            }
            catch (NumberFormatException numberFormatException2) {
                return defaultValue;
            }
        }
    }

    public boolean getBooleanAttribute(String attributeKey, boolean defaultValue) {
        return this.getBoolean(attributeKey, defaultValue);
    }

    public int getIntegerAttribute(String attributeKey, int defaultValue) {
        return this.getInteger(attributeKey, defaultValue);
    }

    public double getDoubleAttribute(String attributeKey, double defaultValue) {
        return this.getDouble(attributeKey, defaultValue);
    }

    public String getStringAttribute(String attributeKey, String defaultValue) {
        return this.getString(attributeKey, defaultValue);
    }

    public String getTextAttribute(String attributeKey, String defaultValue) {
        return this.getText(attributeKey, defaultValue);
    }

    public int verifyIntAttribute(String attributeName, String attributeKey, int defaultValue) throws IllegalAttributeException {
        String stringValue = this.getAttributeOrDefault(attributeKey);
        if (stringValue == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(stringValue);
        }
        catch (NumberFormatException e) {
            throw new IllegalAttributeException(e, attributeName, Messages.ControlAttributes_InvalidIntegerNumber, stringValue);
        }
    }

    public int verifyInt(String attributeName, String attributeKey) throws IllegalAttributeException {
        String stringValue = this.verifyString(attributeName, attributeKey);
        try {
            return Integer.parseInt(stringValue);
        }
        catch (NumberFormatException e) {
            throw new IllegalAttributeException(e, attributeName, Messages.ControlAttributes_InvalidIntegerNumber, stringValue);
        }
    }

    public double verifyDoubleAttribute(String attributeName, String attributeKey, double defaultValue) throws IllegalAttributeException {
        String stringValue = this.getAttributeOrDefault(attributeKey);
        if (stringValue == null) {
            return defaultValue;
        }
        try {
            return Double.parseDouble(stringValue);
        }
        catch (NumberFormatException e) {
            throw new IllegalAttributeException(e, attributeName, Messages.ControlAttributes_InvalidDecimalNumber, stringValue);
        }
    }

    public double verifyDouble(String attributeName, String attributeKey) throws IllegalAttributeException {
        String stringValue = this.verifyString(attributeName, attributeKey);
        try {
            return Double.parseDouble(stringValue);
        }
        catch (NumberFormatException e) {
            throw new IllegalAttributeException(e, attributeName, Messages.ControlAttributes_InvalidDecimalNumber, stringValue);
        }
    }

    public IPath verifyPath(String attributeName, String attributeKey) throws IllegalAttributeException {
        Path path = new Path("");
        String stringValue = this.verifyString(attributeName, attributeKey);
        if (!path.isValidPath(stringValue)) {
            throw new IllegalAttributeException(attributeName, Messages.ControlAttributes_InvalidPath, stringValue);
        }
        return new Path(stringValue);
    }

    public String verifyString(String attributeName, String attributeKey) throws IllegalAttributeException {
        String stringValue = this.getAttributeOrDefault(attributeKey);
        if (stringValue == null) {
            throw new IllegalAttributeException(attributeName, Messages.ControlAttributes_MustNotBeEmpty);
        }
        return stringValue;
    }

    public void setAttribute(String attributeKey, String value) {
        this.currentMap.put(attributeKey, value);
    }

    public void setStringAttribute(String attributeKey, String value) {
        this.setAttribute(attributeKey, value);
    }

    public void setIntAttribute(String attributeKey, int value) {
        this.setAttribute(attributeKey, Integer.toString(value));
    }

    public void setDoubleAttribute(String attributeKey, double value) {
        this.setAttribute(attributeKey, Double.toString(value));
    }

    public void setBooleanAttribute(String attributeKey, boolean value) {
        this.setAttribute(attributeKey, Boolean.toString(value));
    }

    public void setTextAttribute(String attributeKey, String value) {
        String textValue = value;
        textValue = textValue.replaceAll("\\", "\\\\");
        textValue = textValue.replaceAll("\n", "\\n");
        this.setAttribute(attributeKey, textValue);
    }
}

