/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.debug.sdm.core;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.ptp.core.PTPCorePlugin;
import org.eclipse.ptp.core.attributes.ArrayAttribute;
import org.eclipse.ptp.core.attributes.AttributeManager;
import org.eclipse.ptp.core.attributes.IAttribute;
import org.eclipse.ptp.core.attributes.IAttributeDefinition;
import org.eclipse.ptp.core.attributes.StringAttribute;
import org.eclipse.ptp.core.elementcontrols.IResourceManagerControl;
import org.eclipse.ptp.core.elements.IPJob;
import org.eclipse.ptp.core.elements.IPNode;
import org.eclipse.ptp.core.elements.IPProcess;
import org.eclipse.ptp.core.elements.IPUniverse;
import org.eclipse.ptp.core.elements.IResourceManager;
import org.eclipse.ptp.core.elements.attributes.JobAttributes;
import org.eclipse.ptp.core.elements.attributes.ResourceManagerAttributes;
import org.eclipse.ptp.debug.core.IPDebugger;
import org.eclipse.ptp.debug.core.launch.IPLaunch;
import org.eclipse.ptp.debug.core.pdi.IPDIDebugger;
import org.eclipse.ptp.debug.core.pdi.IPDISession;
import org.eclipse.ptp.debug.core.pdi.PDIException;
import org.eclipse.ptp.debug.core.pdi.Session;
import org.eclipse.ptp.debug.core.pdi.event.IPDIEventFactory;
import org.eclipse.ptp.debug.core.pdi.manager.IPDIManagerFactory;
import org.eclipse.ptp.debug.core.pdi.model.IPDIModelFactory;
import org.eclipse.ptp.debug.core.pdi.request.IPDIRequestFactory;
import org.eclipse.ptp.debug.sdm.core.SDMDebugCorePlugin;
import org.eclipse.ptp.debug.sdm.core.SDMEventFactory;
import org.eclipse.ptp.debug.sdm.core.SDMManagerFactory;
import org.eclipse.ptp.debug.sdm.core.SDMModelFactory;
import org.eclipse.ptp.debug.sdm.core.SDMPreferenceConstants;
import org.eclipse.ptp.debug.sdm.core.SDMRequestFactory;
import org.eclipse.ptp.debug.sdm.core.SDMRunner;
import org.eclipse.ptp.debug.sdm.core.pdi.PDIDebugger;
import org.eclipse.ptp.debug.sdm.core.utils.DebugUtil;
import org.eclipse.ptp.launch.PTPLaunchPlugin;
import org.eclipse.ptp.remote.core.IRemoteConnection;
import org.eclipse.ptp.remote.core.IRemoteConnectionManager;
import org.eclipse.ptp.remote.core.IRemoteFileManager;
import org.eclipse.ptp.remote.core.IRemoteServices;
import org.eclipse.ptp.remote.core.PTPRemoteCorePlugin;
import org.eclipse.ptp.rm.remote.core.AbstractRemoteResourceManagerConfiguration;
import org.eclipse.ptp.rmsystem.IResourceManagerConfiguration;

public class SDMDebugger
implements IPDebugger {
    private IPDIDebugger pdiDebugger = null;
    private IPDIModelFactory modelFactory = null;
    private IPDIManagerFactory managerFactory = null;
    private IPDIEventFactory eventFactory = null;
    private IPDIRequestFactory requestFactory = null;
    IFileStore routingFileStore = null;
    SDMRunner sdmRunner = null;

    public IPDISession createDebugSession(long timeout, IPLaunch launch, IPath corefile) throws CoreException {
        if (this.modelFactory == null) {
            this.modelFactory = new SDMModelFactory();
        }
        if (this.managerFactory == null) {
            this.managerFactory = new SDMManagerFactory();
        }
        if (this.eventFactory == null) {
            this.eventFactory = new SDMEventFactory();
        }
        if (this.requestFactory == null) {
            this.requestFactory = new SDMRequestFactory();
        }
        this.writeRoutingFile(launch);
        this.sdmRunner.setJob(launch.getPJob());
        this.sdmRunner.schedule();
        Session session = this.createSession(timeout, launch, corefile);
        return session;
    }

    public void initialize(ILaunchConfiguration configuration, AttributeManager attrMgr, IProgressMonitor monitor) throws CoreException {
        ArrayAttribute dbgArgsAttr = (ArrayAttribute)attrMgr.getAttribute((IAttributeDefinition)JobAttributes.getDebuggerArgumentsAttributeDefinition());
        if (dbgArgsAttr == null) {
            dbgArgsAttr = JobAttributes.getDebuggerArgumentsAttributeDefinition().create();
            attrMgr.addAttribute((IAttribute)dbgArgsAttr);
        }
        List dbgArgs = dbgArgsAttr.getValue();
        try {
            this.getDebugger().initialize(configuration, dbgArgs, monitor);
        }
        catch (PDIException e) {
            throw this.newCoreException(e);
        }
        this.prepareRoutingFile(configuration, attrMgr, monitor);
        IResourceManagerControl rm = null;
        rm = (IResourceManagerControl)this.getResourceManager(configuration);
        this.sdmRunner = new SDMRunner(rm);
    }

    public void getLaunchAttributes(ILaunchConfiguration configuration, AttributeManager attrMgr) throws CoreException {
        String dbgExtraArgs;
        ArrayAttribute dbgArgsAttr = (ArrayAttribute)attrMgr.getAttribute((IAttributeDefinition)JobAttributes.getDebuggerArgumentsAttributeDefinition());
        if (dbgArgsAttr == null) {
            dbgArgsAttr = JobAttributes.getDebuggerArgumentsAttributeDefinition().create();
            attrMgr.addAttribute((IAttribute)dbgArgsAttr);
        }
        List dbgArgs = dbgArgsAttr.getValue();
        Preferences store = SDMDebugCorePlugin.getDefault().getPluginPreferences();
        String localAddress = configuration.getAttribute("org.eclipse.ptp.launch.ATTR_DEBUGGER_HOST", "localhost");
        dbgArgs.add("--host=" + localAddress);
        dbgArgs.add("--debugger=" + store.getString(SDMPreferenceConstants.SDM_DEBUGGER_BACKEND_TYPE));
        String dbgPath = store.getString(SDMPreferenceConstants.SDM_DEBUGGER_BACKEND_PATH);
        if (dbgPath.length() > 0) {
            dbgArgs.add("--debugger_path=" + dbgPath);
        }
        if ((dbgExtraArgs = store.getString(SDMPreferenceConstants.SDM_DEBUGGER_ARGS)).length() > 0) {
            dbgArgs.addAll(Arrays.asList(dbgExtraArgs.split(" ")));
        }
        String dbgExePath = configuration.getAttribute("org.eclipse.ptp.launch.DEBUGGER_EXECUTABLE_PATH", "");
        IPath path = PTPLaunchPlugin.getDefault().verifyResource(dbgExePath, configuration);
        attrMgr.addAttribute((IAttribute)JobAttributes.getDebuggerExecutableNameAttributeDefinition().create(path.lastSegment()));
        attrMgr.addAttribute((IAttribute)JobAttributes.getDebuggerExecutablePathAttributeDefinition().create(path.removeLastSegments(1).toString()));
        String dbgWD = configuration.getAttribute("org.eclipse.ptp.launch.DEBUGGER_WORKING_DIR", null);
        if (dbgWD != null) {
            StringAttribute wdAttr = (StringAttribute)attrMgr.getAttribute((IAttributeDefinition)JobAttributes.getWorkingDirectoryAttributeDefinition());
            if (wdAttr != null) {
                wdAttr.setValueAsString(dbgWD);
            } else {
                attrMgr.addAttribute((IAttribute)JobAttributes.getWorkingDirectoryAttributeDefinition().create(dbgWD));
            }
            attrMgr.addAttribute((IAttribute)JobAttributes.getExecutablePathAttributeDefinition().create(String.valueOf(dbgWD) + "/Debug"));
        }
        attrMgr.addAttribute((IAttribute)JobAttributes.getDebugFlagAttributeDefinition().create(Boolean.valueOf(true)));
        ArrayList<String> sdmCommand = new ArrayList<String>();
        sdmCommand.add(String.valueOf(((StringAttribute)attrMgr.getAttribute((IAttributeDefinition)JobAttributes.getDebuggerExecutablePathAttributeDefinition())).getValue()) + "/" + ((StringAttribute)attrMgr.getAttribute((IAttributeDefinition)JobAttributes.getDebuggerExecutableNameAttributeDefinition())).getValue());
        sdmCommand.add("--master");
        sdmCommand.addAll(dbgArgs);
        this.sdmRunner.setCommand(sdmCommand);
        this.sdmRunner.setWorkDir(((StringAttribute)attrMgr.getAttribute((IAttributeDefinition)JobAttributes.getWorkingDirectoryAttributeDefinition())).getValue());
    }

    public void cleanup(ILaunchConfiguration configuration, AttributeManager attrMgr, IPLaunch launch) {
        if (this.sdmRunner != null && this.sdmRunner.getSdmState() == SDMRunner.SDMMasterState.RUNNING) {
            DebugUtil.trace(DebugUtil.SDM_MASTER_TRACING, "sdm master: still running, cancel is to be issued soon");
            new Thread("SDM master killer thread"){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    DebugUtil.trace(DebugUtil.SDM_MASTER_TRACING_MORE, "sdm master killer: thread started");
                    1 var1_1 = this;
                    synchronized (var1_1) {
                        try {
                            this.wait(5000L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    if (SDMDebugger.this.sdmRunner.getSdmState() == SDMRunner.SDMMasterState.RUNNING) {
                        DebugUtil.trace(DebugUtil.SDM_MASTER_TRACING, "sdm master killer: cancel SDM master now");
                        SDMDebugger.this.sdmRunner.cancel();
                    } else {
                        DebugUtil.trace(DebugUtil.SDM_MASTER_TRACING, "sdm master killer: do not cancel SDM master, since it finished by itself.");
                    }
                    DebugUtil.trace(DebugUtil.SDM_MASTER_TRACING_MORE, "sdm master killer: thread finished");
                }
            }.start();
        }
    }

    private IPDIDebugger getDebugger() {
        if (this.pdiDebugger == null) {
            this.pdiDebugger = new PDIDebugger();
        }
        return this.pdiDebugger;
    }

    private int getJobSize(IPJob job) {
        int nprocs = job.getProcesses().length;
        if (nprocs == 0) {
            nprocs = 1;
        }
        return nprocs;
    }

    private CoreException newCoreException(Throwable exception) {
        MultiStatus status = new MultiStatus(SDMDebugCorePlugin.getUniqueIdentifier(), 1000, "Cannot start debugging", exception);
        status.add((IStatus)new Status(4, SDMDebugCorePlugin.getUniqueIdentifier(), 1000, exception == null ? new String() : exception.getLocalizedMessage(), exception));
        return new CoreException((IStatus)status);
    }

    protected Session createSession(long timeout, IPLaunch launch, IPath corefile) throws CoreException {
        IPJob job = launch.getPJob();
        int job_size = this.getJobSize(job);
        try {
            return new Session(this.managerFactory, this.requestFactory, this.eventFactory, this.modelFactory, launch.getLaunchConfiguration(), timeout, this.getDebugger(), job.getID(), job_size);
        }
        catch (PDIException e) {
            throw this.newCoreException(e);
        }
    }

    private IResourceManager getResourceManager(ILaunchConfiguration configuration) throws CoreException {
        IPUniverse universe = PTPCorePlugin.getDefault().getUniverse();
        IResourceManager[] rms = universe.getResourceManagers();
        String rmUniqueName = configuration.getAttribute("org.eclipse.ptp.launch.RESOURCE_MANAGER_NAME", null);
        IResourceManager[] iResourceManagerArray = rms;
        int n = rms.length;
        int n2 = 0;
        while (n2 < n) {
            IResourceManager rm = iResourceManagerArray[n2];
            if (rm.getState() == ResourceManagerAttributes.State.STARTED && rm.getUniqueName().equals(rmUniqueName)) {
                return rm;
            }
            ++n2;
        }
        return null;
    }

    private void prepareRoutingFile(ILaunchConfiguration configuration, AttributeManager attrMgr, IProgressMonitor monitor) throws CoreException {
        Path routingFilePath = new Path(((StringAttribute)attrMgr.getAttribute((IAttributeDefinition)JobAttributes.getWorkingDirectoryAttributeDefinition())).getValue());
        routingFilePath = routingFilePath.append("routing_file");
        IResourceManagerControl rm = (IResourceManagerControl)this.getResourceManager(configuration);
        IResourceManagerConfiguration conf = rm.getConfiguration();
        AbstractRemoteResourceManagerConfiguration remConf = (AbstractRemoteResourceManagerConfiguration)conf;
        IRemoteServices remoteServices = PTPRemoteCorePlugin.getDefault().getRemoteServices(remConf.getRemoteServicesId());
        IRemoteConnectionManager rconnMgr = remoteServices.getConnectionManager();
        IRemoteConnection rconn = rconnMgr.getConnection(remConf.getConnectionName());
        IRemoteFileManager remoteFileManager = remoteServices.getFileManager(rconn);
        try {
            this.routingFileStore = remoteFileManager.getResource((IPath)routingFilePath, monitor);
        }
        catch (IOException e) {
            throw this.newCoreException(e);
        }
        IFileInfo info = this.routingFileStore.fetchInfo();
        if (info.exists()) {
            try {
                this.routingFileStore.delete(0, monitor);
            }
            catch (CoreException e) {
                throw this.newCoreException(e);
            }
            this.routingFileStore.fetchInfo();
        }
    }

    private void writeRoutingFile(IPLaunch launch) throws CoreException {
        DebugUtil.trace(DebugUtil.SDM_MASTER_TRACING, "debug: Write routing file");
        NullProgressMonitor monitor = new NullProgressMonitor();
        OutputStream os = null;
        try {
            os = this.routingFileStore.openOutputStream(0, (IProgressMonitor)monitor);
        }
        catch (CoreException e) {
            throw this.newCoreException(e);
        }
        PrintWriter pw = new PrintWriter(os);
        IPProcess[] processes = launch.getPJob().getProcesses();
        pw.format("%d\n", processes.length);
        int base = 10000;
        int range = 10000;
        Random random = new Random();
        IPProcess[] iPProcessArray = processes;
        int n = processes.length;
        int n2 = 0;
        while (n2 < n) {
            IPProcess process = iPProcessArray[n2];
            String index = process.getProcessIndex();
            IPNode node = process.getNode();
            String nodeName = node.getName();
            int portNumber = base + random.nextInt(range);
            pw.format("%s %s %d\n", index, nodeName, portNumber);
            ++n2;
        }
        pw.close();
        try {
            os.close();
        }
        catch (IOException e) {
            throw this.newCoreException(e);
        }
    }
}

