/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.cell.utils.stream;

import java.io.BufferedReader;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.eclipse.ptp.cell.utils.debug.Debug;
import org.eclipse.ptp.cell.utils.stream.ILineStreamListener;
import org.eclipse.ptp.cell.utils.stream.Messages;

public class TextStreamObserver
extends Thread {
    private BufferedReader reader;
    private boolean killed;
    private String name;
    private ILineStreamListener listener;

    public TextStreamObserver(InputStream input, ILineStreamListener listener, String name) {
        Debug.read();
        this.name = name;
        this.reader = new BufferedReader(new InputStreamReader(input));
        this.listener = listener;
        this.setName(name);
    }

    public TextStreamObserver(InputStream input, ILineStreamListener listener) {
        Debug.read();
        this.name = this.getClass().getName();
        this.reader = new BufferedReader(new InputStreamReader(input));
        this.listener = listener;
        this.setName(this.name);
    }

    public synchronized void kill() {
        Debug.POLICY.trace(Debug.DEBUG_STREAM, "Marked as killed.");
        this.killed = true;
    }

    void newLine(String line) {
        if (Debug.DEBUG_STREAM) {
            Debug.POLICY.trace("Notify received line: " + Integer.toString(line.length()) + " bytes");
            if (Debug.DEBUG_STREAM_MORE) {
                Debug.POLICY.trace(line);
            }
        }
        try {
            this.listener.newLine(line);
        }
        catch (Exception e) {
            Debug.POLICY.error(Debug.DEBUG_STREAM, e);
            Debug.POLICY.logError(e, Messages.TextStreamObserver_FailedDelegateMethod, new Object[0]);
        }
    }

    void streamClosed() {
        Debug.POLICY.trace(Debug.DEBUG_STREAM, "Notify stream closed.");
        try {
            this.listener.streamClosed();
        }
        catch (Exception e) {
            Debug.POLICY.error(Debug.DEBUG_STREAM, e);
            Debug.POLICY.logError(e, Messages.TextStreamObserver_FailedDelegateMethod, new Object[0]);
        }
    }

    void streamError(Exception e) {
        Debug.POLICY.error(Debug.DEBUG_STREAM, "Notify exception: {0}.", e.getMessage());
        try {
            this.listener.streamError(e);
        }
        catch (Exception ee) {
            Debug.POLICY.error(Debug.DEBUG_STREAM, ee);
            Debug.POLICY.logError(ee, Messages.TextStreamObserver_FailedDelegateMethod, new Object[0]);
        }
    }

    public void run() {
        Debug.read();
        Debug.POLICY.trace(Debug.DEBUG_STREAM, "Started.");
        while (!this.killed) {
            try {
                String line = this.reader.readLine();
                if (line == null) {
                    this.streamClosed();
                    return;
                }
                this.newLine(line);
            }
            catch (IOException e) {
                if (e instanceof EOFException) {
                    Debug.POLICY.trace(Debug.DEBUG_STREAM, "Expected EOFException.");
                    this.streamClosed();
                    break;
                }
                this.streamError(e);
                break;
            }
            catch (NullPointerException e) {
                if (this.killed) {
                    Debug.POLICY.trace(Debug.DEBUG_STREAM, "Expected NullPointerException.");
                    this.streamClosed();
                    break;
                }
                this.streamError(e);
                break;
            }
        }
        Debug.POLICY.trace(Debug.DEBUG_STREAM, "Finished.");
    }
}

