/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTCastExpression;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTTypeId;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTCastExpression;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTUnaryExpression;

public class CPPASTCastExpression
extends CPPASTUnaryExpression
implements ICPPASTCastExpression {
    private IASTTypeId typeId;

    public CPPASTCastExpression() {
    }

    public CPPASTCastExpression(int operator, IASTTypeId typeId, IASTExpression operand) {
        super(operator, operand);
        this.setTypeId(typeId);
    }

    public void setTypeId(IASTTypeId typeId) {
        this.typeId = typeId;
        if (typeId != null) {
            typeId.setParent(this);
            typeId.setPropertyInParent(TYPE_ID);
        }
    }

    public IASTTypeId getTypeId() {
        return this.typeId;
    }

    public void setOperand(IASTExpression expression) {
        super.setOperand(expression);
        if (expression != null) {
            expression.setParent(this);
            expression.setPropertyInParent(IASTCastExpression.OPERAND);
        }
    }

    public boolean accept(ASTVisitor action) {
        if (action.shouldVisitExpressions) {
            switch (action.visit(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        if (this.typeId != null && !this.typeId.accept(action)) {
            return false;
        }
        IASTExpression op = this.getOperand();
        if (op != null && !op.accept(action)) {
            return false;
        }
        if (action.shouldVisitExpressions) {
            switch (action.leave(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        return true;
    }
}

