/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.c;

import org.eclipse.cdt.core.dom.ILinkage;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTCompositeTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTElaboratedTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTSimpleDeclaration;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.ICompositeType;
import org.eclipse.cdt.core.dom.ast.IField;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.ITypedef;
import org.eclipse.cdt.core.dom.ast.c.ICASTCompositeTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.c.ICASTElaboratedTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.c.ICCompositeTypeScope;
import org.eclipse.cdt.core.parser.util.ArrayUtil;
import org.eclipse.cdt.core.parser.util.CharArrayUtils;
import org.eclipse.cdt.internal.core.dom.Linkage;
import org.eclipse.cdt.internal.core.dom.parser.ASTInternal;
import org.eclipse.cdt.internal.core.dom.parser.ProblemBinding;
import org.eclipse.cdt.internal.core.dom.parser.c.CField;
import org.eclipse.cdt.internal.core.dom.parser.c.CVisitor;
import org.eclipse.cdt.internal.core.dom.parser.c.ICInternalBinding;
import org.eclipse.cdt.internal.core.index.IIndexType;
import org.eclipse.core.runtime.PlatformObject;

public class CStructure
extends PlatformObject
implements ICompositeType,
ICInternalBinding {
    private IASTName[] declarations = null;
    private IASTName definition;

    public CStructure(IASTName name) {
        if (name.getPropertyInParent() == IASTCompositeTypeSpecifier.TYPE_NAME) {
            this.definition = name;
        } else {
            this.declarations = new IASTName[]{name};
        }
        name.setBinding(this);
    }

    public IASTNode getPhysicalNode() {
        return this.definition != null ? this.definition : this.declarations[0];
    }

    private ICASTCompositeTypeSpecifier checkForDefinition(IASTElaboratedTypeSpecifier declSpec) {
        IASTDeclSpecifier spec = CVisitor.findDefinition((ICASTElaboratedTypeSpecifier)declSpec);
        if (spec != null && spec instanceof ICASTCompositeTypeSpecifier) {
            ICASTCompositeTypeSpecifier compTypeSpec = (ICASTCompositeTypeSpecifier)spec;
            compTypeSpec.getName().setBinding(this);
            return compTypeSpec;
        }
        return null;
    }

    public String getName() {
        if (this.definition != null) {
            return this.definition.toString();
        }
        return this.declarations[0].toString();
    }

    public char[] getNameCharArray() {
        if (this.definition != null) {
            return this.definition.toCharArray();
        }
        return this.declarations[0].toCharArray();
    }

    public IScope getScope() throws DOMException {
        IASTDeclSpecifier declSpec = (IASTDeclSpecifier)(this.definition != null ? this.definition.getParent() : this.declarations[0].getParent());
        IScope scope = CVisitor.getContainingScope(declSpec);
        while (scope instanceof ICCompositeTypeScope) {
            scope = scope.getParent();
        }
        return scope;
    }

    public IField[] getFields() throws DOMException {
        if (this.definition == null) {
            ICASTCompositeTypeSpecifier temp = this.checkForDefinition((IASTElaboratedTypeSpecifier)this.declarations[0].getParent());
            if (temp == null) {
                return new IField[]{new CField.CFieldProblem(this.declarations[0], 7, this.getNameCharArray())};
            }
            this.definition = temp.getName();
        }
        ICASTCompositeTypeSpecifier compSpec = (ICASTCompositeTypeSpecifier)this.definition.getParent();
        IASTDeclaration[] members = compSpec.getMembers();
        int size = members.length;
        Object[] fields = new IField[size];
        if (size > 0) {
            ICCompositeTypeScope scope = (ICCompositeTypeScope)this.getCompositeScope();
            if (ASTInternal.isFullyCached(scope)) {
                scope = null;
            }
            int i = 0;
            while (i < size) {
                IASTDeclaration node = members[i];
                if (node instanceof IASTSimpleDeclaration) {
                    IASTDeclarator[] declarators = ((IASTSimpleDeclaration)node).getDeclarators();
                    int j = 0;
                    while (j < declarators.length) {
                        IASTDeclarator declarator = declarators[j];
                        IASTName name = declarator.getName();
                        IBinding binding = name.resolveBinding();
                        if (scope != null) {
                            ASTInternal.addName(scope, name);
                        }
                        if (binding != null) {
                            fields = (IField[])ArrayUtil.append(IField.class, fields, binding);
                        }
                        ++j;
                    }
                }
                ++i;
            }
            if (scope != null) {
                ASTInternal.setFullyCached(scope, true);
            }
        }
        return (IField[])ArrayUtil.trim(IField.class, fields);
    }

    public IField findField(String name) throws DOMException {
        if (this.definition == null) {
            ICASTCompositeTypeSpecifier temp = this.checkForDefinition((IASTElaboratedTypeSpecifier)this.declarations[0].getParent());
            if (temp == null) {
                return new CField.CFieldProblem(this.declarations[0], 7, this.getNameCharArray());
            }
            this.definition = temp.getName();
        }
        char[] nchars = name.toCharArray();
        ICCompositeTypeScope scope = (ICCompositeTypeScope)this.getCompositeScope();
        if (scope != null && ASTInternal.isFullyCached(scope)) {
            IBinding binding = scope.getBinding(nchars);
            if (binding instanceof IField) {
                return (IField)binding;
            }
        } else {
            ICASTCompositeTypeSpecifier compSpec = (ICASTCompositeTypeSpecifier)this.definition.getParent();
            Object[] specStack = null;
            int stackIdx = -1;
            IASTDeclaration[] members = compSpec.getMembers();
            IField found = null;
            while (members != null) {
                int size = members.length;
                int i = 0;
                while (i < size) {
                    IASTDeclaration node = members[i];
                    if (node instanceof IASTSimpleDeclaration) {
                        IASTCompositeTypeSpecifier declSpec;
                        IASTName n;
                        IASTDeclarator[] declarators = ((IASTSimpleDeclaration)node).getDeclarators();
                        int j = 0;
                        while (j < declarators.length) {
                            IBinding binding;
                            IASTDeclarator declarator = declarators[j];
                            IASTName dtorName = CVisitor.findInnermostDeclarator(declarator).getName();
                            if (scope != null) {
                                ASTInternal.addName(scope, dtorName);
                            }
                            if (CharArrayUtils.equals(nchars, dtorName.toCharArray()) && (binding = dtorName.resolveBinding()) instanceof IField) {
                                found = (IField)binding;
                            }
                            ++j;
                        }
                        if (declarators.length == 0 && ((IASTSimpleDeclaration)node).getDeclSpecifier() instanceof IASTCompositeTypeSpecifier && (n = (declSpec = (IASTCompositeTypeSpecifier)((IASTSimpleDeclaration)node).getDeclSpecifier()).getName()).toCharArray().length == 0) {
                            specStack = (ICASTCompositeTypeSpecifier[])ArrayUtil.append(ICASTCompositeTypeSpecifier.class, specStack, declSpec);
                        }
                    }
                    ++i;
                }
                members = specStack != null && ++stackIdx < specStack.length && specStack[stackIdx] != null ? specStack[stackIdx].getMembers() : (IASTDeclaration[])null;
            }
            if (scope != null) {
                ASTInternal.setFullyCached(scope, true);
            }
            if (found != null) {
                return found;
            }
        }
        return null;
    }

    public int getKey() {
        return this.definition != null ? ((IASTCompositeTypeSpecifier)this.definition.getParent()).getKey() : ((IASTElaboratedTypeSpecifier)this.declarations[0].getParent()).getKind();
    }

    public IScope getCompositeScope() {
        return this.definition != null ? ((IASTCompositeTypeSpecifier)this.definition.getParent()).getScope() : null;
    }

    public Object clone() {
        IType t = null;
        try {
            t = (IType)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {}
        return t;
    }

    public void addDefinition(ICASTCompositeTypeSpecifier compositeTypeSpec) {
        this.definition = compositeTypeSpec.getName();
        compositeTypeSpec.getName().setBinding(this);
    }

    public boolean isSameType(IType type) {
        if (type == this) {
            return true;
        }
        if (type instanceof ITypedef || type instanceof IIndexType) {
            return type.isSameType(this);
        }
        return false;
    }

    public ILinkage getLinkage() {
        return Linkage.C_LINKAGE;
    }

    public IASTNode[] getDeclarations() {
        return this.declarations;
    }

    public IASTNode getDefinition() {
        return this.definition;
    }

    public static class CStructureProblem
    extends ProblemBinding
    implements ICompositeType {
        public CStructureProblem(IASTNode node, int id, char[] arg) {
            super(node, id, arg);
        }

        public IField findField(String name) throws DOMException {
            throw new DOMException(this);
        }

        public IScope getCompositeScope() throws DOMException {
            throw new DOMException(this);
        }

        public IField[] getFields() throws DOMException {
            throw new DOMException(this);
        }

        public int getKey() throws DOMException {
            throw new DOMException(this);
        }
    }
}

