/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.dom.cpp;

import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPUsingDeclaration;
import org.eclipse.cdt.core.parser.util.ArrayUtil;
import org.eclipse.cdt.internal.core.pdom.PDOM;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMBinding;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMLinkage;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMNode;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.PDOMCPPBinding;
import org.eclipse.core.runtime.CoreException;

class PDOMCPPUsingDeclaration
extends PDOMCPPBinding
implements ICPPUsingDeclaration {
    private static final int TARGET_BINDING = 28;
    private static final int NEXT_DELEGATE = 32;
    protected static final int RECORD_SIZE = 36;
    private IBinding[] delegates;

    public PDOMCPPUsingDeclaration(PDOM pdom, PDOMNode parent, ICPPUsingDeclaration using) throws CoreException {
        super(pdom, parent, using.getNameCharArray());
        IBinding[] delegates = using.getDelegates();
        int nextRecord = 0;
        int i = delegates.length;
        while (--i >= 0) {
            PDOMCPPUsingDeclaration simpleUsing = i > 0 ? new PDOMCPPUsingDeclaration(pdom, parent, this.getNameCharArray()) : this;
            simpleUsing.setTargetBinding(parent.getLinkageImpl(), delegates[i]);
            pdom.getDB().putInt(this.record + 32, nextRecord);
            nextRecord = simpleUsing.getRecord();
        }
    }

    public PDOMCPPUsingDeclaration(PDOM pdom, int record) {
        super(pdom, record);
    }

    private PDOMCPPUsingDeclaration(PDOM pdom, PDOMNode parent, char[] name) throws CoreException {
        super(pdom, parent, name);
    }

    private void setTargetBinding(PDOMLinkage linkage, IBinding delegate) throws CoreException {
        PDOMBinding target = this.getLinkageImpl().adaptBinding(delegate);
        this.pdom.getDB().putInt(this.record + 28, target != null ? target.getRecord() : 0);
    }

    protected int getRecordSize() {
        return 36;
    }

    public int getNodeType() {
        return 46;
    }

    public IBinding[] getDelegates() {
        if (this.delegates == null) {
            this.delegates = new IBinding[1];
            int i = 0;
            PDOMCPPUsingDeclaration alias = this;
            try {
                do {
                    IBinding delegate;
                    if ((delegate = alias.getBinding()) == null) continue;
                    this.delegates = (IBinding[])ArrayUtil.append(IBinding.class, this.delegates, i++, delegate);
                } while ((alias = alias.getNext()) != null);
            }
            catch (CoreException e) {
                CCorePlugin.log((Throwable)e);
            }
            this.delegates = (IBinding[])ArrayUtil.trim(IBinding.class, this.delegates);
        }
        return this.delegates;
    }

    private PDOMCPPUsingDeclaration getNext() throws CoreException {
        int nextRecord = this.pdom.getDB().getInt(this.record + 32);
        return nextRecord != 0 ? new PDOMCPPUsingDeclaration(this.pdom, nextRecord) : null;
    }

    private IBinding getBinding() {
        try {
            return (IBinding)((Object)this.getLinkageImpl().getNode(this.getPDOM().getDB().getInt(this.record + 28)));
        }
        catch (CoreException e) {
            CCorePlugin.log((Throwable)e);
            return null;
        }
    }
}

