/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import org.eclipse.cdt.core.dom.ILinkage;
import org.eclipse.cdt.core.dom.ast.ASTNodeProperty;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTCompositeTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTElaboratedTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDefinition;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IProblemBinding;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTCompositeTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTElaboratedTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTParameterDeclaration;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTQualifiedName;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTSimpleTypeTemplateParameter;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTemplateDeclaration;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTemplateId;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTemplateParameter;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassTemplate;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassTemplatePartialSpecialization;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPSpecialization;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateDefinition;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateParameter;
import org.eclipse.cdt.core.parser.util.ArrayUtil;
import org.eclipse.cdt.core.parser.util.ObjectMap;
import org.eclipse.cdt.internal.core.dom.Linkage;
import org.eclipse.cdt.internal.core.dom.parser.ASTNode;
import org.eclipse.cdt.internal.core.dom.parser.ProblemBinding;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPTemplateNonTypeParameter;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPTemplateTemplateParameter;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPTemplateTypeParameter;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPInternalBinding;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPInternalTemplate;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPInternalTemplateInstantiator;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPTemplates;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPVisitor;
import org.eclipse.core.runtime.PlatformObject;

public abstract class CPPTemplateDefinition
extends PlatformObject
implements ICPPTemplateDefinition,
ICPPInternalTemplate {
    protected IASTName[] declarations;
    protected IASTName definition;
    private ICPPTemplateParameter[] templateParameters;
    private ObjectMap instances;

    public CPPTemplateDefinition(IASTName name) {
        if (name != null) {
            ASTNodeProperty prop = name.getPropertyInParent();
            if (prop == ICPPASTQualifiedName.SEGMENT_NAME) {
                prop = name.getParent().getPropertyInParent();
            }
            if (prop == IASTCompositeTypeSpecifier.TYPE_NAME) {
                this.definition = name;
            } else if (prop == IASTElaboratedTypeSpecifier.TYPE_NAME) {
                this.declarations = new IASTName[]{name};
            } else {
                IASTNode parent = name.getParent();
                while (!(parent instanceof IASTDeclaration)) {
                    parent = parent.getParent();
                }
                if (parent instanceof IASTFunctionDefinition) {
                    this.definition = name;
                } else {
                    this.declarations = new IASTName[]{name};
                }
            }
        }
    }

    public abstract ICPPSpecialization deferredInstance(ObjectMap var1, IType[] var2);

    public IBinding instantiate(ICPPASTTemplateId id) {
        IType[] types = CPPTemplates.createTemplateArgumentArray(id);
        return this.instantiate(types);
    }

    public IBinding instantiate(IType[] arguments) {
        ICPPTemplateDefinition template = null;
        if (this instanceof ICPPClassTemplate) {
            try {
                template = CPPTemplates.matchTemplatePartialSpecialization((ICPPClassTemplate)((Object)this), arguments);
            }
            catch (DOMException e) {
                return e.getProblem();
            }
        }
        if (template instanceof IProblemBinding) {
            return template;
        }
        if (template != null && template instanceof ICPPClassTemplatePartialSpecialization) {
            return ((ICPPInternalTemplateInstantiator)((Object)template)).instantiate(arguments);
        }
        return CPPTemplates.instantiateTemplate(this, arguments, null);
    }

    public ICPPSpecialization getInstance(IType[] arguments) {
        if (this.instances == null) {
            return null;
        }
        int found = -1;
        int i = 0;
        while (i < this.instances.size()) {
            IType[] args = (IType[])this.instances.keyAt(i);
            if (args.length == arguments.length) {
                int j = 0;
                while (j < args.length) {
                    if (!CPPTemplates.isSameTemplateArgument(args[j], arguments[j])) break;
                    ++j;
                }
                if (j == args.length) {
                    found = i;
                    break;
                }
            }
            ++i;
        }
        if (found != -1) {
            return (ICPPSpecialization)this.instances.getAt(found);
        }
        return null;
    }

    public void addSpecialization(IType[] types, ICPPSpecialization spec) {
        if (types == null) {
            return;
        }
        IType[] iTypeArray = types;
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            IType type = iTypeArray[n2];
            if (type == null) {
                return;
            }
            ++n2;
        }
        if (this.instances == null) {
            this.instances = new ObjectMap(2);
        }
        this.instances.put(types, spec);
    }

    public IBinding resolveTemplateParameter(ICPPASTTemplateParameter templateParameter) {
        IASTName templateName;
        ICPPASTTemplateDeclaration temp;
        ICPPASTTemplateParameter[] params;
        IASTName name;
        IASTName preferredName = name = CPPTemplates.getTemplateParameterName(templateParameter);
        IBinding binding = name.getBinding();
        if (binding != null) {
            return binding;
        }
        ICPPASTTemplateDeclaration templateDecl = (ICPPASTTemplateDeclaration)templateParameter.getParent();
        ICPPASTTemplateParameter[] ps = templateDecl.getTemplateParameters();
        int i = 0;
        while (i < ps.length) {
            if (templateParameter == ps[i]) break;
            ++i;
        }
        if ((this.definition != null || this.declarations != null && this.declarations.length > 0) && (params = (temp = CPPTemplates.getTemplateDeclaration(templateName = this.definition != null ? this.definition : this.declarations[0])).getTemplateParameters()).length > i) {
            IASTName paramName;
            preferredName = paramName = CPPTemplates.getTemplateParameterName(params[i]);
            if (paramName.getBinding() != null) {
                binding = paramName.getBinding();
                name.setBinding(binding);
                if (binding instanceof ICPPInternalBinding) {
                    ((ICPPInternalBinding)binding).addDeclaration(name);
                }
                return binding;
            }
        }
        binding = templateParameter instanceof ICPPASTSimpleTypeTemplateParameter ? new CPPTemplateTypeParameter(preferredName) : (templateParameter instanceof ICPPASTParameterDeclaration ? new CPPTemplateNonTypeParameter(preferredName) : new CPPTemplateTemplateParameter(preferredName));
        int length = this.declarations != null ? this.declarations.length : 0;
        int j = this.definition != null ? -1 : 0;
        while (j < length) {
            IASTName n;
            ICPPASTTemplateParameter[] temp2;
            ICPPASTTemplateDeclaration template;
            ICPPASTTemplateDeclaration iCPPASTTemplateDeclaration = template = j == -1 ? CPPTemplates.getTemplateDeclaration(this.definition) : CPPTemplates.getTemplateDeclaration(this.declarations[j]);
            if (template != null && (temp2 = template.getTemplateParameters()).length > i && (n = CPPTemplates.getTemplateParameterName(temp2[i])) != null && n != name && n.getBinding() == null) {
                n.setBinding(binding);
                if (binding instanceof ICPPInternalBinding) {
                    ((ICPPInternalBinding)binding).addDeclaration(n);
                }
            }
            ++j;
        }
        return binding;
    }

    public IASTName getTemplateName() {
        return this.definition != null ? this.definition : this.declarations[0];
    }

    public String getName() {
        return this.getTemplateName().toString();
    }

    public char[] getNameCharArray() {
        return this.getTemplateName().toCharArray();
    }

    public IScope getScope() {
        return CPPVisitor.getContainingScope(this.getTemplateName());
    }

    public String[] getQualifiedName() {
        return CPPVisitor.getQualifiedName(this);
    }

    public char[][] getQualifiedNameCharArray() {
        return CPPVisitor.getQualifiedNameCharArray(this);
    }

    public boolean isGloballyQualified() {
        return true;
    }

    public ICPPTemplateParameter[] getTemplateParameters() {
        if (this.templateParameters == null) {
            ICPPASTTemplateDeclaration template = CPPTemplates.getTemplateDeclaration(this.getTemplateName());
            if (template == null) {
                return ICPPTemplateParameter.EMPTY_TEMPLATE_PARAMETER_ARRAY;
            }
            ICPPASTTemplateParameter[] params = template.getTemplateParameters();
            IBinding p = null;
            Object[] result = null;
            ICPPASTTemplateParameter[] iCPPASTTemplateParameterArray = params;
            int n = params.length;
            int n2 = 0;
            while (n2 < n) {
                ICPPASTTemplateParameter param = iCPPASTTemplateParameterArray[n2];
                p = CPPTemplates.getTemplateParameterName(param).resolveBinding();
                if (p instanceof ICPPTemplateParameter) {
                    result = (ICPPTemplateParameter[])ArrayUtil.append(ICPPTemplateParameter.class, result, p);
                }
                ++n2;
            }
            this.templateParameters = (ICPPTemplateParameter[])ArrayUtil.trim(ICPPTemplateParameter.class, result);
        }
        return this.templateParameters;
    }

    public void addDefinition(IASTNode node) {
        if (node instanceof ICPPASTCompositeTypeSpecifier && (node = ((ICPPASTCompositeTypeSpecifier)node).getName()) instanceof ICPPASTQualifiedName) {
            IASTName[] ns = ((ICPPASTQualifiedName)node).getNames();
            node = ns[ns.length - 1];
        }
        if (!(node instanceof IASTName)) {
            return;
        }
        this.updateTemplateParameterBindings((IASTName)node);
        this.definition = (IASTName)node;
    }

    public void addDeclaration(IASTNode node) {
        if (node instanceof ICPPASTElaboratedTypeSpecifier && (node = ((ICPPASTElaboratedTypeSpecifier)node).getName()) instanceof ICPPASTQualifiedName) {
            IASTName[] ns = ((ICPPASTQualifiedName)node).getNames();
            node = ns[ns.length - 1];
        }
        if (!(node instanceof IASTName)) {
            return;
        }
        IASTName declName = (IASTName)node;
        this.updateTemplateParameterBindings(declName);
        this.declarations = this.declarations == null ? new IASTName[]{declName} : (this.declarations.length > 0 && ((ASTNode)node).getOffset() < ((ASTNode)((Object)this.declarations[0])).getOffset() ? (IASTName[])ArrayUtil.prepend(IASTName.class, this.declarations, declName) : (IASTName[])ArrayUtil.append(IASTName.class, this.declarations, declName));
    }

    public void removeDeclaration(IASTNode node) {
        if (this.definition == node) {
            this.definition = null;
            return;
        }
        ArrayUtil.remove(this.declarations, node);
    }

    protected void updateTemplateParameterBindings(IASTName name) {
        IASTName orig = this.definition != null ? this.definition : this.declarations[0];
        ICPPASTTemplateDeclaration origTemplate = CPPTemplates.getTemplateDeclaration(orig);
        ICPPASTTemplateDeclaration newTemplate = CPPTemplates.getTemplateDeclaration(name);
        ICPPASTTemplateParameter[] ops = origTemplate.getTemplateParameters();
        ICPPASTTemplateParameter[] nps = newTemplate.getTemplateParameters();
        ICPPInternalBinding temp = null;
        int end = Math.min(ops.length, nps.length);
        int i = 0;
        while (i < end) {
            temp = (ICPPInternalBinding)CPPTemplates.getTemplateParameterName(ops[i]).getBinding();
            if (temp != null) {
                IASTName n = CPPTemplates.getTemplateParameterName(nps[i]);
                n.setBinding(temp);
                temp.addDeclaration(n);
            }
            ++i;
        }
    }

    public IASTNode[] getDeclarations() {
        return this.declarations;
    }

    public IASTNode getDefinition() {
        return this.definition;
    }

    public ILinkage getLinkage() {
        return Linkage.CPP_LINKAGE;
    }

    public static final class CPPTemplateProblem
    extends ProblemBinding
    implements ICPPTemplateDefinition {
        public CPPTemplateProblem(IASTNode node, int id, char[] arg) {
            super(node, id, arg);
        }

        public ICPPTemplateParameter[] getTemplateParameters() throws DOMException {
            throw new DOMException(this);
        }

        public ICPPClassTemplatePartialSpecialization[] getTemplateSpecializations() throws DOMException {
            throw new DOMException(this);
        }

        public String[] getQualifiedName() throws DOMException {
            throw new DOMException(this);
        }

        public char[][] getQualifiedNameCharArray() throws DOMException {
            throw new DOMException(this);
        }

        public boolean isGloballyQualified() throws DOMException {
            throw new DOMException(this);
        }
    }
}

