/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.cell.environment.remotesimulator.core;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ptp.cell.environment.remotesimulator.core.ConfigFactory;
import org.eclipse.ptp.cell.environment.remotesimulator.core.Messages;
import org.eclipse.ptp.cell.environment.remotesimulator.core.TargetConfig;
import org.eclipse.ptp.remotetools.RemotetoolsPlugin;
import org.eclipse.ptp.remotetools.core.AuthToken;
import org.eclipse.ptp.remotetools.core.IRemoteConnection;
import org.eclipse.ptp.remotetools.core.IRemoteExecutionManager;
import org.eclipse.ptp.remotetools.core.IRemoteTunnel;
import org.eclipse.ptp.remotetools.core.KeyAuthToken;
import org.eclipse.ptp.remotetools.core.PasswdAuthToken;
import org.eclipse.ptp.remotetools.environment.control.ITargetControl;
import org.eclipse.ptp.remotetools.environment.control.SSHTargetControl;
import org.eclipse.ptp.remotetools.environment.core.ITargetElement;
import org.eclipse.ptp.remotetools.environment.extension.ITargetVariables;
import org.eclipse.ptp.remotetools.exception.CancelException;
import org.eclipse.ptp.remotetools.exception.LocalPortBoundException;
import org.eclipse.ptp.remotetools.exception.RemoteConnectionException;
import org.eclipse.ptp.remotetools.utils.verification.ControlAttributes;

public class TargetControl
extends SSHTargetControl
implements ITargetControl,
ITargetVariables {
    TargetConfig currentTargetConfig;
    public static String DEFAULT_HOST_CIPHER = RemotetoolsPlugin.CIPHER_DEFAULT;
    public static String DEFAULT_SIMULATOR_CIPHER = RemotetoolsPlugin.CIPHER_BLOWFISH;
    ITargetElement targetElement;
    IRemoteConnection remoteHostConnection;
    IRemoteExecutionManager remoteHostManager;
    int nextPort = 0;
    Map tunnels = null;
    private int state = 1;
    private static final int NOT_OPERATIONAL = 1;
    private static final int CONNECTING = 2;
    private static final int CONNECTED = 3;
    private static final int DISCONNECTING = 4;

    public TargetControl(ITargetElement element) throws CoreException {
        this.targetElement = element;
        if (this.targetElement.getAttributes() == null) {
            this.targetElement.setAttributes(ConfigFactory.createDefaultConfig());
        }
        this.checkControlConfig();
        this.createConsoles();
    }

    private synchronized void setState(int state) {
        this.state = state;
    }

    public boolean create(IProgressMonitor monitor) throws CoreException {
        monitor.beginTask(Messages.TargetControl_RemoteSimulatorConnection, 2);
        ControlAttributes controlAttributes = new ControlAttributes(this.targetElement.getAttributes());
        ConfigFactory configFactory = new ConfigFactory(controlAttributes);
        this.currentTargetConfig = configFactory.createTargetConfig();
        this.setState(2);
        monitor.subTask(Messages.TargetControl_RemoteHostConnection);
        IRemoteTunnel tunnel = null;
        try {
            tunnel = this.connectRemoteHost();
        }
        catch (CoreException e) {
            this.disconnectRemoteHost();
            this.setState(1);
            throw e;
        }
        monitor.worked(1);
        try {
            try {
                monitor.subTask(Messages.TargetControl_RemoteSimulatorConnection);
                if (this.currentTargetConfig.isSimulatorIsPasswordAuth()) {
                    this.setConnectionParameters(new SSHTargetControl.SSHParameters((SSHTargetControl)this, "localhost", tunnel.getLocalPort(), this.currentTargetConfig.getSimulatorLoginUserName(), this.currentTargetConfig.getSimulatorLoginPassword(), this.currentTargetConfig.getSimulatorCipherType(), this.currentTargetConfig.getSimulatorConnectionTimeout() * 1000));
                } else {
                    this.setConnectionParameters(new SSHTargetControl.SSHParameters((SSHTargetControl)this, "localhost", tunnel.getLocalPort(), this.currentTargetConfig.getSimulatorLoginUserName(), this.currentTargetConfig.getSimulatorKeyPath(), this.currentTargetConfig.getSimulatorPassphrase(), this.currentTargetConfig.getSimulatorCipherType(), this.currentTargetConfig.getSimulatorConnectionTimeout() * 1000));
                }
                super.create(monitor);
                monitor.worked(1);
                this.setState(3);
            }
            catch (CoreException e) {
                this.disconnect();
                this.disconnectRemoteHost();
                this.setState(1);
                throw e;
            }
        }
        finally {
            monitor.done();
        }
        return true;
    }

    private void disconnectRemoteHost() {
        if (this.tunnels != null) {
            this.tunnels = null;
        }
        if (this.remoteHostManager != null) {
            this.remoteHostManager.close();
            this.remoteHostManager = null;
        }
        if (this.remoteHostConnection != null) {
            this.remoteHostConnection.disconnect();
            this.remoteHostConnection = null;
        }
    }

    private IRemoteTunnel connectRemoteHost() throws CoreException {
        IRemoteTunnel tunnel;
        try {
            Object token = this.currentTargetConfig.isRemoteIsPasswordAuth() ? new PasswdAuthToken(this.currentTargetConfig.getRemoteLoginUserName(), this.currentTargetConfig.getRemoteLoginPassword()) : new KeyAuthToken(this.currentTargetConfig.getRemoteLoginUserName(), new File(this.currentTargetConfig.getRemoteKeyPath()), this.currentTargetConfig.getRemoteKeyPassphrase());
            this.remoteHostConnection = RemotetoolsPlugin.createSSHConnection((AuthToken)token, (String)this.currentTargetConfig.getRemoteConnectionAddress(), (int)this.currentTargetConfig.getRemoteConnectionPort(), (String)this.currentTargetConfig.getRemoteCipherType(), (int)(this.currentTargetConfig.getRemoteConnectionTimeout() * 1000));
            this.remoteHostConnection.connect();
            this.remoteHostManager = this.remoteHostConnection.createRemoteExecutionManager();
        }
        catch (RemoteConnectionException e) {
            this.disconnectRemoteHost();
            throw new CoreException((IStatus)new Status(4, "org.eclipse.ptp.remotetools.environment.remotesimulator", 1, Messages.TargetControl_CouldNotConnectToRemoteHost, (Throwable)e));
        }
        try {
            this.nextPort = 0;
            this.tunnels = new HashMap();
            tunnel = this.createTunnel(this.currentTargetConfig.getSimulatorConnectionPort());
        }
        catch (Exception e) {
            this.disconnectRemoteHost();
            throw new CoreException((IStatus)new Status(4, "org.eclipse.ptp.remotetools.environment.remotesimulator", 1, Messages.TargetControl_CouldNotConnectToSimulatorOnRemoteHost, (Throwable)e));
        }
        return tunnel;
    }

    private IRemoteTunnel createTunnel(int remotePort) throws RemoteConnectionException, LocalPortBoundException, CancelException {
        Integer remotePortInteger = new Integer(remotePort);
        if (this.tunnels.containsKey(remotePortInteger)) {
            return (IRemoteTunnel)this.tunnels.get(remotePortInteger);
        }
        IRemoteTunnel tunnel = this.remoteHostManager.createTunnel(this.currentTargetConfig.getSimulatorConnectionAddress(), remotePort);
        this.tunnels.put(remotePortInteger, tunnel);
        return tunnel;
    }

    public boolean kill(IProgressMonitor monitor) throws CoreException {
        try {
            this.setState(4);
            super.kill(monitor);
        }
        finally {
            this.disconnectRemoteHost();
            this.setState(1);
        }
        return true;
    }

    public String getName() {
        return this.targetElement.getName();
    }

    public synchronized int query() {
        switch (this.state) {
            case 1: {
                return 1;
            }
            case 2: 
            case 4: {
                return 0;
            }
            case 3: {
                if (this.isConnected()) {
                    return 2;
                }
                return 0;
            }
        }
        return 1;
    }

    public boolean resume(IProgressMonitor monitor) throws CoreException {
        throw new CoreException((IStatus)new Status(4, "org.eclipse.ptp.remotetools.environment.remotesimulator", 0, Messages.TargetControl_CannotResumeRemoteSimulator, null));
    }

    public boolean stop(IProgressMonitor monitor) throws CoreException {
        throw new CoreException((IStatus)new Status(4, "org.eclipse.ptp.remotetools.environment.remotesimulator", 0, Messages.TargetControl_CannotPauseRemoteSimulator, null));
    }

    public void updateConfiguration() throws CoreException {
        this.checkControlConfig();
    }

    public ITargetControl.TargetSocket createTargetSocket(int port) throws CoreException {
        Assert.isTrue((boolean)this.isConnected());
        try {
            IRemoteTunnel tunnel = this.createTunnel(port);
            ITargetControl.TargetSocket socket = new ITargetControl.TargetSocket();
            socket.host = "localhost";
            socket.port = tunnel.getLocalPort();
            return socket;
        }
        catch (Exception e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.ptp.remotetools.environment.remotesimulator", 0, Messages.TargetControl_CouldNotCreateSocket, (Throwable)e));
        }
    }

    protected String getPluginId() {
        return "org.eclipse.ptp.remotetools.environment.remotesimulator";
    }

    private void checkControlConfig() throws CoreException {
        ControlAttributes controlAttributes = new ControlAttributes(this.targetElement.getAttributes());
        ConfigFactory configFactory = new ConfigFactory(controlAttributes);
        IStatus status = configFactory.checkTargetConfig();
        if (!status.isOK()) {
            throw new CoreException(status);
        }
    }

    private void createConsoles() {
    }

    public String getSystemWorkspace() {
        return this.currentTargetConfig.getSystemWorkspace();
    }

    public void destroy() throws CoreException {
        try {
            this.terminateJobs(null);
        }
        finally {
            this.disconnect();
            this.disconnectRemoteHost();
        }
    }
}

