/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.cell.debug.be.cdi.model.spu;

import java.util.ArrayList;
import org.eclipse.cdt.debug.core.cdi.model.ICDITarget;
import org.eclipse.cdt.debug.core.model.ICDebugTarget;
import org.eclipse.cdt.debug.mi.core.MIException;
import org.eclipse.cdt.debug.mi.core.MISession;
import org.eclipse.cdt.debug.mi.core.cdi.model.Target;
import org.eclipse.cdt.debug.mi.core.command.Command;
import org.eclipse.cdt.debug.mi.core.command.CommandFactory;
import org.eclipse.cdt.debug.mi.core.output.MIInfo;
import org.eclipse.ptp.cell.debug.be.BEMessages;
import org.eclipse.ptp.cell.debug.be.cdi.command.CellMISPUDMAInfo;
import org.eclipse.ptp.cell.debug.be.cdi.command.CellMISPUDMAInfoInfo;
import org.eclipse.ptp.cell.debug.be.cdi.command.CellMISPUEventInfo;
import org.eclipse.ptp.cell.debug.be.cdi.command.CellMISPUEventInfoInfo;
import org.eclipse.ptp.cell.debug.be.cdi.command.CellMISPUMailboxInfo;
import org.eclipse.ptp.cell.debug.be.cdi.command.CellMISPUMailboxInfoInfo;
import org.eclipse.ptp.cell.debug.be.cdi.command.CellMISPUProxyDMAInfo;
import org.eclipse.ptp.cell.debug.be.cdi.command.CellMISPUProxyDMAInfoInfo;
import org.eclipse.ptp.cell.debug.be.cdi.command.CellMISPUSignalInfo;
import org.eclipse.ptp.cell.debug.be.cdi.command.CellMISPUSignalInfoInfo;
import org.eclipse.ptp.cell.debug.be.cdi.command.factories.StandardCellCommandFactory;
import org.eclipse.ptp.cell.debug.be.cdi.command.output.MISPUDMAElement;
import org.eclipse.ptp.cell.debug.be.cdi.command.output.MISPUDMAListTuple;
import org.eclipse.ptp.cell.debug.be.cdi.command.output.MISPUEvent;
import org.eclipse.ptp.cell.debug.be.cdi.command.output.MISPUMailbox;
import org.eclipse.ptp.cell.debug.be.cdi.command.output.MISPUProxyDMAElement;
import org.eclipse.ptp.cell.debug.be.cdi.command.output.MISPUSignal;

public class SPUEnhancementsProcessor {
    private int count = 0;

    public MISPUEvent[] processSPUEvent(ICDebugTarget cTarget) {
        StandardCellCommandFactory cellFactory;
        Target target = this.processCTarget(cTarget);
        if (target != null && (cellFactory = this.processCommandFactory(target.getMISession().getCommandFactory())) != null) {
            CellMISPUEventInfo evinfo = cellFactory.createMISPUEventInfo();
            MISession miSession = target.getMISession();
            try {
                miSession.postCommand((Command)evinfo);
                MIInfo info = evinfo.getMIInfo();
                if (info != null && info instanceof CellMISPUEventInfoInfo) {
                    return ((CellMISPUEventInfoInfo)info).getEvents();
                }
            }
            catch (MIException mIException) {
                ArrayList<MISPUEvent> events = new ArrayList<MISPUEvent>();
                events.add(new MISPUEvent("event_mask", BEMessages.getString("SPUEnhancementsProcessor.0")));
                events.add(new MISPUEvent("event_status", BEMessages.getString("SPUEnhancementsProcessor.1")));
                return events.toArray(new MISPUEvent[0]);
            }
        }
        ArrayList<MISPUEvent> events = new ArrayList<MISPUEvent>();
        events.add(new MISPUEvent("event_mask", BEMessages.getString("SPUEnhancementsProcessor.2")));
        events.add(new MISPUEvent("event_status", BEMessages.getString("SPUEnhancementsProcessor.3")));
        return events.toArray(new MISPUEvent[0]);
    }

    public MISPUSignal[] processSPUSignal(ICDebugTarget cTarget) {
        StandardCellCommandFactory cellFactory;
        Target target = this.processCTarget(cTarget);
        if (target != null && (cellFactory = this.processCommandFactory(target.getMISession().getCommandFactory())) != null) {
            CellMISPUSignalInfo evinfo = cellFactory.createMISPUSignalInfo();
            MISession miSession = target.getMISession();
            try {
                miSession.postCommand((Command)evinfo);
                MIInfo info = evinfo.getMIInfo();
                if (info != null && info instanceof CellMISPUSignalInfoInfo) {
                    return ((CellMISPUSignalInfoInfo)info).getSignals();
                }
            }
            catch (MIException mIException) {
                ArrayList<MISPUSignal> signals = new ArrayList<MISPUSignal>();
                signals.add(new MISPUSignal("signal1_pending", BEMessages.getString("SPUEnhancementsProcessor.0")));
                signals.add(new MISPUSignal("signal1", BEMessages.getString("SPUEnhancementsProcessor.0")));
                signals.add(new MISPUSignal("signal1_type", BEMessages.getString("SPUEnhancementsProcessor.0")));
                signals.add(new MISPUSignal("signal2_pending", BEMessages.getString("SPUEnhancementsProcessor.0")));
                signals.add(new MISPUSignal("signal2", BEMessages.getString("SPUEnhancementsProcessor.0")));
                signals.add(new MISPUSignal("signal2_type", BEMessages.getString("SPUEnhancementsProcessor.0")));
                return signals.toArray(new MISPUSignal[0]);
            }
        }
        ArrayList<MISPUSignal> signals = new ArrayList<MISPUSignal>();
        signals.add(new MISPUSignal("signal1_pending", BEMessages.getString("SPUEnhancementsProcessor.2")));
        signals.add(new MISPUSignal("signal1", BEMessages.getString("SPUEnhancementsProcessor.2")));
        signals.add(new MISPUSignal("signal1_type", BEMessages.getString("SPUEnhancementsProcessor.2")));
        signals.add(new MISPUSignal("signal2_pending", BEMessages.getString("SPUEnhancementsProcessor.2")));
        signals.add(new MISPUSignal("signal2", BEMessages.getString("SPUEnhancementsProcessor.2")));
        signals.add(new MISPUSignal("signal2_type", BEMessages.getString("SPUEnhancementsProcessor.2")));
        return signals.toArray(new MISPUSignal[0]);
    }

    public MISPUMailbox[] processSPUMailbox(ICDebugTarget cTarget) {
        StandardCellCommandFactory cellFactory;
        Target target = this.processCTarget(cTarget);
        if (target != null && (cellFactory = this.processCommandFactory(target.getMISession().getCommandFactory())) != null) {
            CellMISPUMailboxInfo evinfo = cellFactory.createMISPUMailboxInfo();
            MISession miSession = target.getMISession();
            try {
                miSession.postCommand((Command)evinfo);
                MIInfo info = evinfo.getMIInfo();
                if (info != null && info instanceof CellMISPUMailboxInfoInfo) {
                    return ((CellMISPUMailboxInfoInfo)info).getMailboxes();
                }
            }
            catch (MIException mIException) {
                ArrayList<MISPUMailbox> mboxs = new ArrayList<MISPUMailbox>();
                mboxs.add(new MISPUMailbox("mbox", BEMessages.getString("SPUEnhancementsProcessor.0"), Integer.toString(0)));
                mboxs.add(new MISPUMailbox("ibox", BEMessages.getString("SPUEnhancementsProcessor.0"), Integer.toString(0)));
                mboxs.add(new MISPUMailbox("wbox", BEMessages.getString("SPUEnhancementsProcessor.0"), Integer.toString(0)));
                return mboxs.toArray(new MISPUMailbox[0]);
            }
        }
        ArrayList<MISPUMailbox> mboxs = new ArrayList<MISPUMailbox>();
        mboxs.add(new MISPUMailbox("mbox", BEMessages.getString("SPUEnhancementsProcessor.2"), Integer.toString(0)));
        mboxs.add(new MISPUMailbox("ibox", BEMessages.getString("SPUEnhancementsProcessor.2"), Integer.toString(0)));
        mboxs.add(new MISPUMailbox("wbox", BEMessages.getString("SPUEnhancementsProcessor.2"), Integer.toString(0)));
        return mboxs.toArray(new MISPUMailbox[0]);
    }

    public Object[] processSPUDMA(ICDebugTarget cTarget) {
        StandardCellCommandFactory cellFactory;
        Target target = this.processCTarget(cTarget);
        if (target != null && (cellFactory = this.processCommandFactory(target.getMISession().getCommandFactory())) != null) {
            CellMISPUDMAInfo evinfo = cellFactory.createMISPUDMAInfo();
            MISession miSession = target.getMISession();
            try {
                miSession.postCommand((Command)evinfo);
                MIInfo info = evinfo.getMIInfo();
                if (info != null && info instanceof CellMISPUDMAInfoInfo) {
                    MISPUDMAElement[] cmds = ((CellMISPUDMAInfoInfo)info).getDMAcmds();
                    MISPUDMAListTuple[] cmdlist = ((CellMISPUDMAInfoInfo)info).getDMAcmdlist();
                    return new Object[]{cmds, cmdlist};
                }
            }
            catch (MIException mIException) {
                ++this.count;
                ArrayList<MISPUDMAListTuple> aList = new ArrayList<MISPUDMAListTuple>();
                ArrayList<MISPUDMAElement> bList = new ArrayList<MISPUDMAElement>();
                aList.add(new MISPUDMAListTuple(BEMessages.getString("SPUEnhancementsProcessor.0"), BEMessages.getString("SPUEnhancementsProcessor.0"), BEMessages.getString("SPUEnhancementsProcessor.0"), BEMessages.getString("SPUEnhancementsProcessor.0"), BEMessages.getString("SPUEnhancementsProcessor.0"), BEMessages.getString("SPUEnhancementsProcessor.0"), BEMessages.getString("SPUEnhancementsProcessor.0"), BEMessages.getString("SPUEnhancementsProcessor.0"), BEMessages.getString("SPUEnhancementsProcessor.0"), BEMessages.getString("SPUEnhancementsProcessor.0")));
                bList.add(new MISPUDMAElement("dma_info_type", BEMessages.getString("SPUEnhancementsProcessor.0")));
                bList.add(new MISPUDMAElement("dma_info_mask", BEMessages.getString("SPUEnhancementsProcessor.0")));
                bList.add(new MISPUDMAElement("dma_info_status", BEMessages.getString("SPUEnhancementsProcessor.0")));
                bList.add(new MISPUDMAElement("dma_info_stall_and_notify", BEMessages.getString("SPUEnhancementsProcessor.0")));
                bList.add(new MISPUDMAElement("dma_info_atomic_command_status", BEMessages.getString("SPUEnhancementsProcessor.0")));
                MISPUDMAListTuple[] cmdlist = aList.toArray(new MISPUDMAListTuple[0]);
                MISPUDMAElement[] cmds = bList.toArray(new MISPUDMAElement[0]);
                return new Object[]{cmds, cmdlist};
            }
        }
        ArrayList<MISPUDMAListTuple> aList = new ArrayList<MISPUDMAListTuple>();
        ArrayList<MISPUDMAElement> bList = new ArrayList<MISPUDMAElement>();
        aList.add(new MISPUDMAListTuple(BEMessages.getString("SPUEnhancementsProcessor.2"), BEMessages.getString("SPUEnhancementsProcessor.2"), BEMessages.getString("SPUEnhancementsProcessor.2"), BEMessages.getString("SPUEnhancementsProcessor.2"), BEMessages.getString("SPUEnhancementsProcessor.2"), BEMessages.getString("SPUEnhancementsProcessor.2"), BEMessages.getString("SPUEnhancementsProcessor.2"), BEMessages.getString("SPUEnhancementsProcessor.2"), BEMessages.getString("SPUEnhancementsProcessor.2"), BEMessages.getString("SPUEnhancementsProcessor.2")));
        bList.add(new MISPUDMAElement("dma_info_type", BEMessages.getString("SPUEnhancementsProcessor.2")));
        bList.add(new MISPUDMAElement("dma_info_mask", BEMessages.getString("SPUEnhancementsProcessor.2")));
        bList.add(new MISPUDMAElement("dma_info_status", BEMessages.getString("SPUEnhancementsProcessor.2")));
        bList.add(new MISPUDMAElement("dma_info_stall_and_notify", BEMessages.getString("SPUEnhancementsProcessor.2")));
        bList.add(new MISPUDMAElement("dma_info_atomic_command_status", BEMessages.getString("SPUEnhancementsProcessor.2")));
        MISPUDMAListTuple[] cmdlist = aList.toArray(new MISPUDMAListTuple[0]);
        MISPUDMAElement[] cmds = bList.toArray(new MISPUDMAElement[0]);
        return new Object[]{cmds, cmdlist};
    }

    public Object[] processSPUProxyDMA(ICDebugTarget cTarget) {
        StandardCellCommandFactory cellFactory;
        Target target = this.processCTarget(cTarget);
        if (target != null && (cellFactory = this.processCommandFactory(target.getMISession().getCommandFactory())) != null) {
            CellMISPUProxyDMAInfo evinfo = cellFactory.createMISPUProxyDMAInfo();
            MISession miSession = target.getMISession();
            try {
                miSession.postCommand((Command)evinfo);
                MIInfo info = evinfo.getMIInfo();
                if (info != null && info instanceof CellMISPUProxyDMAInfoInfo) {
                    MISPUProxyDMAElement[] cmds = ((CellMISPUProxyDMAInfoInfo)info).getProxyDMAcmds();
                    MISPUDMAListTuple[] cmdlist = ((CellMISPUProxyDMAInfoInfo)info).getProxyDMAcmdlist();
                    return new Object[]{cmds, cmdlist};
                }
            }
            catch (MIException mIException) {
                ++this.count;
                ArrayList<MISPUDMAListTuple> aList = new ArrayList<MISPUDMAListTuple>();
                ArrayList<MISPUProxyDMAElement> bList = new ArrayList<MISPUProxyDMAElement>();
                aList.add(new MISPUDMAListTuple(BEMessages.getString("SPUEnhancementsProcessor.0"), BEMessages.getString("SPUEnhancementsProcessor.0"), BEMessages.getString("SPUEnhancementsProcessor.0"), BEMessages.getString("SPUEnhancementsProcessor.0"), BEMessages.getString("SPUEnhancementsProcessor.0"), BEMessages.getString("SPUEnhancementsProcessor.0"), BEMessages.getString("SPUEnhancementsProcessor.0"), BEMessages.getString("SPUEnhancementsProcessor.0"), BEMessages.getString("SPUEnhancementsProcessor.0"), BEMessages.getString("SPUEnhancementsProcessor.0")));
                bList.add(new MISPUProxyDMAElement("proxydma_info_type", BEMessages.getString("SPUEnhancementsProcessor.0")));
                bList.add(new MISPUProxyDMAElement("proxydma_info_mask", BEMessages.getString("SPUEnhancementsProcessor.0")));
                bList.add(new MISPUProxyDMAElement("proxydma_info_status", BEMessages.getString("SPUEnhancementsProcessor.0")));
                MISPUDMAListTuple[] cmdlist = aList.toArray(new MISPUDMAListTuple[0]);
                MISPUProxyDMAElement[] cmds = bList.toArray(new MISPUProxyDMAElement[0]);
                return new Object[]{cmds, cmdlist};
            }
        }
        ArrayList<MISPUDMAListTuple> aList = new ArrayList<MISPUDMAListTuple>();
        ArrayList<MISPUProxyDMAElement> bList = new ArrayList<MISPUProxyDMAElement>();
        aList.add(new MISPUDMAListTuple(BEMessages.getString("SPUEnhancementsProcessor.2"), BEMessages.getString("SPUEnhancementsProcessor.2"), BEMessages.getString("SPUEnhancementsProcessor.2"), BEMessages.getString("SPUEnhancementsProcessor.2"), BEMessages.getString("SPUEnhancementsProcessor.2"), BEMessages.getString("SPUEnhancementsProcessor.2"), BEMessages.getString("SPUEnhancementsProcessor.2"), BEMessages.getString("SPUEnhancementsProcessor.2"), BEMessages.getString("SPUEnhancementsProcessor.2"), BEMessages.getString("SPUEnhancementsProcessor.2")));
        bList.add(new MISPUProxyDMAElement("proxydma_info_type", BEMessages.getString("SPUEnhancementsProcessor.2")));
        bList.add(new MISPUProxyDMAElement("proxydma_info_mask", BEMessages.getString("SPUEnhancementsProcessor.2")));
        bList.add(new MISPUProxyDMAElement("proxydma_info_status", BEMessages.getString("SPUEnhancementsProcessor.2")));
        MISPUDMAListTuple[] cmdlist = aList.toArray(new MISPUDMAListTuple[0]);
        MISPUProxyDMAElement[] cmds = bList.toArray(new MISPUProxyDMAElement[0]);
        return new Object[]{cmds, cmdlist};
    }

    private Target processCTarget(ICDebugTarget cTarget) {
        ICDITarget cdiTarget;
        Target target = null;
        if (cTarget != null && (cdiTarget = (ICDITarget)cTarget.getAdapter(ICDITarget.class)) != null && cdiTarget instanceof Target) {
            target = (Target)cdiTarget;
        }
        return target;
    }

    private StandardCellCommandFactory processCommandFactory(CommandFactory factory) {
        StandardCellCommandFactory cellFactory = null;
        if (factory != null && factory instanceof StandardCellCommandFactory) {
            cellFactory = (StandardCellCommandFactory)factory;
        }
        return cellFactory;
    }
}

