/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.cell.pdt.xml.wizard.ui;

import java.util.LinkedList;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ptp.cell.pdt.xml.core.eventgroup.AbstractEventElement;
import org.eclipse.ptp.cell.pdt.xml.core.eventgroup.Event;
import org.eclipse.ptp.cell.pdt.xml.core.eventgroup.EventGroup;
import org.eclipse.ptp.cell.pdt.xml.core.eventgroup.EventGroupForest;
import org.eclipse.ptp.cell.pdt.xml.core.eventgroup.EventSubgroup;
import org.eclipse.ptp.cell.pdt.xml.wizard.ui.Messages;

public class PdtEventTreeContentProvider
implements IContentProvider,
ITreeContentProvider {
    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public Object[] getChildren(Object parentElement) {
        this.checkParameterValidity(parentElement);
        if (parentElement instanceof EventGroupForest) {
            EventGroupForest root = (EventGroupForest)parentElement;
            return root.getVisibleGroups().toArray();
        }
        if (parentElement instanceof EventGroup) {
            EventGroup group = (EventGroup)parentElement;
            return group.getSubgroups().toArray();
        }
        if (parentElement instanceof EventSubgroup) {
            EventSubgroup subgroup = (EventSubgroup)parentElement;
            return subgroup.getEvents().toArray();
        }
        return new Object[0];
    }

    public Object getParent(Object element) {
        this.checkParameterValidity(element);
        if (element instanceof EventGroupForest) {
            return null;
        }
        if (element instanceof EventGroup) {
            return null;
        }
        if (element instanceof EventSubgroup) {
            EventSubgroup subgroup = (EventSubgroup)element;
            return subgroup.getParent();
        }
        Event event = (Event)element;
        return event.getParent();
    }

    public boolean hasChildren(Object element) {
        this.checkParameterValidity(element);
        if (element instanceof EventGroupForest) {
            EventGroupForest root = (EventGroupForest)element;
            return !root.getVisibleGroups().isEmpty();
        }
        if (element instanceof EventGroup) {
            EventGroup group = (EventGroup)element;
            return !group.getSubgroups().isEmpty();
        }
        if (element instanceof EventSubgroup) {
            EventSubgroup subgroup = (EventSubgroup)element;
            return !subgroup.getEvents().isEmpty();
        }
        return false;
    }

    public Object[] getElements(Object inputElement) {
        this.checkParameterValidity(inputElement);
        LinkedList<EventGroup> eventGroupList = new LinkedList<EventGroup>();
        for (EventGroup eventGroup : ((EventGroupForest)inputElement).getVisibleGroups()) {
            if (eventGroup.getName().equals(EventGroup.GENERAL_GROUP)) continue;
            eventGroupList.add(eventGroup);
        }
        return eventGroupList.toArray();
    }

    private void checkParameterValidity(Object parameter) {
        assert (parameter instanceof AbstractEventElement) : Messages.PdtEventTreeContentProvider_ValidateParameter_ParameterMustBeDerivedFromAbstractEventElement;
    }
}

