/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.cell.managedbuilder.core;

import java.util.regex.Pattern;
import org.eclipse.cdt.managedbuilder.core.IManagedCommandLineGenerator;
import org.eclipse.cdt.managedbuilder.core.IManagedCommandLineInfo;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.internal.core.ManagedCommandLineInfo;

public class EmbedSPUCommandLineGenerator
implements IManagedCommandLineGenerator {
    public final String WHITESPACE = " ";
    public final String CMD_LINE_PRM_NAME = "\\$\\{COMMAND\\}";
    public final String FLAGS_PRM_NAME = "\\$\\{FLAGS\\}";
    public final String OUTPUT_FLAG_PRM_NAME = "\\$\\{OUTPUT_FLAG\\}";
    public final String OUTPUT_PREFIX_PRM_NAME = "\\$\\{OUTPUT_PREFIX\\}";
    public final String OUTPUT_PRM_NAME = "\\$\\{OUTPUT\\}";
    public final String INPUTS_PRM_NAME = "\\$\\{INPUTS\\}";
    public final char BACKSLASH = (char)92;
    public final char DOLLAR = (char)36;
    public final char SCAPE_CHAR = (char)92;

    public IManagedCommandLineInfo generateCommandLineInfo(ITool tool, String commandName, String[] flags, String outputFlag, String outputPrefix, String outputName, String[] inputResources, String commandLinePattern) {
        if (commandLinePattern == null || commandLinePattern.length() <= 0) {
            commandLinePattern = "${COMMAND} ${FLAGS} ${OUTPUT_FLAG}${OUTPUT_PREFIX}${OUTPUT} ${INPUTS}";
        }
        String commandLine = this.replace(commandLinePattern, "\\$\\{COMMAND\\}", commandName.trim());
        commandLine = this.replace(commandLine, "\\$\\{FLAGS\\}", this.stringArrayToString(flags));
        commandLine = this.replace(commandLine, "\\$\\{OUTPUT_FLAG\\}", outputFlag.trim());
        commandLine = this.replace(commandLine, "\\$\\{OUTPUT_PREFIX\\}", outputPrefix.trim());
        commandLine = this.replace(commandLine, "\\$\\{OUTPUT\\}", outputName.trim());
        commandLine = this.replace(commandLine, "\\$\\{INPUTS\\}", this.stringArrayToString(inputResources));
        return new ManagedCommandLineInfo(commandLine.trim(), commandLinePattern, commandName, this.stringArrayToString(flags), outputFlag, outputPrefix, outputName, this.stringArrayToString(inputResources));
    }

    private String stringArrayToString(String[] array) {
        if (array == null || array.length <= 0) {
            return new String();
        }
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < array.length) {
            sb.append(String.valueOf(array[i]) + " ");
            ++i;
        }
        return sb.toString().trim();
    }

    private String replace(String string, String regex, String replacement) {
        if (replacement.indexOf(92) != -1 || replacement.indexOf(36) != -1) {
            StringBuffer sb = new StringBuffer();
            int i = 0;
            while (i < replacement.length()) {
                char c = replacement.charAt(i);
                if (c == '\\' || c == '$') {
                    sb.append('\\');
                }
                sb.append(c);
                ++i;
            }
            replacement = sb.toString();
        }
        return Pattern.compile(regex).matcher(string).replaceAll(replacement);
    }
}

