/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rdt.services.internal.core;

import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.ptp.rdt.services.core.IService;
import org.eclipse.ptp.rdt.services.core.IServiceConfiguration;
import org.eclipse.ptp.rdt.services.core.IServiceProvider;
import org.eclipse.ptp.rdt.services.core.ServiceModelManager;
import org.eclipse.ptp.rdt.services.internal.core.ServiceModelEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceConfiguration
extends PlatformObject
implements IServiceConfiguration {
    protected String fName;
    protected ServiceModelManager fManager = ServiceModelManager.getInstance();
    protected Map<IService, IServiceProvider> fServiceToProviderMap = new HashMap<IService, IServiceProvider>();
    protected Map<IService, LinkedHashSet<IServiceProvider>> fFormerServiceProviders = new HashMap<IService, LinkedHashSet<IServiceProvider>>();

    public ServiceConfiguration(String name) {
        this.fName = name;
    }

    @Override
    public String getName() {
        return this.fName;
    }

    @Override
    public IServiceProvider getServiceProvider(IService service) {
        IServiceProvider activeProvider = this.fServiceToProviderMap.get(service);
        return activeProvider == null ? service.getNullProvider() : activeProvider;
    }

    public Set<IServiceProvider> getFormerServiceProviders(IService service) {
        Set disabledProviders = this.fFormerServiceProviders.get(service);
        return disabledProviders == null ? Collections.emptySet() : disabledProviders;
    }

    @Override
    public Set<IService> getServices() {
        return Collections.unmodifiableSet(this.fServiceToProviderMap.keySet());
    }

    @Override
    public SortedSet<IService> getServicesByPriority() {
        TreeSet<IService> sortedServices = new TreeSet<IService>(new Comparator<IService>(){

            @Override
            public int compare(IService o1, IService o2) {
                int cmp = o1.getPriority().compareTo(o2.getPriority());
                if (cmp != 0) {
                    return cmp;
                }
                return o1.getId().compareTo(o2.getId());
            }
        });
        sortedServices.addAll(this.getServices());
        return sortedServices;
    }

    public void removeService(IService service) {
        IServiceProvider oldProvider = this.fServiceToProviderMap.remove(service);
        this.fFormerServiceProviders.remove(service);
        this.fManager.notifyListeners(new ServiceModelEvent(this, 4, oldProvider));
    }

    @Override
    public void setName(String name) {
        this.fName = name;
    }

    @Override
    public void setServiceProvider(IService service, IServiceProvider provider) {
        IServiceProvider oldProvider;
        if (provider != null && provider.equals(service.getNullProvider())) {
            provider = null;
        }
        if ((oldProvider = provider == null ? this.fServiceToProviderMap.remove(service) : this.fServiceToProviderMap.put(service, provider)) != null) {
            this.addFormerServiceProvider(service, oldProvider);
            this.fFormerServiceProviders.get(service).remove(provider);
        }
        this.fManager.notifyListeners(new ServiceModelEvent(this, 4, oldProvider));
    }

    public void addFormerServiceProvider(IService service, IServiceProvider disabledProvider) {
        if (disabledProvider == null) {
            return;
        }
        LinkedHashSet<IServiceProvider> disabledServices = this.fFormerServiceProviders.get(service);
        if (disabledServices == null) {
            disabledServices = new LinkedHashSet();
            this.fFormerServiceProviders.put(service, disabledServices);
        }
        disabledServices.add(disabledProvider);
    }

    public String toString() {
        return "ServiceConfiguration: " + this.fName + " -> " + this.fServiceToProviderMap;
    }

    @Override
    public void disable(IService service) {
        this.setServiceProvider(service, null);
    }

    @Override
    public boolean isDisabled(IService service) {
        return !this.fServiceToProviderMap.containsKey(service);
    }
}

