/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rdt.services.ui;

import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.eclipse.ptp.rdt.services.core.IService;
import org.eclipse.ptp.rdt.services.core.IServiceCategory;
import org.eclipse.ptp.rdt.services.core.IServiceConfiguration;
import org.eclipse.ptp.rdt.services.core.IServiceProvider;
import org.eclipse.ptp.rdt.services.core.IServiceProviderDescriptor;
import org.eclipse.ptp.rdt.services.core.ServiceModelManager;
import org.eclipse.ptp.rdt.services.internal.core.ServiceConfiguration;
import org.eclipse.ptp.rdt.services.ui.IServiceProviderContributor;
import org.eclipse.ptp.rdt.services.ui.Messages;
import org.eclipse.ptp.rdt.services.ui.ServiceModelUIManager;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NewServiceModelWidget
extends Composite {
    private static final String SERVICE_KEY = "service";
    private static final String DISABLED_KEY = "disabled";
    private static final String PROVIDER_KEY = "provider";
    private IServiceConfiguration configuration;
    private Tree servicesTree;
    private Button enabledCheckbox;
    private Combo providerCombo;
    private Composite configurationComposite;
    private Composite providerComposite;
    private StackLayout stackLayout;
    private Image enabledIcon;
    private Image disabledIcon;
    private Image configIcon;
    private Map<String, IServiceProvider> providerMap = new HashMap<String, IServiceProvider>();
    private static Comparator<IServiceCategory> CATEGORY_COMPARATOR = new Comparator<IServiceCategory>(){

        @Override
        public int compare(IServiceCategory x, IServiceCategory y) {
            return x.getName().compareTo(y.getName());
        }
    };
    private static Comparator<IService> SERVICE_COMPARATOR = new Comparator<IService>(){

        @Override
        public int compare(IService x, IService y) {
            return NewServiceModelWidget.comparePriorities(x.getPriority(), y.getPriority(), x.getName(), y.getName());
        }
    };
    private static Comparator<IServiceProviderDescriptor> PROVIDER_COMPARATOR = new Comparator<IServiceProviderDescriptor>(){

        @Override
        public int compare(IServiceProviderDescriptor x, IServiceProviderDescriptor y) {
            return NewServiceModelWidget.comparePriorities(x.getPriority(), y.getPriority(), x.getName(), y.getName());
        }
    };

    public NewServiceModelWidget(Composite parent, int style) {
        super(parent, style);
        this.setLayout((Layout)new GridLayout(2, false));
        Label label = new Label((Composite)this, 0);
        label.setLayoutData((Object)new GridData());
        label.setText(Messages.NewServiceModelWidget_0);
        Label filler = new Label((Composite)this, 0);
        filler.setLayoutData((Object)new GridData());
        filler.setText("");
        Composite left = new Composite((Composite)this, 0);
        GridData data = new GridData(1040);
        data.widthHint = 200;
        left.setLayoutData((Object)data);
        GridLayout layout = new GridLayout(1, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        left.setLayout((Layout)layout);
        this.servicesTree = new Tree(left, 2052);
        this.servicesTree.setLayoutData((Object)new GridData(1808));
        this.servicesTree.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NewServiceModelWidget.this.displayService(NewServiceModelWidget.this.servicesTree.getSelection()[0]);
            }
        });
        this.providerComposite = new Composite((Composite)this, 0);
        this.providerComposite.setLayoutData((Object)new GridData(1808));
        this.providerComposite.setLayout((Layout)new GridLayout(1, false));
        this.enabledCheckbox = new Button(this.providerComposite, 32);
        this.enabledCheckbox.setText(Messages.NewServiceModelWidget_1);
        this.enabledCheckbox.setLayoutData((Object)new GridData());
        this.enabledCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean checked = NewServiceModelWidget.this.enabledCheckbox.getSelection();
                NewServiceModelWidget.this.changeServiceState(!checked);
            }
        });
        this.enabledCheckbox.setEnabled(false);
        Label provider = new Label(this.providerComposite, 0);
        provider.setText(Messages.NewServiceModelWidget_2);
        provider.setLayoutData((Object)new GridData());
        provider.setEnabled(false);
        this.providerCombo = new Combo(this.providerComposite, 12);
        data = new GridData(768);
        data.widthHint = 250;
        this.providerCombo.setLayoutData((Object)data);
        this.providerCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IServiceProviderDescriptor[] descriptors = (IServiceProviderDescriptor[])NewServiceModelWidget.this.providerCombo.getData();
                NewServiceModelWidget.this.selectProvider(descriptors[NewServiceModelWidget.this.providerCombo.getSelectionIndex()]);
            }
        });
        this.providerCombo.setEnabled(false);
        Label separator = new Label(this.providerComposite, 266);
        separator.setLayoutData((Object)new GridData(768));
        this.configurationComposite = new Composite(this.providerComposite, 0);
        data = new GridData(1808);
        data.horizontalSpan = 2;
        this.configurationComposite.setLayoutData((Object)data);
        this.stackLayout = new StackLayout();
        this.stackLayout.marginHeight = 0;
        this.stackLayout.marginWidth = 0;
        this.configurationComposite.setLayout((Layout)this.stackLayout);
        this.enabledIcon = new Image((Device)this.getDisplay(), ((Object)((Object)this)).getClass().getResourceAsStream("/icons/etool16/service.gif"));
        this.disabledIcon = new Image((Device)this.getDisplay(), ((Object)((Object)this)).getClass().getResourceAsStream("/icons/etool16/service-disabled.gif"));
        this.configIcon = new Image((Device)this.getDisplay(), ((Object)((Object)this)).getClass().getResourceAsStream("/icons/etool16/service-category.gif"));
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                NewServiceModelWidget.this.enabledIcon.dispose();
                NewServiceModelWidget.this.disabledIcon.dispose();
                NewServiceModelWidget.this.configIcon.dispose();
            }
        });
    }

    public void setServiceConfiguration(IServiceConfiguration conf) {
        this.setServiceConfiguration(conf, null);
    }

    public void setServiceConfiguration(IServiceConfiguration configuration, Set<String> natureIds) {
        this.configuration = configuration;
        this.createTreeContent(natureIds);
        this.displayService(null);
    }

    public IServiceConfiguration getServiceConfiguration() {
        return this.configuration;
    }

    protected void displayService(TreeItem serviceTreeItem) {
        IService service = null;
        if (serviceTreeItem != null) {
            service = (IService)serviceTreeItem.getData(SERVICE_KEY);
        }
        this.providerCombo.removeAll();
        Control[] controlArray = this.providerComposite.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            child.setEnabled(service != null);
            ++n2;
        }
        if (service == null) {
            this.stackLayout.topControl = null;
            this.configurationComposite.layout();
            return;
        }
        IServiceProvider provider = (IServiceProvider)serviceTreeItem.getData(PROVIDER_KEY);
        if (provider == null && !this.configuration.isDisabled(service)) {
            provider = this.configuration.getServiceProvider(service);
        }
        Set<IServiceProviderDescriptor> providers = service.getProviders();
        IServiceProviderDescriptor[] descriptors = providers.toArray(new IServiceProviderDescriptor[0]);
        Arrays.sort(descriptors, PROVIDER_COMPARATOR);
        int selection = 0;
        int i = 0;
        while (i < descriptors.length) {
            this.providerCombo.add(descriptors[i].getName());
            if (provider != null && provider.getId().equals(descriptors[i].getId())) {
                selection = i;
            }
            ++i;
        }
        this.providerCombo.setData((Object)descriptors);
        this.providerCombo.select(selection);
        boolean disabled = Boolean.TRUE.equals(serviceTreeItem.getData(DISABLED_KEY));
        this.providerCombo.setEnabled(!disabled);
        this.enabledCheckbox.setSelection(!disabled);
        if (disabled) {
            this.stackLayout.topControl = null;
            this.configurationComposite.layout();
        } else {
            this.selectProvider(descriptors[selection]);
        }
    }

    private void selectProvider(IServiceProviderDescriptor descriptor) {
        TreeItem serviceTreeItem = this.servicesTree.getSelection()[0];
        IServiceProvider newProvider = this.providerMap.get(descriptor.getId());
        if (newProvider == null) {
            newProvider = ServiceModelManager.getInstance().getServiceProvider(descriptor);
            this.providerMap.put(newProvider.getId(), newProvider);
            IService service = (IService)serviceTreeItem.getData(SERVICE_KEY);
            IServiceProvider existingProvider = this.getExistingProvider(newProvider.getId(), service);
            if (existingProvider != null) {
                for (String key : existingProvider.keySet()) {
                    newProvider.putString(key, existingProvider.getString(key, null));
                }
            }
        }
        serviceTreeItem.setData(PROVIDER_KEY, (Object)newProvider);
        Composite comp = new Composite(this.configurationComposite, 0);
        GridLayout layout = new GridLayout(1, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        comp.setLayout((Layout)layout);
        ServiceModelUIManager uim = ServiceModelUIManager.getInstance();
        IServiceProviderContributor contributor = uim.getServiceProviderContributor(descriptor);
        if (contributor != null) {
            contributor.configureServiceProvider(newProvider, comp);
        }
        this.stackLayout.topControl = comp;
        this.configurationComposite.layout();
    }

    private IServiceProvider getExistingProvider(String providerId, IService service) {
        IServiceProvider setProvider = this.configuration.getServiceProvider(service);
        if (setProvider != null && providerId.equals(setProvider.getId())) {
            return setProvider;
        }
        if (this.configuration instanceof ServiceConfiguration) {
            for (IServiceProvider formerProvider : ((ServiceConfiguration)this.configuration).getFormerServiceProviders(service)) {
                if (!providerId.equals(formerProvider.getId())) continue;
                return formerProvider;
            }
        }
        return null;
    }

    protected void changeServiceState(boolean disabled) {
        TreeItem serviceTreeItem = this.servicesTree.getSelection()[0];
        serviceTreeItem.setData(DISABLED_KEY, (Object)disabled);
        serviceTreeItem.setImage(disabled ? this.disabledIcon : this.enabledIcon);
        this.displayService(serviceTreeItem);
    }

    private void createTreeContent(Set<String> filterNatureIds) {
        this.servicesTree.removeAll();
        if (this.configuration == null) {
            return;
        }
        if (filterNatureIds == null) {
            filterNatureIds = Collections.emptySet();
        }
        TreeSet<IService> defaultCategoryServices = new TreeSet<IService>(SERVICE_COMPARATOR);
        TreeMap<IServiceCategory, TreeSet<IService>> categoryServices = new TreeMap<IServiceCategory, TreeSet<IService>>(CATEGORY_COMPARATOR);
        for (IService iService : ServiceModelManager.getInstance().getServices()) {
            if (NewServiceModelWidget.filterOut(iService.getNatures(), filterNatureIds)) continue;
            IServiceCategory category = iService.getCategory();
            if (category == null) {
                defaultCategoryServices.add(iService);
                continue;
            }
            TreeSet<IService> services = (TreeSet<IService>)categoryServices.get(category);
            if (services == null) {
                services = new TreeSet<IService>(SERVICE_COMPARATOR);
                categoryServices.put(category, services);
            }
            services.add(iService);
        }
        for (Map.Entry entry : categoryServices.entrySet()) {
            TreeItem parent = this.createTreeCategory(this.servicesTree, (IServiceCategory)entry.getKey());
            for (IService service : (SortedSet)entry.getValue()) {
                this.createTreeService(parent, service);
            }
            parent.setExpanded(true);
        }
        if (!defaultCategoryServices.isEmpty()) {
            TreeItem treeItem = this.createTreeCategory(this.servicesTree, null);
            for (IService service : defaultCategoryServices) {
                this.createTreeService(treeItem, service);
            }
            treeItem.setExpanded(true);
        }
    }

    private static boolean filterOut(Set<String> serviceIds, Set<String> filterIds) {
        if (serviceIds.isEmpty() || filterIds.isEmpty()) {
            return false;
        }
        for (String id : serviceIds) {
            if (!filterIds.contains(id)) continue;
            return false;
        }
        return true;
    }

    private TreeItem createTreeCategory(Tree parent, IServiceCategory category) {
        TreeItem item = new TreeItem(this.servicesTree, 0);
        item.setText(category == null ? Messages.NewServiceModelWidget_3 : category.getName());
        item.setImage(this.configIcon);
        return item;
    }

    private void createTreeService(TreeItem parent, IService service) {
        boolean disabled = this.configuration.isDisabled(service);
        TreeItem child = new TreeItem(parent, 0);
        child.setText(service.getName());
        child.setData(SERVICE_KEY, (Object)service);
        child.setData(DISABLED_KEY, (Object)disabled);
        child.setImage(disabled ? this.disabledIcon : this.enabledIcon);
    }

    public void applyChangesToConfiguration() {
        if (this.configuration == null) {
            return;
        }
        TreeItem[] treeItemArray = this.servicesTree.getItems();
        int n = treeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem categoryTreeItem = treeItemArray[n2];
            TreeItem[] treeItemArray2 = categoryTreeItem.getItems();
            int n3 = treeItemArray2.length;
            int n4 = 0;
            while (n4 < n3) {
                TreeItem serviceTreeItem = treeItemArray2[n4];
                IService service = (IService)serviceTreeItem.getData(SERVICE_KEY);
                boolean disabled = Boolean.TRUE.equals(serviceTreeItem.getData(DISABLED_KEY));
                if (disabled) {
                    this.configuration.disable(service);
                } else {
                    IServiceProvider serviceProvider = (IServiceProvider)serviceTreeItem.getData(PROVIDER_KEY);
                    if (serviceProvider != null) {
                        this.configuration.setServiceProvider(service, serviceProvider);
                    }
                }
                ++n4;
            }
            ++n2;
        }
    }

    private static int comparePriorities(Integer p1, Integer p2, String name1, String name2) {
        if (p1 == null && p2 == null) {
            return name1.compareTo(name2);
        }
        if (p1 == null) {
            return -1;
        }
        if (p2 == null) {
            return 1;
        }
        if (p1.equals(p2)) {
            return name1.compareTo(name2);
        }
        return p1.compareTo(p2);
    }
}

