/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.remotetools.internal.ssh;

import com.jcraft.jsch.SftpATTRS;
import com.jcraft.jsch.SftpException;
import java.util.Set;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ptp.remotetools.core.IRemoteItem;
import org.eclipse.ptp.remotetools.exception.CancelException;
import org.eclipse.ptp.remotetools.exception.RemoteConnectionException;
import org.eclipse.ptp.remotetools.exception.RemoteOperationException;
import org.eclipse.ptp.remotetools.internal.ssh.FileTools;

class RemoteItem
implements IRemoteItem {
    String path;
    boolean isReadable;
    boolean isWritable;
    boolean isExecutable;
    boolean exist;
    FileTools fileTools;
    int userID;
    int permissions;
    long size;
    int accessTime;
    int modificationTime;
    protected int groupID;
    protected int changes;
    boolean isDirectory;
    protected final int PERMISSION = 1;
    protected final int MODIFICATION_TIME = 2;

    RemoteItem(FileTools fileTools, String path) {
        this.fileTools = fileTools;
        this.path = path;
    }

    RemoteItem(FileTools fileTools, String path, SftpATTRS attrs) {
        this.fileTools = fileTools;
        this.path = path;
        this.parseAttrs(attrs);
    }

    protected RemoteItem() {
    }

    protected void copyAttributesFrom(RemoteItem other) {
        this.path = other.path;
        this.isReadable = other.isReadable;
        this.isWritable = other.isWritable;
        this.isExecutable = other.isExecutable;
        this.exist = other.exist;
        this.fileTools = other.fileTools;
        this.userID = other.userID;
        this.permissions = other.permissions;
        this.size = other.size;
        this.accessTime = other.accessTime;
        this.modificationTime = other.modificationTime;
        this.groupID = other.groupID;
        this.changes = other.changes;
        this.isDirectory = other.isDirectory;
    }

    public boolean exists() {
        return this.exist;
    }

    public void refreshAttributes() throws RemoteConnectionException, RemoteOperationException, CancelException, RemoteOperationException {
        this.fileTools.test();
        SftpATTRS attrs = this.fileTools.fetchRemoteAttr(this.path);
        this.parseAttrs(attrs);
    }

    private void parseAttrs(SftpATTRS attrs) {
        Set groupIDSet;
        if (attrs == null) {
            this.exist = false;
            return;
        }
        this.exist = true;
        this.changes = 0;
        this.isDirectory = attrs.isDir();
        this.userID = attrs.getUId();
        this.groupID = attrs.getGId();
        this.permissions = attrs.getPermissions();
        this.isReadable = false;
        this.isWritable = false;
        this.isExecutable = false;
        if (this.userID == this.fileTools.cachedUserID) {
            if ((this.permissions & 0x100) != 0) {
                this.isReadable = true;
            }
            if ((this.permissions & 0x80) != 0) {
                this.isWritable = true;
            }
            if ((this.permissions & 0x40) != 0) {
                this.isExecutable = true;
            }
        }
        if ((groupIDSet = this.fileTools.cachedGroupIDSet).contains(new Integer(this.groupID))) {
            if ((this.permissions & 0x20) != 0) {
                this.isReadable = true;
            }
            if ((this.permissions & 0x10) != 0) {
                this.isWritable = true;
            }
            if ((this.permissions & 8) != 0) {
                this.isExecutable = true;
            }
        }
        if ((this.permissions & 4) != 0) {
            this.isReadable = true;
        }
        if ((this.permissions & 2) != 0) {
            this.isWritable = true;
        }
        if ((this.permissions & 1) != 0) {
            this.isExecutable = true;
        }
        this.size = attrs.getSize();
        this.accessTime = attrs.getATime();
        this.modificationTime = attrs.getMTime();
    }

    public String getPath() {
        return this.path;
    }

    public boolean isReadable() {
        return this.isReadable;
    }

    public void setReadable(boolean flag) {
        Set groupIDSet;
        int oldPermissions = this.permissions;
        if (this.userID == this.fileTools.cachedUserID) {
            this.permissions = flag ? (this.permissions |= 0x100) : (this.permissions &= 0xFFFFFEFF);
        }
        if ((groupIDSet = this.fileTools.cachedGroupIDSet).contains(new Integer(this.groupID))) {
            this.permissions = flag ? (this.permissions |= 0x20) : (this.permissions &= 0xFFFFFFDF);
        }
        this.permissions = flag ? (this.permissions |= 4) : (this.permissions &= 0xFFFFFFFB);
        if (oldPermissions != this.permissions) {
            this.changes |= 1;
        }
    }

    public boolean isWritable() {
        return this.isWritable;
    }

    public void setWriteable(boolean flag) {
        Set groupIDSet;
        int oldPermissions = this.permissions;
        if (this.userID == this.fileTools.cachedUserID) {
            this.permissions = flag ? (this.permissions |= 0x80) : (this.permissions &= 0xFFFFFF7F);
        }
        if ((groupIDSet = this.fileTools.cachedGroupIDSet).contains(new Integer(this.groupID))) {
            this.permissions = flag ? (this.permissions |= 0x10) : (this.permissions &= 0xFFFFFFEF);
        }
        this.permissions = flag ? (this.permissions |= 2) : (this.permissions &= 0xFFFFFFFD);
        if (oldPermissions != this.permissions) {
            this.changes |= 1;
        }
    }

    public long getAccessTime() {
        return (long)this.accessTime * 1000L;
    }

    public long getModificationTime() {
        return (long)this.modificationTime * 1000L;
    }

    public void setModificationTime(long time) {
        int oldModificationTime = this.modificationTime;
        this.modificationTime = (int)(time / 1000L);
        if (oldModificationTime != this.modificationTime) {
            this.changes |= 2;
        }
    }

    public void commitAttributes() throws RemoteConnectionException, CancelException, RemoteOperationException {
        this.fileTools.test();
        if ((this.changes & 1) != 0) {
            try {
                this.fileTools.manager.connection.sftpChannel.chmod(this.permissions, this.path);
                this.changes &= 0xFFFFFFFE;
            }
            catch (SftpException e) {
                throw new RemoteOperationException(NLS.bind((String)"Failed to set permission of remote file {0} ({1})", (Object[])new String[]{this.path, e.getMessage()}), e);
            }
        }
        if ((this.changes & 2) != 0) {
            try {
                this.fileTools.manager.connection.sftpChannel.setMtime(this.path, this.modificationTime);
                this.changes &= 0xFFFFFFFD;
            }
            catch (SftpException e) {
                throw new RemoteOperationException(NLS.bind((String)"Failed to set modification fime of remote file {0} ({1})", (Object[])new Object[]{this.path, e}), e);
            }
        }
    }

    protected boolean isExecutable() {
        return this.isExecutable;
    }

    protected void setExecutable(boolean flag) {
        int oldPermissions = this.permissions;
        if (this.userID == this.fileTools.cachedUserID) {
            this.permissions = flag ? (this.permissions |= 0x40) : (this.permissions &= 0xFFFFFFBF);
        }
        if (this.fileTools.cachedGroupIDSet.contains(new Integer(this.groupID))) {
            this.permissions = flag ? (this.permissions |= 8) : (this.permissions &= 0xFFFFFFF7);
        }
        this.permissions = flag ? (this.permissions |= 1) : (this.permissions &= 0xFFFFFFFE);
        if (oldPermissions != this.permissions) {
            this.changes |= 1;
        }
    }

    public boolean isDirectory() {
        return this.isDirectory;
    }

    public boolean isFile() {
        return !this.isDirectory;
    }

    public String toString() {
        if (this.exist) {
            return String.valueOf(this.path) + (this.isDirectory ? "(d)" : "(f)");
        }
        return "does not exit";
    }
}

