/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.cell.environment.cellsimulator.core.common;

import org.eclipse.ptp.cell.simulator.core.ISimulatorControl;
import org.eclipse.ptp.cell.simulator.core.ISimulatorListener;
import org.eclipse.ptp.cell.simulator.core.SimulatorException;
import org.eclipse.ptp.remotetools.environment.control.ITargetControlJobListener;
import org.eclipse.ptp.remotetools.environment.control.ITargetJob;
import org.eclipse.ptp.remotetools.environment.control.SSHTargetControl;

public class StopResumeLogic
implements ITargetControlJobListener,
ISimulatorListener {
    private int jobCounter = 0;
    private boolean alreadyResumedOnFirstJob = false;
    private ISimulatorControl simulatorControl;
    private SSHTargetControl targetControl;

    public StopResumeLogic(ISimulatorControl simulatorControl, SSHTargetControl targetControl) {
        this.simulatorControl = simulatorControl;
        this.targetControl = targetControl;
    }

    public void activate() {
        this.simulatorControl.removeListener((ISimulatorListener)this);
        this.targetControl.removeJobListener((ITargetControlJobListener)this);
        this.jobCounter = 0;
        this.simulatorControl.addListener((ISimulatorListener)this);
        this.targetControl.addJobListener((ITargetControlJobListener)this);
    }

    public void deactivate() {
        this.simulatorControl.removeListener((ISimulatorListener)this);
        this.targetControl.removeJobListener((ITargetControlJobListener)this);
    }

    public void afterJobFinish(ITargetJob job) {
        --this.jobCounter;
        if (this.jobCounter == 0 && this.simulatorControl.getStatus().isOperational()) {
            try {
                if (!this.alreadyResumedOnFirstJob) {
                    this.simulatorControl.pause();
                }
            }
            catch (SimulatorException simulatorException) {}
        }
    }

    public void beforeJobStart(ITargetJob job) {
        if (this.jobCounter == 0) {
            this.alreadyResumedOnFirstJob = !this.simulatorControl.getStatus().isPaused();
        }
        ++this.jobCounter;
    }

    public void lifecycleStateChanged(int state) {
    }

    public void progressChanged(int progress) {
    }

    public void simulationStatus(int status) {
    }
}

