/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.cell.environment.launcher.pdt.ui;

import java.io.File;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.ptp.cell.environment.launcher.pdt.debug.Debug;
import org.eclipse.ptp.cell.environment.launcher.pdt.internal.IPdtLaunchAttributes;
import org.eclipse.ptp.cell.environment.launcher.pdt.internal.PdtRemoteLaunchDelegate;
import org.eclipse.ptp.cell.environment.launcher.pdt.ui.Messages;
import org.eclipse.ptp.remotetools.environment.launcher.core.LinuxPath;
import org.eclipse.ptp.utils.ui.swt.ControlsRelationshipHandler;
import org.eclipse.ptp.utils.ui.swt.FileGroup;
import org.eclipse.ptp.utils.ui.swt.FileMold;
import org.eclipse.ptp.utils.ui.swt.Frame;
import org.eclipse.ptp.utils.ui.swt.FrameMold;
import org.eclipse.ptp.utils.ui.swt.TextGroup;
import org.eclipse.ptp.utils.ui.swt.TextMold;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class PdtEnvironmentTab
extends AbstractLaunchConfigurationTab {
    ICProject selectedProject;
    Frame xmlFileInfo;
    Button copyXmlFile;
    TextGroup remoteXmlDir;
    FileGroup localXmlFile;
    Button workspaceBrowse;
    Button useRemoteXmlFile;
    TextGroup remoteXmlFile;
    ControlsRelationshipHandler buttonHandler;
    Frame traceInfo;
    TextGroup remoteTraceFile;
    TextGroup traceFilePrefix;
    FileGroup localTraceDir;

    public void createControl(Composite parent) {
        Composite topControl = new Composite(parent, 0);
        GridLayout topLayout = new GridLayout();
        topControl.setLayout((Layout)topLayout);
        this.setControl((Control)topControl);
        PdtModifyListener pdtModifyListener = new PdtModifyListener();
        FrameMold frMold = new FrameMold("");
        TextMold tmold = new TextMold(TextMold.GRID_DATA_SPAN | TextMold.GRID_DATA_ALIGNMENT_FILL | TextMold.GRID_DATA_GRAB_EXCESS_SPACE | TextMold.LABELABOVE, "");
        FileMold fmold = new FileMold(TextMold.GRID_DATA_ALIGNMENT_FILL | TextMold.GRID_DATA_SPAN | TextMold.GRID_DATA_GRAB_EXCESS_SPACE | TextMold.LABELABOVE, Messages.getString("PdtEnvironmentTab.FileControl_Label_LocalXmlFile"), Messages.getString("PdtEnvironmentTab.FileControl_Title_SelectXmlFile"), Messages.getString("PdtEnvironmentTab.FileControl_Message_SelectXmlFile"));
        frMold.setColumns(2);
        frMold.setTitle(Messages.getString("PdtEnvironmentTab.FrameControl_Label_XmlConfFileInfo"));
        this.xmlFileInfo = new Frame(topControl, frMold);
        frMold.setColumns(1);
        frMold.setTitle(Messages.getString("PdtEnvironmentTab.FrameControl_Label_TraceFileInfo"));
        this.traceInfo = new Frame(topControl, frMold);
        this.copyXmlFile = new Button(this.xmlFileInfo.getTopUserReservedComposite(), 16);
        this.copyXmlFile.setText(Messages.getString("PdtEnvironmentTab.ButtonControl_Label_CopyXmlFileToRemote"));
        GridData cpXmlFileLayData = new GridData(4, 4, false, true);
        this.copyXmlFile.setLayoutData((Object)cpXmlFileLayData);
        this.useRemoteXmlFile = new Button(this.xmlFileInfo.getTopUserReservedComposite(), 16);
        this.useRemoteXmlFile.setText(Messages.getString("PdtEnvironmentTab.ButtonControl_Label_UseRemoteXmlFile"));
        GridData useXmlFileLayData = GridDataFactory.copyData((GridData)cpXmlFileLayData);
        this.useRemoteXmlFile.setLayoutData((Object)useXmlFileLayData);
        PdtSelectionListener pdtSelectionListener = new PdtSelectionListener();
        this.copyXmlFile.addSelectionListener((SelectionListener)pdtSelectionListener);
        tmold.setLabel(Messages.getString("PdtEnvironmentTab.TextControl_Label_RemoteDestXmlDir"));
        this.remoteXmlDir = new TextGroup(this.xmlFileInfo.getTopUserReservedComposite(), tmold);
        this.remoteXmlDir.addModifyListener((ModifyListener)pdtModifyListener);
        this.localXmlFile = new FileGroup(this.xmlFileInfo.getTopUserReservedComposite(), fmold);
        this.localXmlFile.addModifyListener((ModifyListener)pdtModifyListener);
        tmold.setLabel(Messages.getString("PdtEnvironmentTab.TextControl_Label_RemoteXmlPath"));
        this.remoteXmlFile = new TextGroup(this.xmlFileInfo.getTopUserReservedComposite(), tmold);
        this.remoteXmlFile.addModifyListener((ModifyListener)pdtModifyListener);
        this.buttonHandler = new ControlsRelationshipHandler();
        this.buttonHandler.addControlRelationship(this.copyXmlFile, new Control[]{this.localXmlFile, this.remoteXmlDir});
        this.buttonHandler.addControlRelationship(this.useRemoteXmlFile, (Control)this.remoteXmlFile);
        tmold.setLabel(Messages.getString("PdtEnvironmentTab.TextControl_Label_RemoteTraceDir"));
        this.remoteTraceFile = new TextGroup(this.traceInfo.getTopUserReservedComposite(), tmold);
        this.remoteTraceFile.addModifyListener((ModifyListener)pdtModifyListener);
        tmold.setLabel(Messages.getString("PdtEnvironmentTab.TextControl_Label_TraceFilePrefix"));
        this.traceFilePrefix = new TextGroup(this.traceInfo.getTopUserReservedComposite(), tmold);
        this.traceFilePrefix.addModifyListener((ModifyListener)pdtModifyListener);
        FileMold fMoldLocalTrace = new FileMold(FileMold.GRID_DATA_ALIGNMENT_FILL | FileMold.GRID_DATA_GRAB_EXCESS_SPACE | FileMold.LABELABOVE | FileMold.DIRECTORY_SELECTION, Messages.getString("PdtEnvironmentTab.FileControl_Label_LocalTraceDir"), Messages.getString("PdtEnvironmentTab.FileControl_Title_SelectTraceFileDir"), Messages.getString("PdtEnvironmentTab.FileControl_Message_SelectTraceFileDir"));
        this.localTraceDir = new FileGroup(this.traceInfo.getTopUserReservedComposite(), fMoldLocalTrace);
        this.localTraceDir.addModifyListener((ModifyListener)pdtModifyListener);
    }

    public String getName() {
        return Messages.getString("PdtEnvironmentTab.Tab_Title_PDT");
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        Debug.read();
        try {
            this.selectedProject = PdtRemoteLaunchDelegate.getCProject((ILaunchConfiguration)configuration);
        }
        catch (CoreException e1) {
            Debug.POLICY.logError((Throwable)e1);
            this.setErrorMessage(Messages.getString("PdtEnvironmentTab.InitializeFrom_Error_RetrivingCProj"));
        }
        try {
            this.remoteXmlDir.setString(configuration.getAttribute(IPdtLaunchAttributes.ATTR_REMOTE_XML_DIR, IPdtLaunchAttributes.DEFAULT_REMOTE_XML_DIR));
            this.localXmlFile.setString(configuration.getAttribute(IPdtLaunchAttributes.ATTR_LOCAL_XML_FILE, IPdtLaunchAttributes.DEFAULT_LOCAL_XML_FILE));
            Boolean copyEnabled = configuration.getAttribute(IPdtLaunchAttributes.ATTR_COPY_XML_FILE, IPdtLaunchAttributes.DEFAULT_COPY_XML_FILE.booleanValue());
            this.copyXmlFile.setSelection(copyEnabled.booleanValue());
            this.useRemoteXmlFile.setSelection(copyEnabled == false);
            this.buttonHandler.manageDependentControls(copyEnabled != false ? this.copyXmlFile : this.useRemoteXmlFile);
            this.remoteXmlFile.setString(configuration.getAttribute(IPdtLaunchAttributes.ATTR_REMOTE_XML_FILE, IPdtLaunchAttributes.DEFAULT_REMOTE_XML_FILE));
            this.remoteTraceFile.setString(configuration.getAttribute(IPdtLaunchAttributes.ATTR_REMOTE_TRACE_DIR, IPdtLaunchAttributes.DEFAULT_REMOTE_TRACE_DIR));
            this.traceFilePrefix.setString(configuration.getAttribute(IPdtLaunchAttributes.ATTR_TRACE_FILE_PREFIX, IPdtLaunchAttributes.DEFAULT_TRACE_FILE_PREFIX));
            this.localTraceDir.setString(configuration.getAttribute(IPdtLaunchAttributes.ATTR_LOCAL_TRACE_DIR, IPdtLaunchAttributes.DEFAULT_LOCAL_TRACE_DIR));
        }
        catch (CoreException e) {
            Debug.POLICY.logError((Throwable)e, Messages.getString("PdtEnvironmentTab.InitializeFrom_Error_ReadingConf"), new Object[0]);
        }
    }

    private String getProjectDirectory(ILaunchConfiguration configuration) {
        return this.selectedProject.getPath().toOSString();
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute(IPdtLaunchAttributes.ATTR_COPY_XML_FILE, this.copyXmlFile.getSelection());
        configuration.setAttribute(IPdtLaunchAttributes.ATTR_REMOTE_XML_DIR, this.remoteXmlDir.getString());
        configuration.setAttribute(IPdtLaunchAttributes.ATTR_LOCAL_XML_FILE, this.localXmlFile.getString());
        configuration.setAttribute(IPdtLaunchAttributes.ATTR_REMOTE_XML_FILE, this.remoteXmlFile.getString());
        configuration.setAttribute(IPdtLaunchAttributes.ATTR_REMOTE_TRACE_DIR, this.remoteTraceFile.getString());
        configuration.setAttribute(IPdtLaunchAttributes.ATTR_TRACE_FILE_PREFIX, this.traceFilePrefix.getString());
        configuration.setAttribute(IPdtLaunchAttributes.ATTR_LOCAL_TRACE_DIR, this.localTraceDir.getString());
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute(IPdtLaunchAttributes.ATTR_COPY_XML_FILE, IPdtLaunchAttributes.DEFAULT_COPY_XML_FILE.booleanValue());
        configuration.setAttribute(IPdtLaunchAttributes.ATTR_REMOTE_XML_DIR, IPdtLaunchAttributes.DEFAULT_REMOTE_XML_DIR);
        configuration.setAttribute(IPdtLaunchAttributes.ATTR_LOCAL_XML_FILE, IPdtLaunchAttributes.DEFAULT_LOCAL_XML_FILE);
        configuration.setAttribute(IPdtLaunchAttributes.ATTR_REMOTE_XML_FILE, IPdtLaunchAttributes.DEFAULT_REMOTE_XML_FILE);
        configuration.setAttribute(IPdtLaunchAttributes.ATTR_REMOTE_TRACE_DIR, IPdtLaunchAttributes.DEFAULT_REMOTE_TRACE_DIR);
        configuration.setAttribute(IPdtLaunchAttributes.ATTR_TRACE_FILE_PREFIX, IPdtLaunchAttributes.DEFAULT_TRACE_FILE_PREFIX);
        configuration.setAttribute(IPdtLaunchAttributes.ATTR_LOCAL_TRACE_DIR, IPdtLaunchAttributes.DEFAULT_LOCAL_TRACE_DIR);
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        String prefix;
        block14: {
            block13: {
                block12: {
                    block10: {
                        block11: {
                            if (!super.isValid(launchConfig)) {
                                return false;
                            }
                            Debug.read();
                            try {
                                Boolean copyXmlFile = launchConfig.getAttribute(IPdtLaunchAttributes.ATTR_COPY_XML_FILE, IPdtLaunchAttributes.DEFAULT_COPY_XML_FILE.booleanValue());
                                if (!copyXmlFile.booleanValue()) break block10;
                                if (PdtEnvironmentTab.validateLocalPath(launchConfig.getAttribute(IPdtLaunchAttributes.ATTR_LOCAL_XML_FILE, IPdtLaunchAttributes.DEFAULT_LOCAL_XML_FILE), true).booleanValue()) break block11;
                                this.setErrorMessage(Messages.getString("PdtEnvironmentTab.IsValid_Error_LocalXmlFileInvalid"));
                                return false;
                            }
                            catch (CoreException e) {
                                Debug.POLICY.logError((Throwable)e);
                                return false;
                            }
                        }
                        if (!PdtEnvironmentTab.validateRemotePath(launchConfig.getAttribute(IPdtLaunchAttributes.ATTR_REMOTE_XML_DIR, IPdtLaunchAttributes.DEFAULT_REMOTE_XML_DIR))) {
                            this.setErrorMessage(Messages.getString("PdtEnvironmentTab.IsValid_Error_RemoteXmlDirInvalid"));
                            return false;
                        }
                        break block12;
                    }
                    if (PdtEnvironmentTab.validateRemotePath(launchConfig.getAttribute(IPdtLaunchAttributes.ATTR_REMOTE_XML_FILE, IPdtLaunchAttributes.DEFAULT_REMOTE_XML_FILE))) break block12;
                    this.setErrorMessage(Messages.getString("PdtEnvironmentTab.IsValid_Error_RemoteXmlFileInvalid"));
                    return false;
                }
                prefix = launchConfig.getAttribute(IPdtLaunchAttributes.ATTR_TRACE_FILE_PREFIX, IPdtLaunchAttributes.DEFAULT_TRACE_FILE_PREFIX);
                if (PdtEnvironmentTab.validateRemotePath(launchConfig.getAttribute(IPdtLaunchAttributes.ATTR_REMOTE_TRACE_DIR, IPdtLaunchAttributes.DEFAULT_REMOTE_TRACE_DIR))) break block13;
                this.setErrorMessage(Messages.getString("PdtEnvironmentTab.IsValid_Error_RemoteTraceDirInvalid"));
                return false;
            }
            if (PdtEnvironmentTab.validateLocalPath(launchConfig.getAttribute(IPdtLaunchAttributes.ATTR_LOCAL_TRACE_DIR, IPdtLaunchAttributes.DEFAULT_LOCAL_TRACE_DIR), false).booleanValue()) break block14;
            this.setErrorMessage(Messages.getString("PdtEnvironmentTab.IsValid_Error_LocalTraceDirInvalid"));
            return false;
        }
        if (prefix == null || prefix.length() == 0) {
            this.setErrorMessage(Messages.getString("PdtEnvironmentTab.IsValid_Error_PrefixInvalid"));
            return false;
        }
        this.setErrorMessage(null);
        return true;
    }

    protected static boolean validateRemotePath(String remotePathString) {
        if (remotePathString == null || remotePathString.length() == 0) {
            return false;
        }
        IPath remotePath = LinuxPath.fromString((String)remotePathString);
        return remotePath.isAbsolute();
    }

    protected static Boolean validateLocalPath(String localPathString, Boolean canBeEmpty) {
        File localFile;
        if (localPathString == null || !canBeEmpty.booleanValue() && localPathString.length() == 0) {
            return false;
        }
        if (localPathString.length() != 0 && !(localFile = new File(localPathString)).exists()) {
            return false;
        }
        return true;
    }

    public boolean canSave() {
        return true;
    }

    private void updateLaunchDlgDebugSupport() {
        Debug.read();
        try {
            this.updateLaunchConfigurationDialog();
        }
        catch (Exception e) {
            Debug.POLICY.logError((Throwable)e);
        }
    }

    private class PdtModifyListener
    implements ModifyListener {
        private PdtModifyListener() {
        }

        public void modifyText(ModifyEvent e) {
            PdtEnvironmentTab.this.updateLaunchDlgDebugSupport();
        }
    }

    private class PdtSelectionListener
    implements SelectionListener {
        private PdtSelectionListener() {
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            PdtEnvironmentTab.this.updateLaunchDlgDebugSupport();
        }

        public void widgetSelected(SelectionEvent e) {
            PdtEnvironmentTab.this.updateLaunchDlgDebugSupport();
        }
    }
}

