/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.debug.sdm.core.pdi.request;

import java.math.BigInteger;
import org.eclipse.ptp.core.util.BitList;
import org.eclipse.ptp.debug.core.pdi.IPDILocator;
import org.eclipse.ptp.debug.core.pdi.IPDISession;
import org.eclipse.ptp.debug.core.pdi.PDIException;
import org.eclipse.ptp.debug.core.pdi.PDILocationFactory;
import org.eclipse.ptp.debug.core.pdi.model.IPDIStackFrameDescriptor;
import org.eclipse.ptp.debug.core.pdi.request.AbstractListStackFramesRequest;
import org.eclipse.ptp.proxy.debug.client.ProxyDebugStackFrame;
import org.eclipse.ptp.proxy.debug.event.IProxyDebugStackframeEvent;

public class SDMListStackFramesRequest
extends AbstractListStackFramesRequest {
    private IPDISession session;

    public SDMListStackFramesRequest(IPDISession session, BitList tasks) {
        this(session, tasks, 0, 0);
    }

    public SDMListStackFramesRequest(IPDISession session, BitList tasks, int low, int high) {
        super(tasks, low, high);
        this.session = session;
    }

    public IPDIStackFrameDescriptor[] getStackFrames(BitList qTasks) throws PDIException {
        this.waitUntilCompleted(qTasks);
        Object obj = this.getResult(qTasks);
        if (obj instanceof ProxyDebugStackFrame[]) {
            ProxyDebugStackFrame[] frames = (ProxyDebugStackFrame[])obj;
            IPDIStackFrameDescriptor[] desc = new IPDIStackFrameDescriptor[frames.length];
            int i = 0;
            while (i < desc.length) {
                IPDILocator loc = PDILocationFactory.newLocator((String)frames[i].getLocator().getFile(), (String)frames[i].getLocator().getFunction(), (int)frames[i].getLocator().getLineNumber(), (BigInteger)frames[i].getLocator().getAddress());
                desc[i] = this.session.getModelFactory().newStackFrameDescriptor(frames[i].getLevel(), loc);
                ++i;
            }
            return desc;
        }
        throw new PDIException(qTasks, "No stack frames found");
    }

    protected void storeResult(BitList rTasks, Object result) {
        if (result instanceof IProxyDebugStackframeEvent) {
            this.results.put(rTasks, ((IProxyDebugStackframeEvent)result).getFrames());
        } else {
            this.storeUnknownResult(rTasks, result);
        }
    }
}

