/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rm.core.rmsystem;

import org.eclipse.ptp.rm.core.rmsystem.AbstractToolRMFactory;
import org.eclipse.ptp.rm.remote.core.AbstractRemoteResourceManagerConfiguration;
import org.eclipse.ptp.rmsystem.IResourceManagerFactory;
import org.eclipse.ui.IMemento;

public abstract class AbstractToolRMConfiguration
extends AbstractRemoteResourceManagerConfiguration
implements Cloneable {
    public static final String EMPTY_STRING = "";
    private static final String TAG_LAUNCH_CMD = "launchCmd";
    private static final String TAG_DEBUG_CMD = "debugCmd";
    private static final String TAG_DISCOVER_CMD = "discoverCmd";
    private static final String TAG_PERIODIC_MONITOR_CMD = "periodicMonitorCmd";
    private static final String TAG_PERIODIC_MONITOR_TIME = "periodicMonitorTime";
    private static final String TAG_CONTINUOUS_MONITOR_CMD = "continuousMonitorCmd";
    private static final String TAG_REMOTE_INSTALL_PATH = "remoteInstallPath";
    private static final String TAG_USE_DEFAULTS = "useToolDefaults";
    public static final int CAP_LAUNCH = 1;
    public static final int CAP_DISCOVER = 2;
    public static final int CAP_PERIODIC_MONITOR = 4;
    public static final int CAP_CONTINUOUS_MONITOR = 8;
    public static final int CAP_REMOTE_INSTALL_PATH = 16;
    public static final int NO_CAP_SET = 0;
    private String launchCmd;
    private String debugCmd;
    private String discoverCmd;
    private String periodicMonitorCmd;
    private int periodicMonitorTime;
    private String continuousMonitorCmd;
    private String remoteInstallPath;
    private boolean useToolDefaults;
    private int capabilities;

    public static ToolsConfig loadTool(IResourceManagerFactory factory, IMemento memento) {
        AbstractRemoteResourceManagerConfiguration.RemoteConfig remoteConfig = AbstractToolRMConfiguration.loadRemote((IResourceManagerFactory)factory, (IMemento)memento);
        String launchCmd = memento.getString(TAG_LAUNCH_CMD);
        String debugCmd = memento.getString(TAG_DEBUG_CMD);
        String discoverCmd = memento.getString(TAG_DISCOVER_CMD);
        String periodicMonitorCmd = memento.getString(TAG_PERIODIC_MONITOR_CMD);
        Integer periodicMonitorTime = memento.getInteger(TAG_PERIODIC_MONITOR_TIME);
        String continuousMonitorCmd = memento.getString(TAG_CONTINUOUS_MONITOR_CMD);
        String remoteInstallPath = memento.getString(TAG_REMOTE_INSTALL_PATH);
        boolean useToolDefaults = Boolean.parseBoolean(memento.getString(TAG_USE_DEFAULTS));
        ToolsConfig config = new ToolsConfig(remoteConfig, launchCmd, debugCmd, discoverCmd, periodicMonitorCmd, periodicMonitorTime, continuousMonitorCmd, remoteInstallPath, useToolDefaults);
        return config;
    }

    public AbstractToolRMConfiguration(int capabilities, ToolsConfig toolsConfig, IResourceManagerFactory factory) {
        super(toolsConfig.getRemoteConfig(), factory);
        this.capabilities = capabilities;
        this.launchCmd = toolsConfig.getLaunchCmd();
        this.debugCmd = toolsConfig.getDebugCmd();
        this.discoverCmd = toolsConfig.getDiscoverCmd();
        this.periodicMonitorCmd = toolsConfig.getPeriodicMonitorCmd();
        this.periodicMonitorTime = toolsConfig.getPeriodicMonitorTime();
        this.continuousMonitorCmd = toolsConfig.getContinuousMonitorCmd();
        this.remoteInstallPath = toolsConfig.getRemoteInstallPath();
        this.useToolDefaults = toolsConfig.useToolDefaults();
    }

    public AbstractToolRMConfiguration(int capabilities, AbstractToolRMFactory factory, AbstractRemoteResourceManagerConfiguration.RemoteConfig config, String toolId, String launchCmd, String debugCmd, String discoverCmd, String periodicMonitorCmd, int periodicMonitorTime, String continuousMonitorCmd, String remoteInstallPath, boolean useToolDefaults) {
        super(config, (IResourceManagerFactory)factory);
        this.capabilities = capabilities;
        this.setLaunchCmd(launchCmd);
        this.setDebugCmd(debugCmd);
        this.setDiscoverCmd(discoverCmd);
        this.setPeriodicMonitorCmd(periodicMonitorCmd);
        this.setPeriodicMonitorTime(periodicMonitorTime);
        this.setContinuousMonitorCmd(continuousMonitorCmd);
        this.setRemoteInstallPath(remoteInstallPath);
        this.setUseToolDefaults(useToolDefaults);
    }

    public abstract Object clone();

    public void save(IMemento memento) {
        super.save(memento);
        memento.putString(TAG_LAUNCH_CMD, this.launchCmd);
        memento.putString(TAG_DEBUG_CMD, this.debugCmd);
        memento.putString(TAG_DISCOVER_CMD, this.discoverCmd);
        memento.putString(TAG_PERIODIC_MONITOR_CMD, this.periodicMonitorCmd);
        memento.putInteger(TAG_PERIODIC_MONITOR_TIME, this.periodicMonitorTime);
        memento.putString(TAG_CONTINUOUS_MONITOR_CMD, this.continuousMonitorCmd);
        memento.putString(TAG_REMOTE_INSTALL_PATH, this.remoteInstallPath);
        memento.putString(TAG_USE_DEFAULTS, Boolean.toString(this.useToolDefaults));
    }

    public abstract void setDefaultNameAndDesc();

    public String getLaunchCmd() {
        return this.launchCmd;
    }

    public void setLaunchCmd(String launchCmd) {
        this.launchCmd = launchCmd;
    }

    public String getDebugCmd() {
        return this.debugCmd;
    }

    public void setDebugCmd(String debugCmd) {
        this.debugCmd = debugCmd;
    }

    public String getDiscoverCmd() {
        return this.discoverCmd;
    }

    public void setDiscoverCmd(String discoverCmd) {
        this.discoverCmd = discoverCmd;
    }

    public String getPeriodicMonitorCmd() {
        return this.periodicMonitorCmd;
    }

    public void setPeriodicMonitorCmd(String periodicMonitorCmd) {
        this.periodicMonitorCmd = periodicMonitorCmd;
    }

    public int getPeriodicMonitorTime() {
        return this.periodicMonitorTime;
    }

    public void setPeriodicMonitorTime(int periodicMonitorTime) {
        this.periodicMonitorTime = periodicMonitorTime;
    }

    public String getContinuousMonitorCmd() {
        return this.continuousMonitorCmd;
    }

    public void setContinuousMonitorCmd(String continuousMonitorCmd) {
        this.continuousMonitorCmd = continuousMonitorCmd;
    }

    public String getRemoteInstallPath() {
        return this.remoteInstallPath;
    }

    public void setRemoteInstallPath(String remoteInstallPath) {
        this.remoteInstallPath = remoteInstallPath;
    }

    public boolean useToolDefaults() {
        return this.useToolDefaults;
    }

    public void setUseToolDefaults(boolean useToolDefaults) {
        this.useToolDefaults = useToolDefaults;
    }

    public boolean hasDiscoverCmd() {
        return (this.capabilities & 2) != 0 && this.discoverCmd != null && !this.discoverCmd.trim().equals(EMPTY_STRING);
    }

    public boolean hasLaunchCmd() {
        return (this.capabilities & 1) != 0 && this.launchCmd != null && !this.launchCmd.trim().equals(EMPTY_STRING);
    }

    public boolean hasDebugCmd() {
        return (this.capabilities & 1) != 0 && this.debugCmd != null && !this.debugCmd.trim().equals(EMPTY_STRING);
    }

    public boolean hasContinuousMonitorCmd() {
        return (this.capabilities & 8) != 0 && this.continuousMonitorCmd != null && !this.continuousMonitorCmd.trim().equals(EMPTY_STRING);
    }

    public boolean hasPeriodicMonitorCmd() {
        return (this.capabilities & 4) != 0 && this.periodicMonitorCmd != null && !this.periodicMonitorCmd.trim().equals(EMPTY_STRING);
    }

    protected int getCapabilities() {
        return this.capabilities;
    }

    public static class ToolsConfig {
        private AbstractRemoteResourceManagerConfiguration.RemoteConfig remoteConfig;
        private String launchCmd;
        private String debugCmd;
        private String discoverCmd;
        private String periodicMonitorCmd;
        private int periodicMonitorTime;
        private String continuousMonitorCmd;
        private String remoteInstallPath;
        private boolean useToolDefaults;

        public ToolsConfig() {
            this(new AbstractRemoteResourceManagerConfiguration.RemoteConfig(), null, null, null, null, 0, null, null, true);
        }

        public ToolsConfig(AbstractRemoteResourceManagerConfiguration.RemoteConfig remoteConfig, String launchCmd, String debugCmd, String discoverCmd, String periodicMonitorCmd, int periodicMonitorTime, String continuousMonitorCmd, String remoteInstallPath, boolean useToolDefaults) {
            this.remoteConfig = remoteConfig;
            this.launchCmd = launchCmd;
            this.debugCmd = debugCmd;
            this.discoverCmd = discoverCmd;
            this.periodicMonitorCmd = periodicMonitorCmd;
            this.periodicMonitorTime = periodicMonitorTime;
            this.continuousMonitorCmd = continuousMonitorCmd;
            this.remoteInstallPath = remoteInstallPath;
            this.useToolDefaults = useToolDefaults;
        }

        public AbstractRemoteResourceManagerConfiguration.RemoteConfig getRemoteConfig() {
            return this.remoteConfig;
        }

        public void setRemoteConfig(AbstractRemoteResourceManagerConfiguration.RemoteConfig remoteConfig) {
            this.remoteConfig = remoteConfig;
        }

        public String getLaunchCmd() {
            return this.launchCmd;
        }

        public void setLaunchCmd(String launchCmd) {
            this.launchCmd = launchCmd;
        }

        public String getDebugCmd() {
            return this.debugCmd;
        }

        public void setDebugCmd(String debugCmd) {
            this.debugCmd = debugCmd;
        }

        public String getDiscoverCmd() {
            return this.discoverCmd;
        }

        public void setDiscoverCmd(String discoverCmd) {
            this.discoverCmd = discoverCmd;
        }

        public String getPeriodicMonitorCmd() {
            return this.periodicMonitorCmd;
        }

        public void setPeriodicMonitorCmd(String periodicMonitorCmd) {
            this.periodicMonitorCmd = periodicMonitorCmd;
        }

        public int getPeriodicMonitorTime() {
            return this.periodicMonitorTime;
        }

        public void setPeriodicMonitorTime(int periodicMonitorTime) {
            this.periodicMonitorTime = periodicMonitorTime;
        }

        public String getContinuousMonitorCmd() {
            return this.continuousMonitorCmd;
        }

        public void setContinuousMonitorCmd(String continuousMonitorCmd) {
            this.continuousMonitorCmd = continuousMonitorCmd;
        }

        public String getRemoteInstallPath() {
            return this.remoteInstallPath;
        }

        public void setRemoteInstallPath(String remoteInstallPath) {
            this.remoteInstallPath = remoteInstallPath;
        }

        public boolean useToolDefaults() {
            return this.useToolDefaults;
        }

        public void setUseToolDefaults(boolean useToolDefaults) {
            this.useToolDefaults = useToolDefaults;
        }
    }
}

