/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.c;

import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IArrayType;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.ITypedef;
import org.eclipse.cdt.core.dom.ast.c.ICASTArrayModifier;
import org.eclipse.cdt.core.dom.ast.c.ICArrayType;
import org.eclipse.cdt.internal.core.dom.parser.ITypeContainer;
import org.eclipse.cdt.internal.core.index.IIndexType;

public class CArrayType
implements ICArrayType,
ITypeContainer {
    IType type = null;
    ICASTArrayModifier mod = null;

    public CArrayType(IType type) {
        this.type = type;
    }

    public boolean isSameType(IType obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof ITypedef) {
            return obj.isSameType(this);
        }
        if (obj instanceof ICArrayType) {
            ICArrayType at;
            block15: {
                block14: {
                    block13: {
                        block12: {
                            block11: {
                                at = (ICArrayType)obj;
                                try {
                                    if (this.isConst() == at.isConst()) break block11;
                                    return false;
                                }
                                catch (DOMException dOMException) {
                                    return false;
                                }
                            }
                            if (this.isRestrict() == at.isRestrict()) break block12;
                            return false;
                        }
                        if (this.isStatic() == at.isStatic()) break block13;
                        return false;
                    }
                    if (this.isVolatile() == at.isVolatile()) break block14;
                    return false;
                }
                if (this.isVariableLength() == at.isVariableLength()) break block15;
                return false;
            }
            return at.getType().isSameType(this.type);
        }
        if (obj instanceof IArrayType && obj instanceof IIndexType) {
            return obj.isSameType(this);
        }
        return false;
    }

    public IType getType() {
        return this.type;
    }

    public void setType(IType t) {
        this.type = t;
    }

    public void setModifiedArrayModifier(ICASTArrayModifier mod) {
        this.mod = mod;
    }

    public boolean isConst() {
        if (this.mod == null) {
            return false;
        }
        return this.mod.isConst();
    }

    public boolean isRestrict() {
        if (this.mod == null) {
            return false;
        }
        return this.mod.isRestrict();
    }

    public boolean isVolatile() {
        if (this.mod == null) {
            return false;
        }
        return this.mod.isVolatile();
    }

    public boolean isStatic() {
        if (this.mod == null) {
            return false;
        }
        return this.mod.isStatic();
    }

    public boolean isVariableLength() {
        if (this.mod == null) {
            return false;
        }
        return this.mod.isVariableSized();
    }

    public Object clone() {
        IType t = null;
        try {
            t = (IType)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {}
        return t;
    }

    public ICASTArrayModifier getModifier() {
        return this.mod;
    }

    public IASTExpression getArraySizeExpression() {
        if (this.mod != null) {
            return this.mod.getConstantExpression();
        }
        return null;
    }
}

