/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom;

import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.IPDOMIndexer;
import org.eclipse.cdt.core.dom.IPDOMIndexerTask;
import org.eclipse.cdt.internal.core.pdom.PDOMManager;
import org.eclipse.cdt.internal.core.pdom.indexer.PDOMIndexerTask;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;

public class PDOMIndexerJob
extends Job {
    private static final int PROGRESS_UPDATE_INTERVAL = 500;
    private static final int TOTAL_MONITOR_WORK = 1000;
    static volatile String sMonitorDetail = null;
    private final PDOMManager pdomManager;
    private IPDOMIndexerTask currentTask;
    private boolean cancelledByManager = false;
    private Object taskMutex = new Object();
    private IProgressMonitor fMonitor;
    private final boolean fShowActivity;

    public PDOMIndexerJob(PDOMManager manager) {
        super(CCorePlugin.getResourceString((String)"pdom.indexer.name"));
        this.pdomManager = manager;
        this.fShowActivity = PDOMIndexerTask.checkDebugOption("org.eclipse.cdt.core/debug/indexer/activity", "true");
        this.setPriority(30);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IStatus run(IProgressMonitor monitor) {
        Object object;
        long start = System.currentTimeMillis();
        this.fMonitor = monitor;
        String taskName = CCorePlugin.getResourceString((String)"pdom.indexer.task");
        monitor.beginTask(taskName, 1000);
        Job monitorJob = this.startMonitorJob(monitor);
        try {
            NullProgressMonitor npm = new NullProgressMonitor(){

                public boolean isCanceled() {
                    return PDOMIndexerJob.this.fMonitor.isCanceled();
                }

                public void setCanceled(boolean cancelled) {
                    PDOMIndexerJob.this.fMonitor.setCanceled(cancelled);
                }

                public void subTask(String name) {
                    sMonitorDetail = name;
                }
            };
            do {
                object = this.taskMutex;
                synchronized (object) {
                    block25: {
                        this.currentTask = null;
                        this.taskMutex.notifyAll();
                        if (!monitor.isCanceled()) break block25;
                        this.pdomManager.cancelledJob(this.cancelledByManager);
                        IStatus iStatus = Status.CANCEL_STATUS;
                        return iStatus;
                    }
                    this.currentTask = this.pdomManager.getNextTask();
                }
                if (this.currentTask == null) continue;
                try {
                    String name = null;
                    long time = 0L;
                    if (this.fShowActivity) {
                        name = this.getClassName(this.currentTask);
                        time = -System.currentTimeMillis();
                        System.out.println("Indexer: start " + name);
                    }
                    this.currentTask.run((IProgressMonitor)npm);
                    if (!this.fShowActivity) continue;
                    System.out.println("Indexer: completed " + name + "[" + (time += System.currentTimeMillis()) + "ms]");
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                }
                catch (OperationCanceledException operationCanceledException) {}
            } while (this.currentTask != null);
            long rest = 100L - (System.currentTimeMillis() - start);
            if (rest > 0L) {
                try {
                    Thread.sleep(rest);
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                }
            }
            IStatus iStatus = Status.OK_STATUS;
            return iStatus;
        }
        catch (RuntimeException e) {
            CCorePlugin.log((Throwable)e);
            this.pdomManager.cancelledJob(true);
            object = this.taskMutex;
            synchronized (object) {
                this.currentTask = null;
                this.taskMutex.notifyAll();
            }
            throw e;
        }
        catch (Error e) {
            CCorePlugin.log((Throwable)e);
            this.pdomManager.cancelledJob(true);
            object = this.taskMutex;
            synchronized (object) {
                this.currentTask = null;
                this.taskMutex.notifyAll();
            }
            throw e;
        }
        finally {
            monitorJob.cancel();
            monitor.done();
        }
    }

    private String getClassName(Object obj) {
        String name = obj.getClass().getName();
        name = name.substring(name.lastIndexOf(46) + 1);
        return name;
    }

    private Job startMonitorJob(final IProgressMonitor targetMonitor) {
        Job monitorJob = new Job(CCorePlugin.getResourceString((String)"PDOMIndexerJob.updateMonitorJob")){

            protected IStatus run(IProgressMonitor m) {
                int currentTick = 0;
                while (!m.isCanceled() && !targetMonitor.isCanceled()) {
                    currentTick = PDOMIndexerJob.this.pdomManager.getMonitorMessage(targetMonitor, currentTick, 1000);
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException interruptedException) {
                        return Status.CANCEL_STATUS;
                    }
                }
                return Status.OK_STATUS;
            }
        };
        monitorJob.setSystem(true);
        monitorJob.schedule();
        return monitorJob;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelJobs(IPDOMIndexer indexer, boolean waitUntilCancelled) {
        Object object = this.taskMutex;
        synchronized (object) {
            if (this.currentTask != null && (indexer == null || this.currentTask.getIndexer() == indexer)) {
                this.fMonitor.setCanceled(true);
                this.cancelledByManager = true;
                if (waitUntilCancelled) {
                    while (this.currentTask != null && this.currentTask.getIndexer() == indexer) {
                        try {
                            this.taskMutex.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            return;
                        }
                    }
                }
            }
        }
    }

    public boolean belongsTo(Object family) {
        return family == this.pdomManager;
    }
}

