/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.cell.debug.be.cdi.command;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.debug.mi.core.output.MIInfo;
import org.eclipse.cdt.debug.mi.core.output.MIList;
import org.eclipse.cdt.debug.mi.core.output.MIOutput;
import org.eclipse.cdt.debug.mi.core.output.MIResult;
import org.eclipse.cdt.debug.mi.core.output.MIResultRecord;
import org.eclipse.cdt.debug.mi.core.output.MITuple;
import org.eclipse.cdt.debug.mi.core.output.MIValue;
import org.eclipse.ptp.cell.debug.be.BEMessages;
import org.eclipse.ptp.cell.debug.be.cdi.command.output.MISPUMailbox;

public class CellMISPUMailboxInfoInfo
extends MIInfo {
    private MISPUMailbox[] mailboxes;

    public CellMISPUMailboxInfoInfo(MIOutput out) {
        super(out);
    }

    public MISPUMailbox[] getMailboxes() {
        if (this.mailboxes == null) {
            this.parse();
        }
        return this.mailboxes;
    }

    protected void parse() {
        MIOutput out;
        MIResultRecord rr;
        if (this.isDone() && (rr = (out = this.getMIOutput()).getMIResultRecord()) != null) {
            MIResult[] results = rr.getMIResults();
            int i = 0;
            while (i < results.length) {
                MIValue val;
                String var = results[i].getVariable();
                if (var.equals("SPUInfoMailbox") && (val = results[i].getMIValue()) instanceof MITuple) {
                    this.parseOutterTuple((MITuple)val);
                }
                ++i;
            }
        }
    }

    protected void parseOutterTuple(MITuple tuples) {
        ArrayList<MISPUMailbox> aList = new ArrayList<MISPUMailbox>();
        MIResult[] tables = tuples.getMIResults();
        int j = 0;
        while (j < tables.length) {
            String tableName = tables[j].getVariable();
            if (tableName.equals("mbox")) {
                MIValue tableContent = tables[j].getMIValue();
                this.parseTable(tableContent, aList);
            }
            ++j;
        }
        if (aList.size() == 0) {
            aList.add(new MISPUMailbox("mbox", BEMessages.getString("SPUEnhancementsProcessor.0"), Integer.toString(0)));
            aList.add(new MISPUMailbox("ibox", BEMessages.getString("SPUEnhancementsProcessor.0"), Integer.toString(0)));
            aList.add(new MISPUMailbox("wbox", BEMessages.getString("SPUEnhancementsProcessor.0"), Integer.toString(0)));
        }
        this.mailboxes = aList.toArray(new MISPUMailbox[0]);
    }

    protected void parseTable(MIValue val, List aList) {
        if (val instanceof MITuple) {
            MIResult[] table = ((MITuple)val).getMIResults();
            int j = 0;
            while (j < table.length) {
                String variable = table[j].getVariable();
                if (variable.equals("body")) {
                    this.parseBody(table[j].getMIValue(), aList);
                }
                ++j;
            }
        }
    }

    protected void parseBody(MIValue body, List aList) {
        if (body instanceof MIList) {
            MIResult[] mboxs = ((MIList)body).getMIResults();
            int i = 0;
            while (i < mboxs.length) {
                MIValue value;
                String m = mboxs[i].getVariable();
                if (m.equals("mbox") && (value = mboxs[i].getMIValue()) instanceof MITuple) {
                    this.parseTuple((MITuple)value, aList, i);
                }
                ++i;
            }
        }
    }

    protected void parseTuple(MITuple tuple, List aList, int row) {
        MIResult[] args = tuple.getMIResults();
        int i = 0;
        while (i < args.length) {
            aList.add(new MISPUMailbox(args[i], Integer.toString(row)));
            ++i;
        }
    }
}

