/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.cell.sputiming.ui;

import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.managedbuilder.core.BuildException;
import org.eclipse.cdt.managedbuilder.core.IManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.core.IResourceConfiguration;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.ui.CElementLabelProvider;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.ptp.cell.preferences.ui.PreferenceConstants;
import org.eclipse.ptp.cell.sputiming.ui.Messages;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;

public class SPUTimingMainTab
extends AbstractLaunchConfigurationTab {
    protected Label fMessageLabel;
    protected Label fCompilerNameLabel;
    protected Label fCompilerFlagsLabel;
    protected Text fCompilerNameText;
    protected Text fCompilerFlagsText;
    protected Button fCompilerCommandSearch;
    protected Label fProfilerTargetLabel;
    protected Text fProfilerTargetText;
    protected Button fProfilerTargetSearch;
    protected Label fProfilerProjectLabel;
    protected Text fProfilerProjectText;
    protected Button fProfilerProjectSearch;
    protected Label fSPUTimingExecutableLabel;
    protected Text fSPUTimingExecutableText;
    protected Label fSPUTimingSourceFileLabel;
    protected Text fSPUTimingAssemblyFileText;
    private Label fSPUTimingArchitectureLabel;
    private Combo fSPUTimingArchitectureCombo;
    protected ModifyListener textModifyListener = new TextBoxListener();

    public void createControl(Composite parent) {
        Composite comp = new Composite(parent, 0);
        this.setControl((Control)comp);
        GridLayout topLayout = new GridLayout();
        topLayout.marginHeight = 0;
        topLayout.verticalSpacing = 1;
        comp.setLayout((Layout)topLayout);
        this.createMessageGroup(comp, 1);
        this.createProfilerGroup(comp, 1);
        this.createCompilationGroup(comp, 1);
        this.createSPUTimingGroup(comp, 1);
    }

    protected void createMessageGroup(Composite parent, int colSpan) {
    }

    protected void handleSearchSourceButtonAction() {
        if (this.getCProject() == null) {
            MessageDialog.openInformation((Shell)this.getShell(), (String)"Project required!", (String)"Enter project before searching for source file");
            return;
        }
        IFile csource = this.selectCSource();
        if (csource == null) {
            return;
        }
        this.fProfilerTargetText.setText(csource.getProjectRelativePath().toOSString());
    }

    void createProfilerGroup(Composite parent, int colSpan) {
        Group projComp = new Group(parent, 16);
        projComp.setText(Messages.SPUTimingMainTab_ProjectGroup_GroupLabel);
        GridLayout projLayout = new GridLayout();
        projLayout.verticalSpacing = 0;
        projLayout.numColumns = 2;
        projLayout.marginTop = 0;
        projLayout.marginBottom = 1;
        projLayout.marginWidth = 3;
        projComp.setLayout((Layout)projLayout);
        GridData gd = new GridData(768);
        gd.horizontalSpan = colSpan;
        projComp.setLayoutData((Object)gd);
        this.fProfilerProjectLabel = new Label((Composite)projComp, 0);
        this.fProfilerProjectLabel.setText(Messages.SPUTimingMainTab_ProjectGroup_ProjectLabel);
        gd = new GridData();
        gd.horizontalSpan = 2;
        this.fProfilerProjectLabel.setLayoutData((Object)gd);
        this.fProfilerProjectText = new Text((Composite)projComp, 2052);
        gd = new GridData(768);
        this.fProfilerProjectText.setLayoutData((Object)gd);
        this.fProfilerProjectText.addModifyListener(this.textModifyListener);
        this.fProfilerProjectSearch = this.createPushButton((Composite)projComp, Messages.SPUTimingMainTab_ProjectGroup_SearchProjectButton, null);
        this.fProfilerProjectSearch.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                SPUTimingMainTab.this.handleSearchProjectButtonAction();
                SPUTimingMainTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.fProfilerTargetLabel = new Label((Composite)projComp, 0);
        this.fProfilerTargetLabel.setText(Messages.SPUTimingMainTab_ProjectGroup_SourceLabel);
        gd = new GridData();
        gd.horizontalSpan = 2;
        this.fProfilerTargetLabel.setLayoutData((Object)gd);
        this.fProfilerTargetText = new Text((Composite)projComp, 2052);
        gd = new GridData(768);
        this.fProfilerTargetText.setLayoutData((Object)gd);
        this.fProfilerTargetText.addModifyListener(this.textModifyListener);
        this.fProfilerTargetSearch = this.createPushButton((Composite)projComp, Messages.SPUTimingMainTab_ProjectGroup_SearchTargetButton, null);
        this.fProfilerTargetSearch.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                SPUTimingMainTab.this.handleSearchSourceButtonAction();
                SPUTimingMainTab.this.updateLaunchConfigurationDialog();
            }
        });
    }

    protected void handleSearchProjectButtonAction() {
        ICProject cproject = this.selectCProject();
        if (cproject == null) {
            return;
        }
        String projectName = cproject.getElementName();
        this.fProfilerProjectText.setText(projectName);
    }

    protected ICProject selectCProject() {
        try {
            Object[] projects = this.getCProjects();
            CElementLabelProvider labelProvider = new CElementLabelProvider();
            ElementListSelectionDialog dialog = new ElementListSelectionDialog(this.getShell(), (ILabelProvider)labelProvider);
            dialog.setTitle("Projects");
            dialog.setMessage("Select the project whose file will be profiled");
            dialog.setElements(projects);
            ICProject cProject = this.getCProject();
            if (cProject != null) {
                dialog.setInitialSelections(new Object[]{cProject});
            }
            if (dialog.open() == 0) {
                return (ICProject)dialog.getFirstResult();
            }
        }
        catch (CModelException e) {
            System.out.println("CModelException " + e.getMessage());
        }
        return null;
    }

    protected void createCompilationGroup(Composite parent, int colSpan) {
        Group projComp = new Group(parent, 16);
        projComp.setText(Messages.SPUTimingMainTab_CompilerGroup_GroupLabel);
        GridLayout projLayout = new GridLayout();
        projLayout.numColumns = 2;
        projLayout.marginTop = 0;
        projLayout.marginBottom = 1;
        projLayout.marginWidth = 3;
        projLayout.verticalSpacing = 0;
        projComp.setLayout((Layout)projLayout);
        GridData gd = new GridData(768);
        gd.horizontalSpan = colSpan;
        projComp.setLayoutData((Object)gd);
        this.fCompilerNameLabel = new Label((Composite)projComp, 0);
        this.fCompilerNameLabel.setText(Messages.SPUTimingMainTab_CompilerGroup_CompilerLabel);
        gd = new GridData();
        gd.horizontalSpan = 2;
        this.fCompilerNameLabel.setLayoutData((Object)gd);
        this.fCompilerNameText = new Text((Composite)projComp, 2052);
        gd = new GridData(768);
        this.fCompilerNameText.setLayoutData((Object)gd);
        this.fCompilerNameText.addModifyListener(this.textModifyListener);
        this.fCompilerFlagsLabel = new Label((Composite)projComp, 0);
        this.fCompilerFlagsLabel.setText(Messages.SPUTimingMainTab_CompilerGroup_FlagsLabel);
        gd = new GridData();
        gd.horizontalSpan = 2;
        this.fCompilerFlagsLabel.setLayoutData((Object)gd);
        this.fCompilerFlagsText = new Text((Composite)projComp, 2052);
        gd = new GridData(768);
        this.fCompilerFlagsText.setLayoutData((Object)gd);
        this.fCompilerFlagsText.addModifyListener(this.textModifyListener);
    }

    protected void createSPUTimingGroup(Composite parent, int colSpan) {
        Group projComp = new Group(parent, 16);
        projComp.setText(Messages.SPUTimingMainTab_SPUTimingGroup_GroupLabel);
        GridLayout projLayout = new GridLayout();
        projLayout.numColumns = 2;
        projLayout.marginTop = 0;
        projLayout.marginBottom = 1;
        projLayout.marginWidth = 3;
        projLayout.verticalSpacing = 2;
        projComp.setLayout((Layout)projLayout);
        GridData gd = new GridData(768);
        gd.horizontalSpan = colSpan;
        projComp.setLayoutData((Object)gd);
        this.fSPUTimingExecutableLabel = new Label((Composite)projComp, 0);
        this.fSPUTimingExecutableLabel.setText(Messages.SPUTimingMainTab_SPUTimingGroup_SPUTimingLabel);
        gd = new GridData();
        gd.horizontalSpan = 2;
        this.fSPUTimingExecutableLabel.setLayoutData((Object)gd);
        this.fSPUTimingExecutableText = new Text((Composite)projComp, 2052);
        gd = new GridData(768);
        this.fSPUTimingExecutableText.setLayoutData((Object)gd);
        this.fSPUTimingExecutableText.addModifyListener(this.textModifyListener);
        gd = new GridData();
        gd.horizontalSpan = 2;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        this.fSPUTimingExecutableText.setLayoutData((Object)gd);
        this.fSPUTimingSourceFileLabel = new Label((Composite)projComp, 0);
        this.fSPUTimingSourceFileLabel.setText(Messages.SPUTimingMainTab_SPUTimingGroup_AssemblyFileLabel);
        gd = new GridData();
        gd.horizontalSpan = 2;
        this.fSPUTimingSourceFileLabel.setLayoutData((Object)gd);
        this.fSPUTimingAssemblyFileText = new Text((Composite)projComp, 2052);
        gd = new GridData(768);
        this.fSPUTimingAssemblyFileText.setLayoutData((Object)gd);
        this.fSPUTimingAssemblyFileText.addModifyListener(this.textModifyListener);
        gd = new GridData();
        gd.horizontalSpan = 2;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        this.fSPUTimingAssemblyFileText.setLayoutData((Object)gd);
        this.fSPUTimingArchitectureLabel = new Label((Composite)projComp, 0);
        this.fSPUTimingArchitectureLabel.setText(Messages.SPUTimingMainTab_SPUTimingGroup_ArchitectureComboLabel);
        this.fSPUTimingArchitectureCombo = new Combo((Composite)projComp, 12);
        this.fSPUTimingArchitectureCombo.add(Messages.SPUTimingMainTab_SPUTimingGroup_ArchitectureCell);
        this.fSPUTimingArchitectureCombo.add(Messages.SPUTimingMainTab_SPUTimingGroup_ArchitectureSoma);
        this.fSPUTimingArchitectureCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SPUTimingMainTab.this.updateLaunchConfigurationDialog();
            }
        });
    }

    protected ICProject getCProject() {
        String projectName = this.fProfilerProjectText.getText().trim();
        if (projectName.length() < 1) {
            return null;
        }
        ICProject cproj = CoreModel.getDefault().getCModel().getCProject(projectName);
        if (!cproj.exists()) {
            return null;
        }
        return cproj;
    }

    protected ICProject[] getCProjects() throws CModelException {
        ICProject[] cproject = CoreModel.getDefault().getCModel().getCProjects();
        ArrayList<ICProject> list = new ArrayList<ICProject>(cproject.length);
        int i = 0;
        while (i < cproject.length) {
            IProject project = cproject[i].getProject();
            if (!ManagedBuildManager.canGetBuildInfo((IResource)project)) {
                list.add(cproject[i]);
            }
            ++i;
        }
        return list.toArray(new ICProject[list.size()]);
    }

    protected IFile selectCSource() {
        Object[] sourcefiles = this.getCSources();
        if (sourcefiles == null) {
            return null;
        }
        CElementLabelProvider lblProvider = new CElementLabelProvider();
        ElementListSelectionDialog sourcedialog = new ElementListSelectionDialog(this.getShell(), (ILabelProvider)lblProvider);
        sourcedialog.setTitle(Messages.SPUTimingMainTab_SelectCSource_DialogTitle);
        sourcedialog.setMessage(Messages.SPUTimingMainTab_SelectCSource_DialogMessage);
        sourcedialog.setElements(sourcefiles);
        if (sourcefiles != null) {
            sourcedialog.setInitialSelections(new Object[]{sourcefiles[0]});
        }
        if (sourcedialog.open() == 0) {
            return (IFile)sourcedialog.getFirstResult();
        }
        return null;
    }

    protected IFile getCSource() {
        String fileName = this.fProfilerTargetText.getText().trim();
        if (fileName.length() < 1) {
            return null;
        }
        ICProject cproject = this.getCProject();
        if (cproject == null) {
            return null;
        }
        IFile cfile = cproject.getProject().getFile(fileName);
        if (!cfile.exists()) {
            return null;
        }
        return cfile;
    }

    protected IFile[] getCSources() {
        IResource[] resourcelist;
        ICProject cproj = this.getCProject();
        LinkedList<IFile> filelist = new LinkedList<IFile>();
        try {
            resourcelist = cproj.getProject().members();
        }
        catch (CoreException coreException) {
            return null;
        }
        if (ManagedBuildManager.canGetBuildInfo((IResource)cproj.getProject())) {
            IManagedBuildInfo buildinfo = ManagedBuildManager.getBuildInfo((IResource)cproj.getProject());
            String[] toolidmatchinglist = new String[2];
            if (CoreModel.hasCNature((IProject)cproj.getProject())) {
                toolidmatchinglist[0] = "cell.spu.xl.c.compiler";
                toolidmatchinglist[1] = "cell.spu.gnu.c.compiler";
                if (CoreModel.hasCCNature((IProject)cproj.getProject())) {
                    toolidmatchinglist[0] = "cell.spu.xl.cpp.compiler";
                    toolidmatchinglist[1] = "cell.spu.gnu.cpp.compiler";
                }
            } else {
                return null;
            }
            ITool[] tools = buildinfo.getDefaultConfiguration().getFilteredTools();
            HashSet<String> extensionset = new HashSet<String>();
            int j = 0;
            while (j < tools.length) {
                ITool tool = tools[j];
                if (tool.getId().indexOf(toolidmatchinglist[0]) != -1 || tool.getId().indexOf(toolidmatchinglist[1]) != -1) {
                    String[] extensions = tool.getAllInputExtensions();
                    int i = 0;
                    while (i < extensions.length) {
                        extensionset.add(extensions[i]);
                        ++i;
                    }
                }
                ++j;
            }
            int i = 0;
            while (i < resourcelist.length) {
                IFile tempfile;
                if (resourcelist[i] instanceof IFile && extensionset.contains((tempfile = (IFile)resourcelist[i]).getFileExtension())) {
                    filelist.add(tempfile);
                }
                ++i;
            }
        } else {
            try {
                filelist.addAll(this.collectSourceFiles(resourcelist));
            }
            catch (CoreException coreException) {
                System.out.println(Messages.SPUTimingMainTab_GetCSources_SourceListError);
            }
        }
        IFile[] temp = new IFile[1];
        return filelist.toArray(temp);
    }

    protected LinkedList collectSourceFiles(IResource[] resourcelist) throws CoreException {
        LinkedList<IFile> filelist = new LinkedList<IFile>();
        int i = 0;
        while (i < resourcelist.length) {
            if (resourcelist[i] instanceof IFile && resourcelist[i].getFileExtension() != null && this.isSourceFile((IFile)resourcelist[i])) {
                filelist.add((IFile)resourcelist[i]);
            } else if (resourcelist[i] instanceof IFolder) {
                IFolder tempfolder = (IFolder)resourcelist[i];
                IResource[] sublist = tempfolder.members();
                filelist.addAll(this.collectSourceFiles(sublist));
            }
            ++i;
        }
        return filelist;
    }

    protected boolean isSourceFile(IFile file) {
        return file.getFileExtension().equalsIgnoreCase("c") || file.getFileExtension().equalsIgnoreCase("c++") || file.getFileExtension().equalsIgnoreCase("cc") || file.getFileExtension().equalsIgnoreCase("cxx") || file.getFileExtension().equalsIgnoreCase("cpp");
    }

    protected ITool getCCompiler() {
        IProject project = this.getCProject().getProject();
        IFile csource = this.getCSource();
        if (ManagedBuildManager.canGetBuildInfo((IResource)project)) {
            IManagedBuildInfo buildinfo = ManagedBuildManager.getBuildInfo((IResource)project);
            IResourceConfiguration resconf = buildinfo.getDefaultConfiguration().getResourceConfiguration(csource.getFullPath().toOSString());
            if (resconf == null) {
                return buildinfo.getToolFromInputExtension(csource.getFileExtension());
            }
            return resconf.getTools()[0];
        }
        return null;
    }

    protected void handleSearchCCompilerButtonAction() {
        if (this.getCProject() == null) {
            MessageDialog.openInformation((Shell)this.getShell(), (String)"Project required!", (String)"Enter project before searching for compiler information");
            return;
        }
        IFile source = this.getCSource();
        if (source == null) {
            MessageDialog.openInformation((Shell)this.getShell(), (String)"Source file required!", (String)"Enter source file before searching for compiler information");
            return;
        }
        ITool tool = this.getCCompiler();
        if (tool == null) {
            MessageDialog.openInformation((Shell)this.getShell(), (String)"No managed build info!", (String)"Cannot extract compiler information from a non-managed build project");
            return;
        }
        String toolcommand = tool.getToolCommand();
        if (toolcommand == null) {
            this.fCompilerNameText.setText("");
        } else {
            this.fCompilerNameText.setText(toolcommand);
        }
        String flaglist = null;
        try {
            ITool assemblertool = ManagedBuildManager.getExtensionTool((String)"cell.managedbuild.tool.cell.spu.gnu.assembler");
            if (assemblertool == null) {
                MessageDialog.openInformation((Shell)this.getShell(), (String)Messages.SPUTimingMainTab_SearchCCompilerButtonAction_CDTErrorTitle, (String)Messages.SPUTimingMainTab_SearchCCompilerButtonAction_CDTErrorMessage);
                return;
            }
            String[] assemblerextlist = assemblertool.getAllInputExtensions();
            if (assemblerextlist.length == 0) {
                MessageDialog.openInformation((Shell)this.getShell(), (String)Messages.SPUTimingMainTab_SearchCCompilerButtonAction_CDTErrorTitle, (String)Messages.SPUTimingMainTab_SearchCCompilerButtonAction_CDTErrorMessage);
                return;
            }
            IManagedBuildInfo imbi = ManagedBuildManager.getBuildInfo((IResource)this.getCProject().getProject());
            String builddir = imbi.getConfigurationName();
            IPath outputfilenamewoext = source.getFullPath().removeFileExtension().makeRelative().removeFirstSegments(1);
            String outputextension = imbi.getOutputExtension(source.getFileExtension());
            IPath outputfilename = source.getLocation().removeLastSegments(1).addTrailingSeparator().append(builddir).addTrailingSeparator().append(String.valueOf(outputfilenamewoext.toString()) + "." + outputextension);
            flaglist = String.valueOf(tool.getToolCommandFlagsString(source.getLocation(), outputfilename)) + " -S";
        }
        catch (BuildException buildException) {
            System.out.println(Messages.SPUTimingMainTab_SearchCCompilerButtonAction_FlagsFetchingMessage);
            this.fCompilerFlagsText.setText("");
        }
        if (flaglist != null) {
            this.fCompilerFlagsText.setText(flaglist);
        }
    }

    protected String getSPUTimingExecutableName() {
        ITool ccompiler = this.getCCompiler();
        if (ccompiler != null) {
            return "spu_timing";
        }
        return null;
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        String sputCommand;
        File sputCmdFile;
        this.setErrorMessage(null);
        this.setMessage(Messages.SPUTimingMainTab_MessageGroup_);
        String projName = this.fProfilerProjectText.getText().trim();
        if (projName.length() == 0) {
            this.setErrorMessage(Messages.SPUTimingMainTab_IsValid_NoProjectNameError);
            return false;
        }
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projName);
        if (!project.exists()) {
            this.setErrorMessage(Messages.SPUTimingMainTab_IsValid_ProjectMustExistError);
            return false;
        }
        if (!project.isOpen()) {
            this.setErrorMessage(Messages.SPUTimingMainTab_IsValid_ProjectMustBeOpened);
            return false;
        }
        String sourceName = this.fProfilerTargetText.getText().trim();
        if (sourceName.length() == 0) {
            this.setErrorMessage(Messages.SPUTimingMainTab_IsValid_NoSourceFileError);
            return false;
        }
        if (!project.getFile(sourceName).exists()) {
            this.setErrorMessage(Messages.SPUTimingMainTab_IsValid_SourceFileMustExistError);
            return false;
        }
        if (sourceName.equals(".") || sourceName.equals("..")) {
            this.setErrorMessage(Messages.SPUTimingMainTab_IsValid_InvalidFilenameError);
            return false;
        }
        String compCmd = this.fCompilerNameText.getText().trim();
        if (compCmd.length() == 0) {
            this.setErrorMessage(Messages.SPUTimingMainTab_IsValid_NoCompilerError);
            return false;
        }
        if (this.fCompilerFlagsText.getText().trim().length() == 0) {
            this.setMessage(String.valueOf(Messages.SPUTimingMainTab_IsValid_AssemblyFlagMessage) + "flag to generate output file name " + "compatible with the assembly file name field");
        }
        if (!(sputCmdFile = new File(sputCommand = this.fSPUTimingExecutableText.getText().trim())).exists() || !sputCmdFile.isFile()) {
            this.setErrorMessage(Messages.SPUTimingMainTab_IsValid_ValidSPUTimingPathError);
            return false;
        }
        String asmFile = this.fSPUTimingAssemblyFileText.getText().trim();
        if (asmFile.length() == 0) {
            this.setErrorMessage(Messages.SPUTimingMainTab_IsValid_ValidAssemblyFilenameError);
            return false;
        }
        int index = this.fSPUTimingArchitectureCombo.getSelectionIndex();
        if (index == -1) {
            this.setErrorMessage(Messages.SPUTimingMainTab_IsValid_ValidArchitectureError);
            return false;
        }
        return true;
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        try {
            this.fCompilerNameText.setText(configuration.getAttribute("compilername", ""));
            this.fCompilerFlagsText.setText(configuration.getAttribute("compilerflags", ""));
            this.fProfilerTargetText.setText(configuration.getAttribute("srcfilename", ""));
            this.fProfilerProjectText.setText(configuration.getAttribute("profilerproject", ""));
            this.fSPUTimingAssemblyFileText.setText(configuration.getAttribute("asmfilename", ""));
            if (configuration.getAttribute("spuexecname", "") == null || configuration.getAttribute("spuexecname", "") == "") {
                PreferenceConstants preferences = PreferenceConstants.getInstance();
                this.fSPUTimingExecutableText.setText(preferences.getTIMING_SPUBIN().toOSString());
            } else {
                this.fSPUTimingExecutableText.setText(configuration.getAttribute("spuexecname", ""));
            }
            if (configuration.getAttribute("march", "cell").equals("cell")) {
                this.fSPUTimingArchitectureCombo.select(0);
            } else if (configuration.getAttribute("march", "cell").equals("efp")) {
                this.fSPUTimingArchitectureCombo.select(1);
            } else {
                this.fSPUTimingArchitectureCombo.select(0);
            }
        }
        catch (CoreException coreException) {}
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        PreferenceConstants preferences = PreferenceConstants.getInstance();
        configuration.setAttribute("spuexecname", preferences.getTIMING_SPUBIN().toOSString());
        configuration.setAttribute("march", "cell");
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("compilername", this.fCompilerNameText.getText());
        configuration.setAttribute("compilerflags", this.fCompilerFlagsText.getText());
        configuration.setAttribute("profilerproject", this.fProfilerProjectText.getText());
        configuration.setAttribute("srcfilename", this.fProfilerTargetText.getText());
        configuration.setAttribute("spuexecname", this.fSPUTimingExecutableText.getText());
        configuration.setAttribute("asmfilename", this.fSPUTimingAssemblyFileText.getText());
        IFile file = this.getCSource();
        if (file != null) {
            configuration.setAttribute("defaultworkingdir", this.getCProject().getProject().getLocation().toOSString());
        } else {
            configuration.setAttribute("defaultworkingdir", null);
        }
        if (this.fSPUTimingArchitectureCombo.getSelectionIndex() == 0) {
            configuration.setAttribute("march", "cell");
        } else if (this.fSPUTimingArchitectureCombo.getSelectionIndex() == 1) {
            configuration.setAttribute("march", "efp");
        }
    }

    public String getName() {
        return Messages.SPUTimingMainTab_Title;
    }

    public class TextBoxListener
    implements ModifyListener {
        public void modifyText(ModifyEvent event) {
            SPUTimingMainTab.this.updateLaunchConfigurationDialog();
        }
    }
}

