/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.core.attributes;

import java.util.List;
import org.eclipse.ptp.core.attributes.AbstractAttribute;
import org.eclipse.ptp.core.attributes.EnumeratedAttributeDefinition;
import org.eclipse.ptp.core.attributes.IllegalValueException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class EnumeratedAttribute<E extends Enum<E>>
extends AbstractAttribute<E, EnumeratedAttribute<E>, EnumeratedAttributeDefinition<E>> {
    private E value;

    public EnumeratedAttribute(EnumeratedAttributeDefinition<E> definition, int valueIndex) throws IllegalValueException {
        super(definition);
        this.setValue(valueIndex);
    }

    public EnumeratedAttribute(EnumeratedAttributeDefinition<E> definition, String valueString) throws IllegalValueException {
        super(definition);
        this.setValueAsString(valueString);
    }

    public EnumeratedAttribute(EnumeratedAttributeDefinition<E> definition, E value) {
        super(definition);
        this.setValue(value);
    }

    public List<? extends E> getEnumerations() {
        return ((EnumeratedAttributeDefinition)this.getDefinition()).getEnumerations();
    }

    public List<String> getEnumerationStrings() {
        return ((EnumeratedAttributeDefinition)this.getDefinition()).getEnumerationStrings();
    }

    @Override
    public synchronized E getValue() {
        return this.value;
    }

    @Override
    public synchronized String getValueAsString() {
        return ((Enum)this.value).toString();
    }

    public synchronized int getValueIndex() {
        return ((Enum)this.value).ordinal();
    }

    @Override
    public boolean isValid(String string) {
        int vi = this.getEnumerations().indexOf(string);
        return vi != -1;
    }

    @Override
    public synchronized void setValue(E value) {
        this.value = value;
    }

    @Override
    public synchronized void setValue(int valueIndex) throws IllegalValueException {
        List<E> enumerations = this.getEnumerations();
        if (valueIndex < 0 || valueIndex >= enumerations.size()) {
            throw new IllegalValueException("valueIndex is out of range");
        }
        this.value = (Enum)enumerations.get(valueIndex);
    }

    @Override
    public synchronized void setValueAsString(String string) throws IllegalValueException {
        Object eval;
        Class enumClass = ((EnumeratedAttributeDefinition)this.getDefinition()).getEnumClass();
        try {
            eval = Enum.valueOf(enumClass, string);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalValueException(e);
        }
        this.value = eval;
    }

    @Override
    protected synchronized int doCompareTo(EnumeratedAttribute<E> other) {
        return ((Enum)this.value).compareTo(other.value);
    }

    @Override
    protected synchronized boolean doEquals(EnumeratedAttribute<E> other) {
        return this.value == other.value;
    }

    @Override
    protected synchronized int doHashCode() {
        return ((Enum)this.value).hashCode();
    }
}

