/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.cell.debug.launch;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.cdt.debug.mi.core.IGDBServerMILaunchConfigurationConstants;
import org.eclipse.cdt.launch.internal.LocalCDILaunchDelegate;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.ptp.cell.debug.core.debug.Debug;
import org.eclipse.ptp.cell.debug.launch.DebugLaunchMessages;
import org.eclipse.ptp.cell.debug.launch.ICellDebugLaunchConstants;
import org.eclipse.ptp.remotetools.environment.EnvironmentPlugin;
import org.eclipse.ptp.remotetools.environment.control.ITargetControl;
import org.eclipse.ptp.remotetools.environment.core.TargetEnvironmentManager;
import org.eclipse.ptp.utils.core.linux.ArgumentParser;

public class LocalCellCDILaunchDelegate
extends LocalCDILaunchDelegate {
    public static String ID = "org.eclipse.ptp.cell.debug.launch.remoteCellDebugDelegate";

    public LocalCellCDILaunchDelegate() {
        Debug.read();
    }

    private String assembleCmdLine(List cmds) {
        ArgumentParser parser = new ArgumentParser(cmds);
        String result = parser.getCommandLine(true);
        Debug.POLICY.pass(Debug.DEBUG_DELEGATE, result, new Object[0]);
        return result;
    }

    public void launchIntegration(ILaunchConfiguration config, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        Debug.POLICY.enter(Debug.DEBUG_DELEGATE, new Object[]{config, mode, launch});
        ILaunchConfiguration copy = null;
        if (config.getAttribute(ICellDebugLaunchConstants.TARGET_REMOTELAUNCH, 0) > 0) {
            if (config.getAttribute(ICellDebugLaunchConstants.TARGET_REMOTELAUNCH_CAPABLE, 0) <= 0) {
                Status st = new Status(4, ID, 1107, DebugLaunchMessages.getString("LocalCellCDILaunchDelegate.0"), null);
                throw new CoreException((IStatus)st);
            }
            if (!config.getAttribute("org.eclipse.cdt.launch.DEBUGGER_ID", "localDebugger").equals(config.getAttribute(ICellDebugLaunchConstants.TARGET_REMOTELAUNCH_SELECTED_DBGID, "remoteDebugger"))) {
                Status st = new Status(4, ID, 1106, DebugLaunchMessages.getString("LocalCellCDILaunchDelegate.1"), null);
                throw new CoreException((IStatus)st);
            }
        }
        copy = this.processLaunch(config);
        if (!monitor.isCanceled() && mode.equals("debug") && copy != null) {
            super.launch(copy, mode, launch, monitor);
        }
        Debug.POLICY.exit(Debug.DEBUG_DELEGATE);
    }

    public String[] getRemoteDebuggerCommand(ILaunchConfiguration config, String applicationFullPath, String[] arguments) throws CoreException {
        ArrayList<String> command = new ArrayList<String>(1 + arguments.length);
        command.add(applicationFullPath);
        command.addAll(Arrays.asList(arguments));
        String gdbBin = config.getAttribute(ICellDebugLaunchConstants.TARGET_REMOTELAUNCH_SELECTED_BINARY, "");
        String gdbPort = config.getAttribute(ICellDebugLaunchConstants.TARGET_REMOTELAUNCH_SELECTED_PORT, "0");
        String cmdString = String.valueOf(gdbBin) + " host:" + gdbPort + " " + this.assembleCmdLine(command);
        Debug.POLICY.pass(Debug.DEBUG_DELEGATE, cmdString, new Object[0]);
        return new String[]{cmdString};
    }

    public boolean doRemoteLaunch(ILaunchConfiguration config) throws CoreException {
        if (config.getAttribute(IGDBServerMILaunchConfigurationConstants.ATTR_REMOTE_TCP, false) && config.getAttribute(ICellDebugLaunchConstants.TARGET_REMOTELAUNCH, 0) == 1) {
            Debug.POLICY.pass(Debug.DEBUG_DELEGATE, new Object[]{true});
            return true;
        }
        Debug.POLICY.pass(Debug.DEBUG_DELEGATE, new Object[]{false});
        return false;
    }

    protected ILaunchConfiguration processLaunch(ILaunchConfiguration config) throws CoreException {
        Debug.POLICY.enter(Debug.DEBUG_DELEGATE, new Object[]{config});
        String id = config.getAttribute(ICellDebugLaunchConstants.TARGET_ENV_SELECTED, "");
        TargetEnvironmentManager manager = EnvironmentPlugin.getDefault().getTargetsManager();
        ITargetControl control = manager.selectControl(id);
        String specPort = config.getAttribute(ICellDebugLaunchConstants.TARGET_REMOTELAUNCH_SELECTED_PORT, "0");
        ILaunchConfigurationWorkingCopy modifCopy = null;
        if (!this.portNumberIsValid(specPort)) {
            Status st = new Status(4, ID, 1108, DebugLaunchMessages.getString("LocalCellCDILaunchDelegate.3"), null);
            throw new CoreException((IStatus)st);
        }
        ITargetControl.TargetSocket tsocket = control.createTargetSocket(Integer.parseInt(specPort));
        Debug.POLICY.enter(Debug.DEBUG_DELEGATE, new Object[]{"Created socket: {0}:{1}", tsocket.host, tsocket.port});
        modifCopy = config.getWorkingCopy();
        modifCopy.setAttribute(IGDBServerMILaunchConfigurationConstants.ATTR_HOST, tsocket.host);
        modifCopy.setAttribute(IGDBServerMILaunchConfigurationConstants.ATTR_PORT, Integer.toString(tsocket.port));
        ILaunchConfiguration result = modifCopy.doSave();
        Debug.POLICY.exit(Debug.DEBUG_DELEGATE, (Object)result);
        return result;
    }

    public static String getUniqueID() {
        return ID;
    }

    private boolean portNumberIsValid(String portNumber) {
        try {
            int port = Integer.parseInt(portNumber);
            return port > 0 && port <= 65535;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }
}

