/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.cell.debug.launch.remote;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ptp.cell.debug.launch.remote.RemoteProcess;
import org.eclipse.ptp.remotetools.core.IRemoteConnection;
import org.eclipse.ptp.remotetools.core.IRemoteExecutionManager;
import org.eclipse.ptp.remotetools.core.IRemoteExecutionTools;
import org.eclipse.ptp.remotetools.core.IRemoteUploadExecution;
import org.eclipse.ptp.remotetools.environment.control.ITargetControl;
import org.eclipse.ptp.remotetools.exception.CancelException;
import org.eclipse.ptp.remotetools.exception.RemoteConnectionException;
import org.eclipse.ptp.remotetools.exception.RemoteExecutionException;

public class RemoteTasksHelper {
    IRemoteConnection conn;
    IRemoteExecutionManager manager;
    String id;

    public RemoteTasksHelper(ITargetControl control, String id) {
        this.conn = control.getConnection();
        this.id = id;
    }

    private IRemoteExecutionManager getManager() throws CoreException {
        if (this.conn == null) {
            Status st = new Status(4, this.id, 1101, "Error connecting to target", null);
            throw new CoreException((IStatus)st);
        }
        if (this.manager == null) {
            try {
                this.manager = this.conn.createRemoteExecutionManager();
            }
            catch (RemoteConnectionException e) {
                Status st = new Status(4, this.id, 1101, "Error connecting to target", (Throwable)e);
                throw new CoreException((IStatus)st);
            }
        }
        return this.manager;
    }

    public void cleanup() throws CoreException {
        if (this.manager != null) {
            this.manager.cancel();
        }
        this.manager = null;
    }

    public void copyToHost(IPath local, IPath remote) throws CoreException {
        try {
            FileInputStream fInputStream = new FileInputStream(local.toFile());
            IRemoteUploadExecution cp = this.getManager().getRemoteCopyTools().executeUpload(remote.toOSString(), (InputStream)fInputStream);
            cp.waitForEndOfExecution();
            cp.close();
        }
        catch (RemoteConnectionException e) {
            Status st = new Status(4, this.id, 1101, "Error connecting to target", (Throwable)e);
            throw new CoreException((IStatus)st);
        }
        catch (RemoteExecutionException e) {
            Status st = new Status(4, this.id, 1102, "Error executing operation in target", (Throwable)e);
            throw new CoreException((IStatus)st);
        }
        catch (CancelException e) {
            Status st = new Status(4, this.id, 1103, "Canceled", (Throwable)e);
            throw new CoreException((IStatus)st);
        }
        catch (FileNotFoundException e) {
            Status st = new Status(4, this.id, 1105, "Local File Not Found", (Throwable)e);
            throw new CoreException((IStatus)st);
        }
    }

    public void executeCmd(String cmd) throws CoreException {
        try {
            IRemoteExecutionTools exec = this.getManager().getExecutionTools();
            exec.executeBashCommand(cmd);
        }
        catch (RemoteConnectionException e) {
            Status st = new Status(4, this.id, 1101, "Error connecting to target", (Throwable)e);
            throw new CoreException((IStatus)st);
        }
        catch (RemoteExecutionException e) {
            Status st = new Status(4, this.id, 1102, "Error executing operation in target", (Throwable)e);
            throw new CoreException((IStatus)st);
        }
        catch (CancelException e) {
            Status st = new Status(4, this.id, 1103, "Canceled", (Throwable)e);
            throw new CoreException((IStatus)st);
        }
    }

    public RemoteProcess createProcess(String cmdLine) throws CoreException {
        IRemoteExecutionManager manager = this.getManager();
        this.manager = null;
        return new RemoteProcess(manager, cmdLine, this.id);
    }
}

