/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.cell.environment.launcher.pdt.internal.integration;

import java.io.File;
import java.util.LinkedList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.ptp.cell.environment.launcher.pdt.Activator;
import org.eclipse.ptp.cell.environment.launcher.pdt.debug.Debug;
import org.eclipse.ptp.cell.environment.launcher.pdt.internal.IPdtLaunchAttributes;
import org.eclipse.ptp.cell.environment.launcher.pdt.internal.PdtLaunchBean;
import org.eclipse.ptp.cell.environment.launcher.pdt.internal.integration.Messages;
import org.eclipse.ptp.remotetools.core.IRemoteCopyTools;
import org.eclipse.ptp.remotetools.core.IRemoteDirectory;
import org.eclipse.ptp.remotetools.core.IRemoteExecutionManager;
import org.eclipse.ptp.remotetools.core.IRemoteFile;
import org.eclipse.ptp.remotetools.core.IRemoteFileTools;
import org.eclipse.ptp.remotetools.core.IRemoteItem;
import org.eclipse.ptp.remotetools.environment.launcher.core.NullLaunchIntegration;
import org.eclipse.ptp.remotetools.exception.CancelException;
import org.eclipse.ptp.remotetools.exception.RemoteConnectionException;
import org.eclipse.ptp.remotetools.exception.RemoteOperationException;

public class PdtProfileIntegration
extends NullLaunchIntegration {
    IRemoteExecutionManager executionManager;
    ILaunchConfiguration config;
    ILaunch launch;
    String mode;
    IProgressMonitor monitor;
    IPath projectPath;
    PdtLaunchBean launchBean;

    public PdtProfileIntegration(ILaunchConfiguration config, String mode, ILaunch launch, IProgressMonitor monitor, PdtLaunchBean launchBean) {
        this.config = config;
        this.launch = launch;
        this.mode = mode;
        this.monitor = monitor;
        this.launchBean = launchBean;
    }

    public void setExecutionManager(IRemoteExecutionManager manager) {
        this.executionManager = manager;
    }

    public String[] createLaunchScript(String applicationFullPath, String[] arguments) throws CoreException {
        return super.createLaunchScript(applicationFullPath, arguments);
    }

    public void prepareLaunch() throws CoreException, CancelException {
        Debug.read();
        Debug.POLICY.enter(Debug.DEBUG_PROFILE_INTEGRATION);
        boolean copyXmlFile = this.config.getAttribute(IPdtLaunchAttributes.ATTR_COPY_XML_FILE, IPdtLaunchAttributes.DEFAULT_COPY_XML_FILE.booleanValue());
        String remoteXmldirPath = this.config.getAttribute(IPdtLaunchAttributes.ATTR_REMOTE_XML_DIR, IPdtLaunchAttributes.DEFAULT_REMOTE_XML_DIR);
        String localXmlfilePath = this.config.getAttribute(IPdtLaunchAttributes.ATTR_LOCAL_XML_FILE, IPdtLaunchAttributes.DEFAULT_LOCAL_XML_FILE);
        this.config.getAttribute(IPdtLaunchAttributes.ATTR_REMOTE_XML_FILE, IPdtLaunchAttributes.DEFAULT_REMOTE_XML_FILE);
        Debug.POLICY.trace(Debug.DEBUG_PROFILE_INTEGRATION_VARIABLES, "Launch attributes {0}", new Object[]{this.config.getAttributes()});
        if (copyXmlFile) {
            try {
                IRemoteFileTools remFileTools = this.executionManager.getRemoteFileTools();
                remFileTools.assureDirectory(remoteXmldirPath);
                IRemoteCopyTools remCopyTools = this.executionManager.getRemoteCopyTools();
                remCopyTools.uploadFileToDir(new File(localXmlfilePath), remoteXmldirPath);
            }
            catch (RemoteConnectionException e) {
                Debug.POLICY.error(Debug.DEBUG_PROFILE_INTEGRATION, (Throwable)e);
                Debug.POLICY.logError((Throwable)e);
                throw new CoreException((IStatus)new Status(4, Activator.getDefault().getBundle().getSymbolicName(), 0, e.getLocalizedMessage(), e.getCause()));
            }
            catch (RemoteOperationException e) {
                Debug.POLICY.error(Debug.DEBUG_PROFILE_INTEGRATION, (Throwable)e);
                Debug.POLICY.logError((Throwable)e);
                throw new CoreException((IStatus)new Status(4, Activator.getDefault().getBundle().getSymbolicName(), 0, e.getLocalizedMessage(), e.getCause()));
            }
        }
    }

    public void finalizeApplication() throws CoreException, CancelException {
        Debug.read();
        Debug.POLICY.enter(Debug.DEBUG_PROFILE_INTEGRATION);
        String pdtOutputPath = this.config.getAttribute(IPdtLaunchAttributes.ATTR_REMOTE_TRACE_DIR, IPdtLaunchAttributes.DEFAULT_REMOTE_TRACE_DIR);
        String pdtOutputPrefix = this.config.getAttribute(IPdtLaunchAttributes.ATTR_TRACE_FILE_PREFIX, IPdtLaunchAttributes.DEFAULT_TRACE_FILE_PREFIX);
        Debug.POLICY.trace(Debug.DEBUG_PROFILE_INTEGRATION_VARIABLES, "Output path {0}", new Object[]{pdtOutputPath});
        try {
            IRemoteFileTools remFileTools = this.executionManager.getRemoteFileTools();
            IRemoteDirectory pdtOutputDir = remFileTools.getDirectory(pdtOutputPath);
            Debug.POLICY.trace(Debug.DEBUG_PROFILE_INTEGRATION_VARIABLES, "Output dir {0}", new Object[]{pdtOutputDir.getPath()});
            IRemoteItem[] dirItems = remFileTools.listItems(pdtOutputDir.getPath());
            LinkedList<IRemoteFile> filteredItems = new LinkedList<IRemoteFile>();
            Debug.POLICY.trace(Debug.DEBUG_PROFILE_INTEGRATION_VARIABLES, "Non-filtered items {0}", filteredItems.toArray());
            int i = 0;
            while (i < dirItems.length) {
                block9: {
                    IRemoteFile rFile = null;
                    try {
                        rFile = remFileTools.getFile(dirItems[i].getPath());
                        Path path = new Path(dirItems[i].getPath());
                        if (path.lastSegment().matches("^" + pdtOutputPrefix + ".*")) {
                            filteredItems.add(rFile);
                        }
                    }
                    catch (RemoteOperationException e) {
                        if (e.getMessage().contains("Not a file")) break block9;
                        Debug.POLICY.error(Debug.DEBUG_PROFILE_INTEGRATION, (Throwable)e);
                        Debug.POLICY.logError((Throwable)e);
                        throw e;
                    }
                }
                ++i;
            }
            Debug.POLICY.trace(Debug.DEBUG_PROFILE_INTEGRATION_VARIABLES, "Filtered items {0}", filteredItems.toArray());
            IRemoteCopyTools copyTools = this.executionManager.getRemoteCopyTools();
            String localTraceDir = this.config.getAttribute(IPdtLaunchAttributes.ATTR_LOCAL_TRACE_DIR, IPdtLaunchAttributes.DEFAULT_LOCAL_TRACE_DIR);
            Debug.POLICY.trace(Debug.DEBUG_PROFILE_INTEGRATION_VARIABLES, "Local trace dir {0}", new Object[]{localTraceDir});
            if (filteredItems.isEmpty()) {
                Debug.POLICY.error(Debug.DEBUG_PROFILE_INTEGRATION, "No tracefile generated");
                Debug.POLICY.logError(Messages.PdtProfileIntegration_FinalizeApplication_NoTraceFileGenerated, new Object[0]);
                throw new CoreException((IStatus)new Status(4, Activator.getDefault().getBundle().getSymbolicName(), 0, Messages.PdtProfileIntegration_FinalizeApplication_NoTraceFileGenerated, null));
            }
            for (IRemoteFile remoteFile : filteredItems) {
                copyTools.downloadFileToDir(remoteFile.getPath(), localTraceDir);
            }
        }
        catch (RemoteConnectionException e) {
            Debug.POLICY.error(Debug.DEBUG_PROFILE_INTEGRATION, (Throwable)e);
            Debug.POLICY.logError((Throwable)e);
            throw new CoreException((IStatus)new Status(4, Activator.getDefault().getBundle().getSymbolicName(), 0, e.getLocalizedMessage(), e.getCause()));
        }
        catch (RemoteOperationException e) {
            Debug.POLICY.error(Debug.DEBUG_PROFILE_INTEGRATION, (Throwable)e);
            Debug.POLICY.logError((Throwable)e);
            throw new CoreException((IStatus)new Status(4, Activator.getDefault().getBundle().getSymbolicName(), 0, e.getLocalizedMessage(), e.getCause()));
        }
        Debug.POLICY.exit(Debug.DEBUG_PROFILE_INTEGRATION);
    }
}

