/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.cell.alf.ui.core;

import org.eclipse.ptp.cell.alf.ui.Messages;
import org.eclipse.ptp.cell.alf.ui.wizard.ALFWizardPageA;
import org.eclipse.ptp.cell.alf.ui.wizard.ALFWizardPageB;

public class ALFBufferValidator {
    private static Type[] TYPES;
    private static String[] KEYWORDS;
    private ALFWizardPageB pageB;

    static {
        Type[] typeArray = new Type[33];
        int[] nArray = new int[2];
        nArray[1] = 8;
        typeArray[0] = new Type("char", nArray, new int[]{Integer.parseInt(Messages.ALFBufferValidator_sizeOfChar)});
        int[] nArray2 = new int[2];
        nArray2[1] = 8;
        typeArray[1] = new Type("signed char", nArray2, new int[]{Integer.parseInt(Messages.ALFBufferValidator_sizeOfChar)});
        int[] nArray3 = new int[2];
        nArray3[1] = 8;
        typeArray[2] = new Type("unsigned char", nArray3, new int[]{Integer.parseInt(Messages.ALFBufferValidator_sizeOfChar)});
        typeArray[3] = new Type("wchar_t", new int[]{1, 8}, new int[]{Integer.parseInt(Messages.ALFBufferValidator_sizeOfShort)});
        typeArray[4] = new Type("short", new int[]{1, 8}, new int[]{Integer.parseInt(Messages.ALFBufferValidator_sizeOfShort)});
        typeArray[5] = new Type("short int", new int[]{1, 8}, new int[]{Integer.parseInt(Messages.ALFBufferValidator_sizeOfShort)});
        typeArray[6] = new Type("signed short", new int[]{1, 8}, new int[]{Integer.parseInt(Messages.ALFBufferValidator_sizeOfShort)});
        typeArray[7] = new Type("signed short int", new int[]{1, 8}, new int[]{Integer.parseInt(Messages.ALFBufferValidator_sizeOfShort)});
        typeArray[8] = new Type("unsigned short", new int[]{1, 8}, new int[]{Integer.parseInt(Messages.ALFBufferValidator_sizeOfShort)});
        typeArray[9] = new Type("unsigned short int", new int[]{1, 8}, new int[]{Integer.parseInt(Messages.ALFBufferValidator_sizeOfShort)});
        typeArray[10] = new Type("int", new int[]{1, 2, 6, 8}, new int[]{Integer.parseInt(Messages.ALFBufferValidator_sizeOfInt)});
        typeArray[11] = new Type("signed", new int[]{1, 2, 6, 8}, new int[]{Integer.parseInt(Messages.ALFBufferValidator_sizeOfInt)});
        typeArray[12] = new Type("signed int", new int[]{1, 2, 6, 8}, new int[]{Integer.parseInt(Messages.ALFBufferValidator_sizeOfInt)});
        typeArray[13] = new Type("unsigned", new int[]{1, 2, 6, 8}, new int[]{Integer.parseInt(Messages.ALFBufferValidator_sizeOfInt)});
        typeArray[14] = new Type("unsigned int", new int[]{1, 2, 6, 8}, new int[]{Integer.parseInt(Messages.ALFBufferValidator_sizeOfInt)});
        typeArray[15] = new Type("long", new int[]{2, 3, 6, 7, 8}, new int[]{Integer.parseInt(Messages.ALFBufferValidator_sizeOfLong32bit), Integer.parseInt(Messages.ALFBufferValidator_sizeOfLong64bit)});
        typeArray[16] = new Type("long int", new int[]{2, 3, 6, 7, 8}, new int[]{Integer.parseInt(Messages.ALFBufferValidator_sizeOfLong32bit), Integer.parseInt(Messages.ALFBufferValidator_sizeOfLong64bit)});
        typeArray[17] = new Type("signed long", new int[]{2, 3, 6, 7, 8}, new int[]{Integer.parseInt(Messages.ALFBufferValidator_sizeOfLong32bit), Integer.parseInt(Messages.ALFBufferValidator_sizeOfLong64bit)});
        typeArray[18] = new Type("signed long int", new int[]{2, 3, 6, 7, 8}, new int[]{Integer.parseInt(Messages.ALFBufferValidator_sizeOfLong32bit), Integer.parseInt(Messages.ALFBufferValidator_sizeOfLong64bit)});
        typeArray[19] = new Type("unsigned long", new int[]{2, 3, 6, 7, 8}, new int[]{Integer.parseInt(Messages.ALFBufferValidator_sizeOfLong32bit), Integer.parseInt(Messages.ALFBufferValidator_sizeOfLong64bit)});
        typeArray[20] = new Type("unsigned long int", new int[]{2, 3, 6, 7, 8}, new int[]{Integer.parseInt(Messages.ALFBufferValidator_sizeOfLong32bit), Integer.parseInt(Messages.ALFBufferValidator_sizeOfLong64bit)});
        typeArray[21] = new Type("long long", new int[]{3, 7, 8}, new int[]{Integer.parseInt(Messages.ALFBufferValidator_sizeOfLongLong)});
        typeArray[22] = new Type("long long int", new int[]{3, 7, 8}, new int[]{Integer.parseInt(Messages.ALFBufferValidator_sizeOfLongLong)});
        typeArray[23] = new Type("signed long long", new int[]{3, 7, 8}, new int[]{Integer.parseInt(Messages.ALFBufferValidator_sizeOfLongLong)});
        typeArray[24] = new Type("signed long long int", new int[]{3, 7, 8}, new int[]{Integer.parseInt(Messages.ALFBufferValidator_sizeOfLongLong)});
        typeArray[25] = new Type("unsigned long long", new int[]{3, 7, 8}, new int[]{Integer.parseInt(Messages.ALFBufferValidator_sizeOfLongLong)});
        typeArray[26] = new Type("unsigned long long int", new int[]{3, 7, 8}, new int[]{Integer.parseInt(Messages.ALFBufferValidator_sizeOfLongLong)});
        typeArray[27] = new Type("float", new int[]{4, 2, 8}, new int[]{Integer.parseInt(Messages.ALFBufferValidator_sizeOfFloat)});
        typeArray[28] = new Type("double", new int[]{5, 3, 8}, new int[]{Integer.parseInt(Messages.ALFBufferValidator_sizeOfDouble)});
        typeArray[29] = new Type("long double", new int[]{5, 3, 8}, new int[]{Integer.parseInt(Messages.ALFBufferValidator_sizeOfLongDouble32bit), Integer.parseInt(Messages.ALFBufferValidator_sizeOfLongDouble64bit)});
        int[] nArray4 = new int[2];
        nArray4[1] = 8;
        typeArray[30] = new Type("_Bool", nArray4, new int[]{Integer.parseInt(Messages.ALFBufferValidator_sizeOfBool)});
        typeArray[31] = new Type("void*", new int[0], new int[]{Integer.parseInt(Messages.ALFBufferValidator_sizeOfVoid32bit), Integer.parseInt(Messages.ALFBufferValidator_sizeOfVoid64bit)});
        typeArray[32] = new Type("void *", new int[0], new int[]{Integer.parseInt(Messages.ALFBufferValidator_sizeOfVoid32bit), Integer.parseInt(Messages.ALFBufferValidator_sizeOfVoid64bit)});
        TYPES = typeArray;
        KEYWORDS = new String[]{"asm", "auto", "break", "case", "char", "const", "continue", "default", "do", "double", "else", "enum", "extern", "float", "for", "goto", "if", "int", "inline", "long", "register", "restrict", "return", "short", "signed", "sizeof", "static", "struct", "switch", "typedef", "typeof", "union", "unsigned", "void", "volatile", "while", "_Bool", "_Complex", "_Imaginary"};
    }

    public ALFBufferValidator(ALFWizardPageB pageB) {
        this.pageB = pageB;
    }

    public static long computeDataTransferSize(String elementType, int numDim, long distSizeX, long distSizeY, long distSizeZ, boolean is64bit) {
        boolean isBuiltInType = false;
        int i = 0;
        while (i < TYPES.length) {
            if (elementType.equals(TYPES[i].getValue())) {
                isBuiltInType = true;
                break;
            }
            ++i;
        }
        if (!isBuiltInType) {
            return -1L;
        }
        int sizeof = TYPES[i].getSizeOf(is64bit);
        long dataTransferSize = 0L;
        switch (numDim) {
            case 0: {
                dataTransferSize = (long)sizeof * distSizeX;
                break;
            }
            case 1: {
                dataTransferSize = (long)sizeof * distSizeX * distSizeY;
                break;
            }
            case 2: {
                dataTransferSize = (long)sizeof * distSizeX * distSizeY * distSizeZ;
            }
        }
        return dataTransferSize;
    }

    public int getExpectedAccelNum() {
        ALFWizardPageA pageA = (ALFWizardPageA)this.pageB.getPreviousPage();
        if (pageA != null) {
            return pageA.getExpAccelNum();
        }
        return -1;
    }

    public String isNameValid(String bufferName) {
        if (bufferName == null || bufferName.length() == 0) {
            return null;
        }
        if (this.pageB.doesSameBufferNameExist(bufferName)) {
            return String.valueOf(Messages.ALFBufferValidator_errorMsg) + Messages.ALFBufferValidator_errorMsgSameNameExists;
        }
        char c = bufferName.charAt(0);
        if (!(c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c == '_')) {
            return String.valueOf(Messages.ALFBufferValidator_errorMsg) + Messages.ALFBufferValidator_errorMsgInvalidName1;
        }
        int i = 0;
        while (i < KEYWORDS.length) {
            if (bufferName.equals(KEYWORDS[i])) {
                return String.valueOf(Messages.ALFBufferValidator_errorMsg) + Messages.ALFBufferValidator_errorMsgInvalidName2;
            }
            ++i;
        }
        i = 0;
        while (i < bufferName.length()) {
            c = bufferName.charAt(i);
            if (!(c >= '0' && c <= '9' || c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c == '_')) {
                return String.valueOf(Messages.ALFBufferValidator_errorMsg) + Messages.ALFBufferValidator_errorMsgInvalidName3;
            }
            ++i;
        }
        return null;
    }

    public String isTypeAndUnitValid(String elementType, int elementUnit) {
        if (elementType == null || elementType.length() == 0) {
            return null;
        }
        boolean isBuiltInType = false;
        int i = 0;
        while (i < TYPES.length) {
            if (elementType.equals(TYPES[i].getValue())) {
                isBuiltInType = true;
                break;
            }
            ++i;
        }
        if (isBuiltInType) {
            if (TYPES[i].getValue().equals("void*") || TYPES[i].getValue().equals("void *")) {
                return String.valueOf(Messages.ALFBufferValidator_warningMsg) + Messages.ALFBufferValidator_warningMsgVoidStar;
            }
            if (!TYPES[i].containsUnit(elementUnit)) {
                return String.valueOf(Messages.ALFBufferValidator_warningMsg) + Messages.ALFBufferValidator_warningMsgIncompatibleUnit;
            }
        } else {
            int j = 0;
            char c = elementType.charAt(0);
            if (!(c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c == '_')) {
                return String.valueOf(Messages.ALFBufferValidator_errorMsg) + Messages.ALFBufferValidator_errorMsgInvalidType1;
            }
            j = 1;
            while (j < elementType.length()) {
                c = elementType.charAt(j);
                if (!(c >= '0' && c <= '9' || c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c == '_')) {
                    return String.valueOf(Messages.ALFBufferValidator_errorMsg) + Messages.ALFBufferValidator_errorMsgInvalidType2;
                }
                ++j;
            }
        }
        return null;
    }

    public String isNumDTEntriesValid(int numDim, long dimSizeX, long dimSizeY, long dimSizeZ, long distSizeX, long distSizeY, long distSizeZ) {
        long numDT;
        switch (numDim) {
            case 0: {
                if (distSizeX == 0L) {
                    return String.valueOf(Messages.ALFBufferValidator_errorMsg) + Messages.ALFBufferValidator_errorMsgNumDTEntries;
                }
                numDT = dimSizeX / distSizeX;
                break;
            }
            case 1: {
                if (distSizeX == 0L || distSizeY == 0L) {
                    return String.valueOf(Messages.ALFBufferValidator_errorMsg) + Messages.ALFBufferValidator_errorMsgNumDTEntries;
                }
                numDT = dimSizeX / distSizeX * (dimSizeY / distSizeY);
                break;
            }
            case 2: {
                if (distSizeX == 0L || distSizeY == 0L || distSizeZ == 0L) {
                    return String.valueOf(Messages.ALFBufferValidator_errorMsg) + Messages.ALFBufferValidator_errorMsgNumDTEntries;
                }
                numDT = dimSizeX / distSizeX * (dimSizeY / distSizeY) * (dimSizeZ / distSizeZ);
                break;
            }
            default: {
                throw new IllegalArgumentException("An illegal argument has been passed while trying to verify the number of data transfer entries.");
            }
        }
        return this.pageB.isNumDTEntriesValid(numDT) ? null : String.valueOf(Messages.ALFBufferValidator_errorMsg) + Messages.ALFBufferValidator_errorMsgNumDTEntries;
    }

    public static String is16ByteAligned(String elementType, int numDim, long distSizeX, long distSizeY, long distSizeZ, boolean is64bit) {
        if (elementType == null || elementType.length() == 0) {
            return null;
        }
        long dataTransferSize = ALFBufferValidator.computeDataTransferSize(elementType, numDim, distSizeX, distSizeY, distSizeZ, is64bit);
        if (dataTransferSize == -1L || dataTransferSize == 1L || dataTransferSize == 2L || dataTransferSize == 4L || dataTransferSize == 8L || dataTransferSize == 16L || dataTransferSize % 16L == 0L) {
            return null;
        }
        return Messages.ALFBufferValidator_warningMsgNot16ByteAligned;
    }

    public String isValid(String bufferName, String elementType, int elementUnit, int bufferType, int numDim, String dimSizeX, String dimSizeY, String dimSizeZ, int distModelX, int distModelY, int distModelZ, String distSizeX, String distSizeY, String distSizeZ) {
        String errMsg;
        long distributionSizeZ;
        long distributionSizeY;
        long distributionSizeX;
        long dimensionSizeZ;
        long dimensionSizeY;
        long dimensionSizeX;
        try {
            dimensionSizeX = Long.parseLong(dimSizeX);
        }
        catch (NumberFormatException numberFormatException) {
            return String.valueOf(Messages.ALFBufferValidator_errorMsg) + Messages.ALFBufferValidator_errorMsgDimensionSizeX;
        }
        try {
            dimensionSizeY = Long.parseLong(dimSizeY);
        }
        catch (NumberFormatException numberFormatException) {
            return String.valueOf(Messages.ALFBufferValidator_errorMsg) + Messages.ALFBufferValidator_errorMsgDimensionSizeY;
        }
        try {
            dimensionSizeZ = Long.parseLong(dimSizeZ);
        }
        catch (NumberFormatException numberFormatException) {
            return String.valueOf(Messages.ALFBufferValidator_errorMsg) + Messages.ALFBufferValidator_errorMsgDimensionSizeZ;
        }
        try {
            distributionSizeX = Long.parseLong(distSizeX);
        }
        catch (NumberFormatException numberFormatException) {
            return String.valueOf(Messages.ALFBufferValidator_errorMsg) + Messages.ALFBufferValidator_errorMsgDistributionSizeX1;
        }
        try {
            distributionSizeY = Long.parseLong(distSizeY);
        }
        catch (NumberFormatException numberFormatException) {
            return String.valueOf(Messages.ALFBufferValidator_errorMsg) + Messages.ALFBufferValidator_errorMsgDistributionSizeY1;
        }
        try {
            distributionSizeZ = Long.parseLong(distSizeZ);
        }
        catch (NumberFormatException numberFormatException) {
            return String.valueOf(Messages.ALFBufferValidator_errorMsg) + Messages.ALFBufferValidator_errorMsgDistributionSizeZ1;
        }
        int expAccelNum = this.getExpectedAccelNum();
        if (numDim == 2) {
            if (dimensionSizeZ < 1L) {
                return String.valueOf(Messages.ALFBufferValidator_errorMsg) + Messages.ALFBufferValidator_errorMsgDimensionSizeZ;
            }
            if (expAccelNum == 0 && distModelZ == 1) {
                return String.valueOf(Messages.ALFBufferValidator_errorMsg) + Messages.ALFBufferValidator_errorMsgBlock;
            }
            if (distModelZ == 1 && distributionSizeZ < 1L) {
                return String.valueOf(Messages.ALFBufferValidator_errorMsg) + Messages.ALFBufferValidator_errorMsgDistributionSizeZ2;
            }
            if (distModelX == 2 || distModelY == 2) {
                return String.valueOf(Messages.ALFBufferValidator_errorMsg) + Messages.ALFBufferValidator_errorMsgCyclic;
            }
        }
        if (numDim == 1 || numDim == 2) {
            if (dimensionSizeY < 1L) {
                return String.valueOf(Messages.ALFBufferValidator_errorMsg) + Messages.ALFBufferValidator_errorMsgDimensionSizeY;
            }
            if (expAccelNum == 0 && distModelY == 1) {
                return String.valueOf(Messages.ALFBufferValidator_errorMsg) + Messages.ALFBufferValidator_errorMsgBlock;
            }
            if (distModelY == 1 && distributionSizeY < 1L) {
                return String.valueOf(Messages.ALFBufferValidator_errorMsg) + Messages.ALFBufferValidator_errorMsgDistributionSizeY3;
            }
            if (distModelY == 2 && (distributionSizeY < 1L || distributionSizeY > dimensionSizeY)) {
                return String.valueOf(Messages.ALFBufferValidator_errorMsg) + Messages.ALFBufferValidator_errorMsgDistributionSizeY1;
            }
        }
        if (numDim == 0 || numDim == 1 || numDim == 2) {
            if (dimensionSizeX < 1L) {
                return String.valueOf(Messages.ALFBufferValidator_errorMsg) + Messages.ALFBufferValidator_errorMsgDimensionSizeX;
            }
            if (expAccelNum == 0 && distModelX == 1) {
                return String.valueOf(Messages.ALFBufferValidator_errorMsg) + Messages.ALFBufferValidator_errorMsgBlock;
            }
            if (distModelX == 1 && distributionSizeX < 1L) {
                return String.valueOf(Messages.ALFBufferValidator_errorMsg) + Messages.ALFBufferValidator_errorMsgDistributionSizeX3;
            }
            if (distModelX == 2 && (distributionSizeX < 1L || distributionSizeX > dimensionSizeX)) {
                return String.valueOf(Messages.ALFBufferValidator_errorMsg) + Messages.ALFBufferValidator_errorMsgDistributionSizeX1;
            }
        }
        if ((errMsg = this.isNameValid(bufferName)) != null) {
            return errMsg;
        }
        errMsg = this.isTypeAndUnitValid(elementType, elementUnit);
        return null;
    }

    static class Type {
        String value;
        int[] units;
        int[] sizeof;

        Type(String value, int[] unit, int[] sizeof) {
            this.value = value;
            this.units = unit;
            this.sizeof = sizeof;
        }

        String getValue() {
            return this.value;
        }

        boolean containsUnit(int unit) {
            if (this.units == null || this.units.length == 0) {
                return true;
            }
            int i = 0;
            while (i < this.units.length) {
                if (this.units[i] == unit) {
                    return true;
                }
                ++i;
            }
            return false;
        }

        int getSizeOf(boolean is64Bit) {
            if (is64Bit && this.sizeof.length > 1) {
                return this.sizeof[1];
            }
            return this.sizeof[0];
        }
    }
}

