/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.cell.sputiming.ui.views;

import org.eclipse.ptp.cell.sputiming.ui.Activator;
import org.eclipse.ptp.cell.sputiming.ui.debug.Debug;
import org.eclipse.ptp.cell.sputiming.ui.parse.ParsedTimingFile;
import org.eclipse.ptp.cell.sputiming.ui.views.TimeDiagram;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.part.ViewPart;

public class SpuTimingDiagramView
extends ViewPart {
    TimeDiagram diagram;
    Composite parent;
    ScrolledComposite sc;

    public void createPartControl(Composite parent) {
        this.parent = parent;
        Debug.POLICY.trace(Debug.DEBUG_UI, "Start creating view");
        parent.setLayout((Layout)new FillLayout());
        this.sc = new ScrolledComposite(parent, 768);
        Activator.getDefault().setView(this);
        ParsedTimingFile parsedTiming = Activator.getDefault().getTiming();
        if (parsedTiming != null) {
            this.diagram = new TimeDiagram((Composite)this.sc, parsedTiming);
            this.sc.setContent((Control)this.diagram);
            this.sc.setExpandHorizontal(true);
            this.sc.setExpandVertical(true);
            this.sc.setMinSize(this.diagram.getSize().x, this.diagram.getSize().y);
        }
        Debug.POLICY.trace(Debug.DEBUG_UI, "Finished creating view");
    }

    public void setFocus() {
        if (this.diagram != null) {
            this.diagram.setFocus();
        }
    }

    public void invalidateTiming() {
        Debug.POLICY.trace(Debug.DEBUG_UI, "Request to update view");
        Display display = this.parent.getDisplay();
        display.syncExec(new Runnable(){

            public void run() {
                try {
                    ParsedTimingFile parsedTiming;
                    Debug.POLICY.trace(Debug.DEBUG_UI, "Start view update thread");
                    if (SpuTimingDiagramView.this.diagram != null) {
                        Debug.POLICY.trace(Debug.DEBUG_UI, "Dispose old sputiming diagram");
                        SpuTimingDiagramView.this.diagram.dispose();
                    }
                    if ((parsedTiming = Activator.getDefault().getTiming()) != null) {
                        Debug.POLICY.trace(Debug.DEBUG_UI, "Creating new sputiming diagram");
                        SpuTimingDiagramView.this.diagram = new TimeDiagram((Composite)SpuTimingDiagramView.this.sc, parsedTiming);
                        SpuTimingDiagramView.this.sc.setContent((Control)SpuTimingDiagramView.this.diagram);
                        SpuTimingDiagramView.this.sc.setExpandHorizontal(true);
                        SpuTimingDiagramView.this.sc.setExpandVertical(true);
                        SpuTimingDiagramView.this.sc.setMinSize(SpuTimingDiagramView.this.diagram.getSize().x, SpuTimingDiagramView.this.diagram.getSize().y);
                    }
                    Debug.POLICY.trace(Debug.DEBUG_UI, "Finished view update thread");
                }
                catch (Exception e) {
                    Debug.POLICY.error(Debug.DEBUG_UI, (Throwable)e);
                    Debug.POLICY.logError((Throwable)e);
                }
            }
        });
    }

    public void dispose() {
        super.dispose();
        Activator.getDefault().setView(null);
    }
}

