/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.rdt.ui.includebrowser;

import java.util.HashMap;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.internal.ui.CPluginImages;
import org.eclipse.cdt.internal.ui.includebrowser.IBNode;
import org.eclipse.cdt.internal.ui.viewsupport.ImageImageDescriptor;
import org.eclipse.cdt.ui.CElementImageDescriptor;
import org.eclipse.cdt.ui.CElementLabelProvider;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.ptp.internal.rdt.ui.includebrowser.IBContentProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Display;

public class IBLabelProvider
extends LabelProvider
implements IColorProvider {
    private CElementLabelProvider fCLabelProvider = new CElementLabelProvider();
    private Color fColorInactive;
    private IBContentProvider fContentProvider;
    private HashMap<String, Image> fCachedImages = new HashMap();
    private boolean fShowFolders;

    public IBLabelProvider(Display display, IBContentProvider cp) {
        this.fColorInactive = display.getSystemColor(16);
        this.fContentProvider = cp;
    }

    public Image getImage(Object element) {
        if (element instanceof IBNode) {
            IBNode node = (IBNode)element;
            ITranslationUnit tu = node.getRepresentedTranslationUnit();
            Image image = tu != null ? this.fCLabelProvider.getImage((Object)tu) : CPluginImages.get((String)"org.eclipse.cdt.ui.h_file_obj.gif");
            return this.decorateImage(image, node);
        }
        return super.getImage(element);
    }

    public String getText(Object element) {
        if (element instanceof IBNode) {
            IBNode node = (IBNode)element;
            IPath path = node.getRepresentedPath();
            if (path != null) {
                if (this.fShowFolders) {
                    return String.valueOf(path.lastSegment()) + " (" + path.removeLastSegments(1) + ")";
                }
                return path.lastSegment();
            }
            return node.getDirectiveName();
        }
        return super.getText(element);
    }

    public void dispose() {
        this.fCLabelProvider.dispose();
        for (Image image : this.fCachedImages.values()) {
            image.dispose();
        }
        this.fCachedImages.clear();
        super.dispose();
    }

    private Image decorateImage(Image image, IBNode node) {
        int flags = 0;
        if (node.isSystemInclude()) {
            flags |= 0x2000;
        }
        if (!node.isActiveCode()) {
            flags |= 0x8000;
        }
        if (node.isRecursive()) {
            flags |= 0x1000;
        } else if (this.fContentProvider.hasChildren(node)) {
            flags = this.fContentProvider.getComputeIncludedBy() ? (flags |= 0x800) : (flags |= 0x200);
        }
        if (node.isActiveCode() && node.getRepresentedIFL() == null) {
            flags |= 0x20;
        }
        if (flags == 0) {
            return image;
        }
        String key = String.valueOf(image.toString()) + String.valueOf(flags);
        Image result = this.fCachedImages.get(key);
        if (result == null) {
            CElementImageDescriptor desc = new CElementImageDescriptor((ImageDescriptor)new ImageImageDescriptor(image), flags, new Point(20, 16));
            result = desc.createImage();
            this.fCachedImages.put(key, result);
        }
        return result;
    }

    public Color getBackground(Object element) {
        return null;
    }

    public Color getForeground(Object element) {
        IBNode node;
        if (element instanceof IBNode && !(node = (IBNode)element).isActiveCode()) {
            return this.fColorInactive;
        }
        return null;
    }

    public void setShowFolders(boolean show) {
        this.fShowFolders = show;
    }
}

