/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.remotetools.environment.ui.views;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.ptp.remotetools.environment.EnvironmentPlugin;
import org.eclipse.ptp.remotetools.environment.control.ITargetControl;
import org.eclipse.ptp.remotetools.environment.core.ITargetElement;
import org.eclipse.ptp.remotetools.environment.core.ITargetEventListener;
import org.eclipse.ptp.remotetools.environment.core.TargetElement;
import org.eclipse.ptp.remotetools.environment.core.TargetEnvironmentManager;
import org.eclipse.ptp.remotetools.environment.core.TargetTypeElement;
import org.eclipse.ptp.remotetools.environment.extension.INode;
import org.eclipse.ptp.remotetools.environment.ui.UIEnvironmentPlugin;
import org.eclipse.ptp.remotetools.environment.wizard.EnvironmentWizard;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.part.ViewPart;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoteToolsEnvironmentView
extends ViewPart
implements ISelectionChangedListener,
ITargetEventListener {
    private TreeViewer viewer;
    private Action startAction;
    private Action stopAction;
    private Action resumeAction;
    private Action pauseAction;
    private Action createAction;
    private Action editAction;
    private Action removeAction;
    private Action doubleClickAction;
    private List<Action> workloadControllers = new ArrayList<Action>();
    private final String ENVIRONMENT_CONTROL_NAME = "Target Environment";
    private final String ENVIRONMENT_CONTROL_STATUS = "Status";
    private String[] columnNames = new String[]{"Target Environment", "Status"};
    TargetEnvironmentManager model = EnvironmentPlugin.getDefault().getTargetsManager();
    ITargetElement currentElement = null;

    public void createPartControl(Composite parent) {
        this.viewer = new TreeViewer(parent, 770);
        this.viewer.setContentProvider((IContentProvider)new ViewContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new ViewLabelProvider());
        this.viewer.setSorter((ViewerSorter)new NameSorter());
        this.defineTable(this.viewer);
        this.viewer.setColumnProperties(this.columnNames);
        this.viewer.setInput((Object)this.model.getTypeElements().toArray());
        this.viewer.refresh();
        this.getSite().setSelectionProvider((ISelectionProvider)this.viewer);
        this.viewer.addSelectionChangedListener((ISelectionChangedListener)this);
        this.workloadControllers = this.getWorkloadControllers();
        for (Action controller : this.workloadControllers) {
            if (!(controller instanceof ISelectionChangedListener)) continue;
            this.viewer.addSelectionChangedListener((ISelectionChangedListener)controller);
        }
        this.model.addModelEventListener((ITargetEventListener)this);
        this.makeActions();
        this.hookContextMenu();
        this.hookDoubleClickAction();
        this.contributeToActionBars();
        parent.pack();
        this.viewer.reveal((Object)this.viewer.getTree().getItem(0));
    }

    private void defineTable(TreeViewer viewer) {
        Tree t = viewer.getTree();
        t.setHeaderVisible(true);
        TreeColumn column = new TreeColumn(t, 16384, 0);
        column.setText("Target Environment");
        column.setWidth(650);
        column = new TreeColumn(t, 131072, 1);
        column.setText("Status");
        column.setWidth(50);
        viewer.expandAll();
        t.setHeaderVisible(true);
        t.setLinesVisible(true);
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                ISelection selection = RemoteToolsEnvironmentView.this.viewer.getSelection();
                Object obj = ((IStructuredSelection)selection).getFirstElement();
                if (obj != null) {
                    if (TargetElement.class.isAssignableFrom(obj.getClass())) {
                        RemoteToolsEnvironmentView.this.createAction.setEnabled(false);
                        ITargetElement temp = (ITargetElement)obj;
                        if (temp.getStatus() == 1) {
                            RemoteToolsEnvironmentView.this.editAction.setEnabled(true);
                            RemoteToolsEnvironmentView.this.removeAction.setEnabled(true);
                        } else {
                            RemoteToolsEnvironmentView.this.editAction.setEnabled(false);
                            RemoteToolsEnvironmentView.this.removeAction.setEnabled(false);
                        }
                        RemoteToolsEnvironmentView.this.fillContextMenu(manager);
                    } else if (TargetTypeElement.class.isAssignableFrom(obj.getClass())) {
                        RemoteToolsEnvironmentView.this.createAction.setEnabled(true);
                        RemoteToolsEnvironmentView.this.editAction.setEnabled(false);
                        RemoteToolsEnvironmentView.this.removeAction.setEnabled(false);
                        RemoteToolsEnvironmentView.this.fillContextMenu(manager);
                    }
                }
            }
        });
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.viewer);
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager manager) {
    }

    private void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.createAction);
        manager.add((IAction)this.editAction);
        manager.add((IAction)this.removeAction);
        manager.add((IContributionItem)new Separator("additions"));
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        for (Action controller : this.workloadControllers) {
            manager.add((IAction)controller);
        }
        manager.add((IAction)this.startAction);
        manager.add((IAction)this.stopAction);
        manager.add((IAction)this.resumeAction);
        manager.add((IAction)this.pauseAction);
    }

    private List<Action> getWorkloadControllers() {
        ArrayList<Action> actions = new ArrayList<Action>();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = registry.getExtensionPoint("org.eclipse.ptp.remotetools.environment.ui.workloadController");
        IExtension[] extensions = extensionPoint.getExtensions();
        try {
            int i = 0;
            while (i < extensions.length) {
                IExtension extension = extensions[i];
                IConfigurationElement[] elements = extension.getConfigurationElements();
                int j = 0;
                while (j < elements.length) {
                    IConfigurationElement element = elements[j];
                    if ("controllerDelegate".equals(element.getName())) {
                        actions.add((Action)element.createExecutableExtension("class"));
                    }
                    ++j;
                }
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return actions.isEmpty() ? Collections.EMPTY_LIST : actions;
    }

    public void refresh() {
        Display display = this.viewer.getControl().getDisplay();
        display.asyncExec(new Runnable(){

            public void run() {
                if (!RemoteToolsEnvironmentView.this.viewer.getControl().isDisposed()) {
                    RemoteToolsEnvironmentView.this.viewer.refresh(true);
                }
            }
        });
    }

    private void makeActions() {
        URL url = UIEnvironmentPlugin.getDefault().getBundle().getEntry("/icons/run_exc.gif");
        ImageDescriptor imageRun = ImageDescriptor.createFromURL((URL)url);
        url = UIEnvironmentPlugin.getDefault().getBundle().getEntry("/icons/terminatedlaunch.gif");
        ImageDescriptor imageStop = ImageDescriptor.createFromURL((URL)url);
        url = UIEnvironmentPlugin.getDefault().getBundle().getEntry("/icons/suspend.gif");
        ImageDescriptor imageSuspend = ImageDescriptor.createFromURL((URL)url);
        url = UIEnvironmentPlugin.getDefault().getBundle().getEntry("/icons/resume.gif");
        ImageDescriptor imageResume = ImageDescriptor.createFromURL((URL)url);
        IWorkbenchPartSite site = this.getSite();
        final Shell shell = site.getShell();
        final IJobChangeListener ijob = new IJobChangeListener(){

            public void aboutToRun(IJobChangeEvent event) {
            }

            public void awake(IJobChangeEvent event) {
            }

            public void done(IJobChangeEvent event) {
                RemoteToolsEnvironmentView.this.refresh();
            }

            public void running(IJobChangeEvent event) {
            }

            public void scheduled(IJobChangeEvent event) {
            }

            public void sleeping(IJobChangeEvent event) {
            }
        };
        this.startAction = new Action(){

            public void run() {
                ISelection selection = RemoteToolsEnvironmentView.this.viewer.getSelection();
                final Object obj = ((IStructuredSelection)selection).getFirstElement();
                if (obj != null && TargetElement.class.isAssignableFrom(obj.getClass())) {
                    Job job = new Job("Start the  Environment"){

                        protected IStatus run(IProgressMonitor monitor) {
                            RemoteToolsEnvironmentView.this.startAction.setEnabled(false);
                            IStatus status = null;
                            ITargetElement element = null;
                            ITargetControl control = null;
                            try {
                                element = (ITargetElement)obj;
                                control = element.getControl();
                                if (control.create(monitor)) {
                                    status = Status.OK_STATUS;
                                }
                            }
                            catch (CoreException e) {
                                status = e.getStatus();
                                RemoteToolsEnvironmentView.this.startAction.setEnabled(true);
                            }
                            return status;
                        }
                    };
                    job.setUser(true);
                    job.schedule();
                    job.addJobChangeListener(ijob);
                    return;
                }
                RemoteToolsEnvironmentView.this.showMessage("Please Select a Target Configuration first", RemoteToolsEnvironmentView.this.viewer);
            }
        };
        this.startAction.setText("Create");
        this.startAction.setToolTipText("Start the Environment");
        this.startAction.setImageDescriptor(imageRun);
        this.stopAction = new Action(){

            public void run() {
                ISelection selection = RemoteToolsEnvironmentView.this.viewer.getSelection();
                final Object obj = ((IStructuredSelection)selection).getFirstElement();
                if (obj != null && TargetElement.class.isAssignableFrom(obj.getClass())) {
                    Job job = new Job("Stop the  Environment"){

                        protected IStatus run(IProgressMonitor monitor) {
                            RemoteToolsEnvironmentView.this.stopAction.setEnabled(false);
                            IStatus status = null;
                            try {
                                if (((ITargetElement)obj).getControl().kill(monitor)) {
                                    status = Status.OK_STATUS;
                                }
                            }
                            catch (CoreException e) {
                                status = e.getStatus();
                                RemoteToolsEnvironmentView.this.stopAction.setEnabled(true);
                            }
                            return status;
                        }
                    };
                    job.setUser(true);
                    job.schedule();
                    job.addJobChangeListener(ijob);
                    return;
                }
                RemoteToolsEnvironmentView.this.showMessage("Please Select a Target Configuration first", RemoteToolsEnvironmentView.this.viewer);
            }
        };
        this.stopAction.setText("Kill");
        this.stopAction.setToolTipText("Kill the Environment");
        this.stopAction.setImageDescriptor(imageStop);
        this.resumeAction = new Action(){

            public void run() {
                ISelection selection = RemoteToolsEnvironmentView.this.viewer.getSelection();
                final Object obj = ((IStructuredSelection)selection).getFirstElement();
                if (obj != null && TargetElement.class.isAssignableFrom(obj.getClass())) {
                    Job job = new Job("Resume the  Environment"){

                        protected IStatus run(IProgressMonitor monitor) {
                            RemoteToolsEnvironmentView.this.resumeAction.setEnabled(false);
                            IStatus status = null;
                            try {
                                if (((ITargetElement)obj).getControl().resume(monitor)) {
                                    status = Status.OK_STATUS;
                                    RemoteToolsEnvironmentView.this.pauseAction.setEnabled(true);
                                }
                            }
                            catch (CoreException e) {
                                status = e.getStatus();
                                RemoteToolsEnvironmentView.this.resumeAction.setEnabled(true);
                            }
                            return status;
                        }
                    };
                    job.setUser(true);
                    job.schedule();
                    job.addJobChangeListener(ijob);
                    return;
                }
                RemoteToolsEnvironmentView.this.showMessage("Please Select a Target Configuration first", RemoteToolsEnvironmentView.this.viewer);
            }
        };
        this.resumeAction.setText("Resume");
        this.resumeAction.setToolTipText("Resume");
        this.resumeAction.setImageDescriptor(imageResume);
        this.pauseAction = new Action(){

            public void run() {
                ISelection selection = RemoteToolsEnvironmentView.this.viewer.getSelection();
                final Object obj = ((IStructuredSelection)selection).getFirstElement();
                if (obj != null && TargetElement.class.isAssignableFrom(obj.getClass())) {
                    Job job = new Job("Pause the  Environment"){

                        protected IStatus run(IProgressMonitor monitor) {
                            RemoteToolsEnvironmentView.this.pauseAction.setEnabled(false);
                            IStatus status = null;
                            try {
                                if (((ITargetElement)obj).getControl().stop(monitor)) {
                                    status = Status.OK_STATUS;
                                    RemoteToolsEnvironmentView.this.resumeAction.setEnabled(true);
                                }
                            }
                            catch (CoreException e) {
                                status = e.getStatus();
                                RemoteToolsEnvironmentView.this.pauseAction.setEnabled(true);
                            }
                            return status;
                        }
                    };
                    job.setUser(true);
                    job.schedule();
                    job.addJobChangeListener(ijob);
                    return;
                }
                RemoteToolsEnvironmentView.this.showMessage("Please Select a Target Configuration first", RemoteToolsEnvironmentView.this.viewer);
            }
        };
        this.pauseAction.setText("Pause");
        this.pauseAction.setToolTipText("Pause");
        this.pauseAction.setImageDescriptor(imageSuspend);
        this.createAction = new Action(){

            public void run() {
                ISelection selection = RemoteToolsEnvironmentView.this.viewer.getSelection();
                Object obj = ((IStructuredSelection)selection).getFirstElement();
                if (TargetTypeElement.class.isAssignableFrom(obj.getClass())) {
                    EnvironmentWizard wizard = new EnvironmentWizard((TargetTypeElement)obj);
                    WizardDialog dialog = new WizardDialog(shell, (IWizard)wizard);
                    dialog.create();
                    dialog.setBlockOnOpen(true);
                    dialog.open();
                    RemoteToolsEnvironmentView.this.refresh();
                }
            }
        };
        this.createAction.setText("Create");
        this.createAction.setToolTipText("Creates a new configuration");
        this.editAction = new Action(){

            public void run() {
                ISelection selection = RemoteToolsEnvironmentView.this.viewer.getSelection();
                Object obj = ((IStructuredSelection)selection).getFirstElement();
                if (TargetElement.class.isAssignableFrom(obj.getClass())) {
                    EnvironmentWizard wizard = new EnvironmentWizard((ITargetElement)obj);
                    WizardDialog dialog = new WizardDialog(shell, (IWizard)wizard);
                    dialog.create();
                    dialog.setBlockOnOpen(true);
                    dialog.open();
                    RemoteToolsEnvironmentView.this.refresh();
                }
            }
        };
        this.editAction.setText("Edit");
        this.editAction.setToolTipText("Edits configuration");
        this.removeAction = new Action(){

            public void run() {
                ISelection selection = RemoteToolsEnvironmentView.this.viewer.getSelection();
                Object obj = ((IStructuredSelection)selection).getFirstElement();
                if (TargetElement.class.isAssignableFrom(obj.getClass())) {
                    ITargetElement confElement = (ITargetElement)obj;
                    if (confElement.getStatus() != 0) {
                        if (RemoteToolsEnvironmentView.this.showConfirm("Do you really want to remove ?", RemoteToolsEnvironmentView.this.viewer)) {
                            confElement.getType().removeElement(confElement);
                            RemoteToolsEnvironmentView.this.refresh();
                        }
                    } else {
                        RemoteToolsEnvironmentView.this.showMessage("Please stop this instance first !", RemoteToolsEnvironmentView.this.viewer);
                    }
                }
            }
        };
        this.removeAction.setText("Remove");
        this.removeAction.setToolTipText("Removes configuration");
        this.doubleClickAction = new Action(){

            public void run() {
                ISelection selection = RemoteToolsEnvironmentView.this.viewer.getSelection();
                Object obj = ((IStructuredSelection)selection).getFirstElement();
                if (TargetTypeElement.class.isAssignableFrom(obj.getClass())) {
                    if (RemoteToolsEnvironmentView.this.viewer.getExpandedState(obj)) {
                        RemoteToolsEnvironmentView.this.viewer.setExpandedState(obj, false);
                    } else {
                        RemoteToolsEnvironmentView.this.viewer.setExpandedState(obj, true);
                    }
                }
                if (TargetElement.class.isAssignableFrom(obj.getClass())) {
                    ITargetElement ele = (ITargetElement)obj;
                    try {
                        ITargetControl control = ele.getControl();
                        if (control.query() == 1) {
                            RemoteToolsEnvironmentView.this.editAction.run();
                        }
                    }
                    catch (CoreException e) {
                        e.printStackTrace();
                    }
                }
                if (INode.class.isAssignableFrom(obj.getClass())) {
                    INode node = (INode)obj;
                    UIEnvironmentPlugin.getDefault().getDoubleClickHandlerManager().doubleClickExecute(node);
                }
            }
        };
        this.stopAction.setEnabled(false);
        this.resumeAction.setEnabled(false);
        this.pauseAction.setEnabled(false);
        this.createAction.setEnabled(false);
        this.editAction.setEnabled(false);
        this.removeAction.setEnabled(false);
    }

    private void hookDoubleClickAction() {
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                RemoteToolsEnvironmentView.this.doubleClickAction.run();
            }
        });
    }

    private void showMessage(String message, TreeViewer viewer) {
        MessageDialog.openInformation((Shell)viewer.getControl().getShell(), (String)"Environments", (String)message);
    }

    private boolean showConfirm(String message, TreeViewer viewer) {
        return MessageDialog.openConfirm((Shell)viewer.getControl().getShell(), (String)"Environments", (String)message);
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    public void selectionChanged(SelectionChangedEvent event) {
        ISelection selection = event.getSelection();
        Object obj = ((IStructuredSelection)selection).getFirstElement();
        if (obj != null) {
            if (TargetElement.class.isAssignableFrom(obj.getClass())) {
                this.currentElement = (ITargetElement)obj;
                switch (this.currentElement.getStatus()) {
                    case 0: {
                        this.targetStarted(this.currentElement);
                        break;
                    }
                    case 1: {
                        this.targetStopped(this.currentElement);
                        break;
                    }
                    case 2: {
                        this.targetResumed(this.currentElement);
                        break;
                    }
                    case 3: {
                        this.targetPaused(this.currentElement);
                    }
                }
            } else {
                this.currentElement = null;
                this.startAction.setEnabled(false);
                this.stopAction.setEnabled(false);
                this.resumeAction.setEnabled(false);
                this.pauseAction.setEnabled(false);
            }
        }
    }

    public void targetStarted(ITargetElement event) {
        if (event != null && this.currentElement != null && event.equals(this.currentElement)) {
            this.startAction.setEnabled(false);
            this.stopAction.setEnabled(true);
            this.resumeAction.setEnabled(true);
            this.pauseAction.setEnabled(false);
            this.editAction.setEnabled(false);
            this.removeAction.setEnabled(false);
        }
        this.refresh();
    }

    public void targetStopped(ITargetElement event) {
        if (event != null && this.currentElement != null && event.equals(this.currentElement)) {
            this.startAction.setEnabled(true);
            this.stopAction.setEnabled(false);
            this.resumeAction.setEnabled(false);
            this.pauseAction.setEnabled(false);
            this.editAction.setEnabled(true);
            this.removeAction.setEnabled(true);
        }
        this.refresh();
    }

    public void targetPaused(ITargetElement event) {
        if (event != null && this.currentElement != null && event.equals(this.currentElement)) {
            this.startAction.setEnabled(false);
            this.stopAction.setEnabled(true);
            this.resumeAction.setEnabled(true);
            this.pauseAction.setEnabled(false);
        }
        this.refresh();
    }

    public void targetResumed(ITargetElement event) {
        if (event != null && this.currentElement != null && event.equals(this.currentElement)) {
            this.startAction.setEnabled(false);
            this.stopAction.setEnabled(true);
            this.resumeAction.setEnabled(false);
            this.pauseAction.setEnabled(true);
        }
        this.refresh();
    }

    public void handleStateChangeEvent(int event, ITargetElement from) {
        switch (event) {
            case 0: {
                this.targetStarted(from);
                break;
            }
            case 1: {
                this.targetStopped(from);
                break;
            }
            case 2: {
                this.targetResumed(from);
                break;
            }
            case 3: {
                this.targetPaused(from);
            }
        }
    }

    public void dispose() {
        super.dispose();
        this.model.removeModelEventListener((ITargetEventListener)this);
    }

    class NameSorter
    extends ViewerSorter {
        NameSorter() {
        }
    }

    class ViewContentProvider
    implements ITreeContentProvider {
        private final Object[] EMPTY = new Object[0];

        ViewContentProvider() {
        }

        public Object[] getChildren(Object arg0) {
            if (arg0 instanceof TargetTypeElement) {
                return ((TargetTypeElement)arg0).getElements().toArray();
            }
            if (arg0 instanceof ITargetElement) {
                return EnvironmentPlugin.getDefault().getChildrenProviderManager().getChildren((ITargetElement)arg0);
            }
            if (arg0 instanceof INode) {
                return ((INode)arg0).getChildren();
            }
            return this.EMPTY;
        }

        public Object getParent(Object arg0) {
            if (arg0 instanceof ITargetElement) {
                return ((ITargetElement)arg0).getType();
            }
            if (arg0 instanceof INode) {
                return ((INode)arg0).getParent();
            }
            return null;
        }

        public boolean hasChildren(Object arg0) {
            return this.getChildren(arg0).length > 0;
        }

        public Object[] getElements(Object arg0) {
            if (arg0 instanceof Object[]) {
                return (Object[])arg0;
            }
            return this.getChildren(arg0);
        }

        public void dispose() {
        }

        public void inputChanged(Viewer arg0, Object arg1, Object arg2) {
        }
    }

    class ViewLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private Image viewIcon;

        ViewLabelProvider() {
        }

        public String getColumnText(Object obj, int index) {
            String result = "";
            block0 : switch (index) {
                case 0: {
                    if (obj instanceof INode) {
                        result = ((INode)obj).getDisplayText();
                        break;
                    }
                    result = obj.toString();
                    break;
                }
                case 1: {
                    if (!TargetElement.class.isAssignableFrom(obj.getClass())) break;
                    int status = ((ITargetElement)obj).getStatus();
                    switch (status) {
                        case 0: {
                            result = "Started";
                            break block0;
                        }
                        case 1: {
                            result = "Stopped";
                            break block0;
                        }
                        case 2: {
                            result = "Running";
                            break block0;
                        }
                        case 3: {
                            result = "Paused";
                        }
                    }
                }
            }
            return result;
        }

        public Image getColumnImage(Object obj, int index) {
            if (index == 0) {
                if (obj instanceof INode) {
                    return ((INode)obj).getIcon();
                }
                return this.getImage(obj);
            }
            return null;
        }

        public Image getImage(Object obj) {
            if (TargetTypeElement.class.isAssignableFrom(obj.getClass())) {
                URL url = UIEnvironmentPlugin.getDefault().getBundle().getEntry("/icons/connect_create.gif");
                ImageDescriptor imageMonitorDescriptor = ImageDescriptor.createFromURL((URL)url);
                this.viewIcon = imageMonitorDescriptor.createImage();
            } else if (TargetElement.class.isAssignableFrom(obj.getClass())) {
                URL url = UIEnvironmentPlugin.getDefault().getBundle().getEntry("/icons/monitor_obj.gif");
                ImageDescriptor imageMonitorDescriptor = ImageDescriptor.createFromURL((URL)url);
                this.viewIcon = imageMonitorDescriptor.createImage();
            }
            return this.viewIcon;
        }

        public void dispose() {
            super.dispose();
            if (this.viewIcon != null) {
                this.viewIcon.dispose();
                this.viewIcon = null;
            }
        }
    }
}

