/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.cell.environment.launcher.cellbe;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ptp.cell.environment.launcher.cellbe.CancelCallback;
import org.eclipse.ptp.cell.environment.launcher.cellbe.LaunchProcessWrapper;
import org.eclipse.ptp.cell.environment.launcher.cellbe.ProgressListener;
import org.eclipse.ptp.cell.environment.launcher.cellbe.internal.Messages;
import org.eclipse.ptp.cell.environment.launcher.cellbe.internal.integration.DebugIntegration;
import org.eclipse.ptp.cell.environment.launcher.cellbe.internal.integration.RunIntegration;
import org.eclipse.ptp.remotetools.environment.EnvironmentPlugin;
import org.eclipse.ptp.remotetools.environment.control.ITargetControl;
import org.eclipse.ptp.remotetools.environment.control.ITargetJob;
import org.eclipse.ptp.remotetools.environment.launcher.RemoteLauncherPlugin;
import org.eclipse.ptp.remotetools.environment.launcher.core.ILaunchIntegration;
import org.eclipse.ptp.remotetools.environment.launcher.core.ILaunchObserver;
import org.eclipse.ptp.remotetools.environment.launcher.core.ILaunchProcess;
import org.eclipse.ptp.remotetools.environment.launcher.core.ILaunchProgressListener;
import org.eclipse.ptp.remotetools.environment.launcher.core.NullLaunchIntegration;
import org.eclipse.ptp.remotetools.environment.launcher.core.RemoteLaunchDelegate;
import org.eclipse.ptp.remotetools.environment.launcher.data.ExecutionConfiguration;

public abstract class AbstractCellRemoteLaunchDelegate
extends RemoteLaunchDelegate {
    public ITargetControl getTargetControl(ILaunchConfiguration configuration) throws CoreException {
        String id = configuration.getAttribute("org.eclipse.ptp.remotetools.environment.launcher.cellbe.CELL_TARGET", null);
        ITargetControl control = null;
        if (id == null || id.length() == 0) {
            return null;
        }
        control = EnvironmentPlugin.getDefault().getTargetsManager().selectControl(id);
        if (control == null) {
            return null;
        }
        return control;
    }

    public ITargetControl getValidatedTargetControl(ILaunchConfiguration configuration) throws CoreException {
        String id = configuration.getAttribute("org.eclipse.ptp.remotetools.environment.launcher.cellbe.CELL_TARGET", null);
        ITargetControl control = null;
        if (id == null || id.length() == 0) {
            this.abort(Messages.CellLaunchDelegate_TargetControl_ErrorNoTargetSelected, null, 0);
        }
        if ((control = EnvironmentPlugin.getDefault().getTargetsManager().selectControl(id)) == null) {
            this.abort(NLS.bind((String)Messages.CellLaunchDelegate_TargetControl_ErrorInexistentTarget, (Object)id), null, 0);
        }
        switch (control.query()) {
            case 2: 
            case 3: {
                break;
            }
            case 0: {
                this.abort(NLS.bind((String)Messages.CellLaunchDelegate_TargetControl_ErrorTargetNotReady, (Object)id), null, 0);
                break;
            }
            case 1: {
                this.abort(NLS.bind((String)Messages.CellLaunchDelegate_TargetControl_ErrorTargetNotStarted, (Object)id), null, 0);
                break;
            }
            default: {
                this.abort(NLS.bind((String)Messages.CellLaunchDelegate_TargetControl_ErrorInvalidState, (Object)id), null, 0);
            }
        }
        return control;
    }

    public String getTargetName(ILaunchConfiguration configuration) throws CoreException {
        return configuration.getAttribute("org.eclipse.ptp.remotetools.environment.launcher.cellbe.CELL_TARGET", null);
    }

    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        ITargetControl targetControl = this.getValidatedTargetControl(configuration);
        ILaunchObserver launchObserver = this.getOutputObserver(configuration);
        NullLaunchIntegration launchIntegration = null;
        launchIntegration = mode.equals("debug") ? new DebugIntegration(configuration, mode, launch, (IProgressMonitor)new NullProgressMonitor()) : (mode.equals("run") ? new RunIntegration() : new NullLaunchIntegration());
        ExecutionConfiguration executionConfig = this.createExecutionConfig(configuration);
        ILaunchProcess launchProcess = RemoteLauncherPlugin.createRemoteLaunchProcess((ILaunch)launch, (ExecutionConfiguration)executionConfig, (ILaunchIntegration)launchIntegration);
        launchProcess.setLaunchObserver(launchObserver);
        LaunchProcessWrapper wrapper = new LaunchProcessWrapper(launchProcess);
        ProgressListener progressListener = new ProgressListener(executionConfig, monitor, new CancelCallback(launchProcess));
        try {
            progressListener.start();
            launchProcess.addProgressListener((ILaunchProgressListener)progressListener);
            targetControl.startJob((ITargetJob)wrapper);
            progressListener.waitForLaunch();
        }
        finally {
            launchProcess.removeProgressListener((ILaunchProgressListener)progressListener);
            progressListener.interrupt();
            monitor.done();
        }
    }

    public ExecutionConfiguration createExecutionConfig(ILaunchConfiguration configuration) throws CoreException {
        ExecutionConfiguration executionConfig = new ExecutionConfiguration();
        executionConfig.setProject(AbstractCellRemoteLaunchDelegate.getCProject((ILaunchConfiguration)configuration));
        executionConfig.setExecutable(this.verifyProgramPath(configuration).toFile());
        executionConfig.setBeforeCommand(this.getBeforeCommand(configuration));
        executionConfig.setAfterCommand(this.getAfterCommand(configuration));
        executionConfig.addArguments(this.getProgramArgumentsArray(configuration));
        executionConfig.setRemoteDirectory(this.getValidatedRemoteDirectory(configuration));
        executionConfig.setWorkingDirectory(this.getWorkingDirectory(configuration));
        executionConfig.setDoSynchronizeAfter(this.getSynchronizeAfter(configuration));
        executionConfig.setDoSynchronizeBefore(this.getSynchronizeBefore(configuration));
        executionConfig.setDoCleanup(this.getSynchronizeCleanup(configuration));
        executionConfig.addEnvironmentVariables(this.getEnvironment(configuration));
        executionConfig.setDoForwardX11(this.getUseForwardedX11(configuration));
        executionConfig.setLabel(NLS.bind((String)Messages.CellLaunchDelegate_LaunchLabel, (Object[])new Object[]{AbstractCellRemoteLaunchDelegate.getProgramName((ILaunchConfiguration)configuration), this.getTargetName(configuration)}));
        executionConfig.setDoAllocateTerminal(AbstractCellRemoteLaunchDelegate.getAllocateTerminal((ILaunchConfiguration)configuration));
        executionConfig.addSynchronizationRules(this.getSynchronizeRules(configuration));
        executionConfig.validate();
        return executionConfig;
    }
}

