/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.pldt.mpi.analysis.actions;

import org.eclipse.ptp.pldt.mpi.analysis.analysis.BarrierTable;
import org.eclipse.ptp.pldt.mpi.analysis.analysis.MPIBarrierAnalysisResults;
import org.eclipse.ptp.pldt.mpi.analysis.analysis.MPIBarrierExpr;
import org.eclipse.ptp.pldt.mpi.analysis.analysis.MPIBarrierMatching;
import org.eclipse.ptp.pldt.mpi.analysis.analysis.MPICFGBuilder;
import org.eclipse.ptp.pldt.mpi.analysis.analysis.MPICallGraph;
import org.eclipse.ptp.pldt.mpi.analysis.analysis.MPIDUChain;
import org.eclipse.ptp.pldt.mpi.analysis.analysis.MPIMVAnalysis;
import org.eclipse.ptp.pldt.mpi.analysis.cdt.graphs.ICallGraph;
import org.eclipse.ptp.pldt.mpi.analysis.view.BarrierArtifacts;
import org.eclipse.ptp.pldt.mpi.analysis.view.MPIArtifactMarkingVisitor;
import org.eclipse.ptp.pldt.mpi.analysis.view.MatchingSet;
import org.eclipse.ptp.pldt.mpi.analysis.view.ShowErrors;

public class MPIAnalysisManager {
    protected BarrierTable btable_;
    protected MPICallGraph cg_;
    private static final boolean traceOn = false;

    public MPIAnalysisManager(MPICallGraph cg) {
        this.cg_ = cg;
    }

    public boolean run() {
        this.cg_.buildCG();
        this.btable_ = this.cg_.getBarrierTable();
        MPIBarrierExpr BE = new MPIBarrierExpr(this.btable_, (ICallGraph)this.cg_);
        BE.run();
        MPICFGBuilder cfg = new MPICFGBuilder((ICallGraph)this.cg_);
        cfg.run();
        MPIDUChain rd = new MPIDUChain((ICallGraph)this.cg_);
        rd.run();
        MPIMVAnalysis mva = new MPIMVAnalysis((ICallGraph)this.cg_);
        mva.run();
        MPIBarrierMatching bm = new MPIBarrierMatching((ICallGraph)this.cg_, this.btable_);
        bm.run();
        MPIBarrierAnalysisResults results = new MPIBarrierAnalysisResults();
        results.setBarrierTable(this.btable_);
        String markerID = "org.eclipse.ptp.pldt.mpi.analysis.mpiBarrierMarker";
        MPIArtifactMarkingVisitor visitor = new MPIArtifactMarkingVisitor(markerID);
        BarrierArtifacts ba = new BarrierArtifacts((ICallGraph)this.cg_, visitor);
        ba.run();
        MatchingSet msv = new MatchingSet(this.btable_);
        msv.run();
        ShowErrors se = new ShowErrors(bm.getErrors());
        boolean foundError = se.run();
        return foundError;
    }
}

