/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rm.remote.core;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.ptp.rmsystem.AbstractResourceManagerConfiguration;
import org.eclipse.ptp.rmsystem.IResourceManagerFactory;
import org.eclipse.ui.IMemento;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractRemoteResourceManagerConfiguration
extends AbstractResourceManagerConfiguration {
    private static final String EMPTY_STRING = "";
    private static final String TAG_PROXY_PATH = "proxyPath";
    private static final String TAG_OPTIONS = "options";
    private static final String TAG_CONNECTION_NAME = "connectionName";
    private static final String TAG_REMOTE_SERVICES_ID = "remoteServicesID";
    private static final String TAG_INVOCATION_OPTIONS = "invocationOptions";
    private static final String TAG_LOCAL_ADDRESS = "localAddress";
    private String remoteServicesId;
    private String connectionName;
    private String proxyServerPath;
    private String localAddress;
    private List<String> invocationOptions;
    private int options;

    public static RemoteConfig loadRemote(IResourceManagerFactory factory, IMemento memento) {
        AbstractResourceManagerConfiguration.CommonConfig commonConfig = AbstractRemoteResourceManagerConfiguration.loadCommon((IResourceManagerFactory)factory, (IMemento)memento);
        String remoteServicesId = memento.getString(TAG_REMOTE_SERVICES_ID);
        String connectionName = memento.getString(TAG_CONNECTION_NAME);
        String proxyServerPath = memento.getString(TAG_PROXY_PATH);
        String localAddress = memento.getString(TAG_LOCAL_ADDRESS);
        int options = Integer.parseInt(memento.getString(TAG_OPTIONS));
        String invocationOptions = memento.getString(TAG_INVOCATION_OPTIONS);
        RemoteConfig config = new RemoteConfig(commonConfig, remoteServicesId, connectionName, proxyServerPath, localAddress, invocationOptions, options);
        return config;
    }

    public AbstractRemoteResourceManagerConfiguration(RemoteConfig remoteConfig, IResourceManagerFactory factory) {
        super(remoteConfig.getCommonConfig(), factory);
        this.remoteServicesId = remoteConfig.getRemoteServicesId();
        this.connectionName = remoteConfig.getConnectionName();
        this.proxyServerPath = remoteConfig.getProxyPath();
        this.localAddress = remoteConfig.getLocalAddress();
        this.options = remoteConfig.getOptions();
        this.invocationOptions = new ArrayList<String>();
        this.setInvocationOptions(remoteConfig.getInvocationOptions());
    }

    public void addInvocationOptions(String optionString) {
        if (!optionString.equals(EMPTY_STRING)) {
            String[] options;
            String[] stringArray = options = optionString.split(" ");
            int n = options.length;
            int n2 = 0;
            while (n2 < n) {
                String option = stringArray[n2];
                this.invocationOptions.add(option);
                ++n2;
            }
        }
    }

    public String getConnectionName() {
        return this.connectionName;
    }

    public List<String> getInvocationOptions() {
        return this.invocationOptions;
    }

    public String getInvocationOptionsStr() {
        String opts = EMPTY_STRING;
        int i = 0;
        while (i < this.invocationOptions.size()) {
            if (i > 0) {
                opts = String.valueOf(opts) + " ";
            }
            opts = String.valueOf(opts) + this.invocationOptions.get(i);
            ++i;
        }
        return opts;
    }

    public String getLocalAddress() {
        return this.localAddress;
    }

    public int getOptions() {
        return this.options;
    }

    public String getProxyServerPath() {
        return this.proxyServerPath;
    }

    public String getRemoteServicesId() {
        return this.remoteServicesId;
    }

    public void save(IMemento memento) {
        super.save(memento);
        memento.putString(TAG_REMOTE_SERVICES_ID, this.remoteServicesId);
        memento.putString(TAG_CONNECTION_NAME, this.connectionName);
        memento.putString(TAG_PROXY_PATH, this.proxyServerPath);
        memento.putString(TAG_LOCAL_ADDRESS, this.localAddress);
        memento.putString(TAG_OPTIONS, Integer.toString(this.options));
        memento.putString(TAG_INVOCATION_OPTIONS, this.getInvocationOptionsStr());
    }

    public void setConnectionName(String connectionName) {
        this.connectionName = connectionName;
    }

    public void setInvocationOptions(String optionString) {
        this.invocationOptions.clear();
        this.addInvocationOptions(optionString);
    }

    public void setLocalAddress(String localAddr) {
        this.localAddress = localAddr;
    }

    public void setOptions(int options) {
        this.options = options;
    }

    public void setProxyServerPath(String proxyServerPath) {
        this.proxyServerPath = proxyServerPath;
    }

    public void setRemoteServicesId(String id) {
        this.remoteServicesId = id;
    }

    public boolean testOption(int option) {
        return (this.getOptions() & option) == option;
    }

    public static class RemoteConfig {
        private final AbstractResourceManagerConfiguration.CommonConfig commonConfig;
        private final String remoteServicesId;
        private final String connectionName;
        private final String proxyPath;
        private final String localAddress;
        private final String invocationOptions;
        private final int options;

        public RemoteConfig() {
            this(new AbstractResourceManagerConfiguration.CommonConfig(), null, null, AbstractRemoteResourceManagerConfiguration.EMPTY_STRING, AbstractRemoteResourceManagerConfiguration.EMPTY_STRING, AbstractRemoteResourceManagerConfiguration.EMPTY_STRING, 0);
        }

        public RemoteConfig(AbstractResourceManagerConfiguration.CommonConfig config, String remoteId, String conn, String path, String localAddr, String invocationOptions, int options) {
            this.commonConfig = config;
            this.remoteServicesId = remoteId;
            this.connectionName = conn;
            this.proxyPath = path;
            this.localAddress = localAddr;
            this.invocationOptions = invocationOptions;
            this.options = options;
        }

        public AbstractResourceManagerConfiguration.CommonConfig getCommonConfig() {
            return this.commonConfig;
        }

        public String getConnectionName() {
            return this.connectionName;
        }

        public String getInvocationOptions() {
            return this.invocationOptions;
        }

        public String getLocalAddress() {
            return this.localAddress;
        }

        public int getOptions() {
            return this.options;
        }

        public String getProxyPath() {
            return this.proxyPath;
        }

        public String getRemoteServicesId() {
            return this.remoteServicesId;
        }
    }
}

