/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.cell.debug.cdi.ui.pages;

import java.util.Observer;
import org.eclipse.cdt.debug.mi.core.IGDBServerMILaunchConfigurationConstants;
import org.eclipse.cdt.debug.mi.internal.ui.MIUIMessages;
import org.eclipse.cdt.debug.mi.internal.ui.PixelConverter;
import org.eclipse.cdt.debug.mi.internal.ui.SerialPortSettingsBlock;
import org.eclipse.cdt.debug.mi.internal.ui.StandardGDBDebuggerPage;
import org.eclipse.cdt.debug.mi.internal.ui.dialogfields.ComboDialogField;
import org.eclipse.cdt.debug.mi.internal.ui.dialogfields.DialogField;
import org.eclipse.cdt.debug.mi.internal.ui.dialogfields.IDialogFieldListener;
import org.eclipse.cdt.debug.mi.internal.ui.dialogfields.LayoutUtil;
import org.eclipse.cdt.utils.ui.controls.ControlFactory;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.ptp.cell.debug.cdi.ui.pages.AdvancedTCPSettingsBlock;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;

public class StandardCellGDBServerDebuggerPage
extends StandardGDBDebuggerPage {
    private static final String CONNECTION_TCP = MIUIMessages.getString((String)"GDBServerDebuggerPage.0");
    private static final String CONNECTION_SERIAL = MIUIMessages.getString((String)"GDBServerDebuggerPage.1");
    private ComboDialogField fConnectionField;
    private String[] fConnections = new String[]{CONNECTION_TCP, CONNECTION_SERIAL};
    private AdvancedTCPSettingsBlock fTCPBlock;
    private SerialPortSettingsBlock fSerialBlock;
    private Composite fConnectionStack;
    private boolean fIsInitializing = false;

    public StandardCellGDBServerDebuggerPage() {
        this.fConnectionField = this.createConnectionField();
        this.fTCPBlock = new AdvancedTCPSettingsBlock();
        this.fSerialBlock = new SerialPortSettingsBlock();
        this.fTCPBlock.addObserver((Observer)((Object)this));
        this.fSerialBlock.addObserver((Observer)((Object)this));
    }

    protected void createConnectionTab(TabFolder tabFolder) {
        TabItem tabItem = new TabItem(tabFolder, 0);
        tabItem.setText(MIUIMessages.getString((String)"GDBServerDebuggerPage.10"));
        Composite comp1 = ControlFactory.createCompositeEx((Composite)tabFolder, (int)1, (int)1808);
        ((GridLayout)comp1.getLayout()).makeColumnsEqualWidth = false;
        comp1.setFont(tabFolder.getFont());
        tabItem.setControl((Control)comp1);
        Composite comp = ControlFactory.createCompositeEx((Composite)comp1, (int)2, (int)1808);
        ((GridLayout)comp.getLayout()).makeColumnsEqualWidth = false;
        comp.setFont(comp1.getFont());
        this.fConnectionField.doFillIntoGrid(comp, 2);
        ((GridData)this.fConnectionField.getComboControl(null).getLayoutData()).horizontalAlignment = 1;
        PixelConverter converter = new PixelConverter((Control)comp);
        LayoutUtil.setWidthHint((Control)this.fConnectionField.getComboControl(null), (int)converter.convertWidthInCharsToPixels(15));
        this.fConnectionStack = ControlFactory.createCompositeEx((Composite)comp, (int)1, (int)1808);
        StackLayout stackLayout = new StackLayout();
        this.fConnectionStack.setLayout((Layout)stackLayout);
        ((GridData)this.fConnectionStack.getLayoutData()).horizontalSpan = 2;
        this.fTCPBlock.createBlock(this.fConnectionStack);
        this.fSerialBlock.createBlock(this.fConnectionStack);
    }

    private ComboDialogField createConnectionField() {
        ComboDialogField field = new ComboDialogField(12);
        field.setLabelText(MIUIMessages.getString((String)"GDBServerDebuggerPage.9"));
        field.setItems(this.fConnections);
        field.setDialogFieldListener(new IDialogFieldListener(){

            public void dialogFieldChanged(DialogField f) {
                if (!StandardCellGDBServerDebuggerPage.this.isInitializing()) {
                    StandardCellGDBServerDebuggerPage.this.connectionTypeChanged();
                }
            }
        });
        return field;
    }

    protected void connectionTypeChanged() {
        this.connectionTypeChanged0();
        this.updateLaunchConfigurationDialog();
    }

    private void connectionTypeChanged0() {
        ((StackLayout)this.fConnectionStack.getLayout()).topControl = null;
        int index = this.fConnectionField.getSelectionIndex();
        if (index >= 0 && index < this.fConnections.length) {
            String[] connTypes = this.fConnectionField.getItems();
            if (CONNECTION_TCP.equals(connTypes[index])) {
                ((StackLayout)this.fConnectionStack.getLayout()).topControl = this.fTCPBlock.getControl();
            } else if (CONNECTION_SERIAL.equals(connTypes[index])) {
                ((StackLayout)this.fConnectionStack.getLayout()).topControl = this.fSerialBlock.getControl();
            }
        }
        this.fConnectionStack.layout();
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        if (super.isValid(launchConfig)) {
            this.setErrorMessage(null);
            this.setMessage(null);
            int index = this.fConnectionField.getSelectionIndex();
            if (index >= 0 && index < this.fConnections.length) {
                String[] connTypes = this.fConnectionField.getItems();
                if (CONNECTION_TCP.equals(connTypes[index])) {
                    if (!this.fTCPBlock.isValid(launchConfig)) {
                        this.setErrorMessage(this.fTCPBlock.getErrorMessage());
                        return false;
                    }
                } else if (CONNECTION_SERIAL.equals(connTypes[index]) && !this.fSerialBlock.isValid(launchConfig)) {
                    this.setErrorMessage(this.fSerialBlock.getErrorMessage());
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        this.setInitializing(true);
        super.initializeFrom(configuration);
        boolean isTcp = true;
        try {
            isTcp = configuration.getAttribute(IGDBServerMILaunchConfigurationConstants.ATTR_REMOTE_TCP, true);
        }
        catch (CoreException coreException) {}
        this.fTCPBlock.initializeFrom(configuration);
        this.fSerialBlock.initializeFrom(configuration);
        this.fConnectionField.selectItem(isTcp ? 0 : 1);
        this.connectionTypeChanged0();
        this.setInitializing(false);
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        super.performApply(configuration);
        if (this.fConnectionField != null) {
            configuration.setAttribute(IGDBServerMILaunchConfigurationConstants.ATTR_REMOTE_TCP, this.fConnectionField.getSelectionIndex() == 0);
        }
        this.fTCPBlock.performApply(configuration);
        this.fSerialBlock.performApply(configuration);
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        super.setDefaults(configuration);
        configuration.setAttribute(IGDBServerMILaunchConfigurationConstants.ATTR_REMOTE_TCP, true);
        this.fTCPBlock.setDefaults(configuration);
        this.fSerialBlock.setDefaults(configuration);
    }

    protected boolean isInitializing() {
        return this.fIsInitializing;
    }

    private void setInitializing(boolean isInitializing) {
        this.fIsInitializing = isInitializing;
    }

    public void createTabs(TabFolder tabFolder) {
        super.createTabs(tabFolder);
        this.createConnectionTab(tabFolder);
    }
}

