/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.proxy.client;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.SocketTimeoutException;
import java.nio.channels.Channels;
import java.nio.channels.ClosedByInterruptException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.nio.channels.WritableByteChannel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.ptp.internal.proxy.command.ProxyQuitCommand;
import org.eclipse.ptp.internal.proxy.event.ProxyConnectedEvent;
import org.eclipse.ptp.internal.proxy.event.ProxyDisconnectedEvent;
import org.eclipse.ptp.internal.proxy.event.ProxyMessageEvent;
import org.eclipse.ptp.internal.proxy.event.ProxyTimeoutEvent;
import org.eclipse.ptp.proxy.client.IProxyClient;
import org.eclipse.ptp.proxy.command.IProxyCommand;
import org.eclipse.ptp.proxy.event.IProxyConnectedEvent;
import org.eclipse.ptp.proxy.event.IProxyDisconnectedEvent;
import org.eclipse.ptp.proxy.event.IProxyErrorEvent;
import org.eclipse.ptp.proxy.event.IProxyEvent;
import org.eclipse.ptp.proxy.event.IProxyEventFactory;
import org.eclipse.ptp.proxy.event.IProxyEventListener;
import org.eclipse.ptp.proxy.event.IProxyExtendedEvent;
import org.eclipse.ptp.proxy.event.IProxyMessageEvent;
import org.eclipse.ptp.proxy.event.IProxyOKEvent;
import org.eclipse.ptp.proxy.event.IProxyShutdownEvent;
import org.eclipse.ptp.proxy.event.IProxyTimeoutEvent;
import org.eclipse.ptp.proxy.packet.ProxyPacket;
import org.eclipse.ptp.proxy.util.DebugOptions;

public abstract class AbstractProxyClient
implements IProxyClient {
    private int transactionID = 1;
    private int sessPort = 0;
    private ServerSocketChannel sessSvrSock = null;
    private SocketChannel sessSock = null;
    private IProxyEventFactory proxyEventFactory;
    private ReadableByteChannel sessInput;
    private WritableByteChannel sessOutput;
    private Thread eventThread;
    private Thread acceptThread;
    private DebugOptions debugOptions;
    private SessionState state;
    private List<IProxyEventListener> listeners = Collections.synchronizedList(new ArrayList());

    public AbstractProxyClient() {
        this.debugOptions = new DebugOptions();
        this.state = SessionState.SHUTDOWN;
    }

    public void addProxyEventListener(IProxyEventListener listener) {
        this.listeners.add(listener);
    }

    public int getSessionPort() {
        return this.sessPort;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isReady() {
        SessionState sessionState = this.state;
        synchronized (sessionState) {
            return this.state == SessionState.RUNNING;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isShutdown() {
        SessionState sessionState = this.state;
        synchronized (sessionState) {
            return this.state == SessionState.SHUTDOWN;
        }
    }

    public synchronized int newTransactionID() {
        return ++this.transactionID;
    }

    public void removeProxyEventListener(IProxyEventListener listener) {
        this.listeners.remove(listener);
    }

    public void sendCommand(IProxyCommand cmd) throws IOException {
        if (!this.isReady()) {
            throw new IOException("channel is not ready to send");
        }
        ProxyPacket packet = new ProxyPacket(cmd);
        packet.send(this.sessOutput);
    }

    public int sessionConnect() {
        return 0;
    }

    public void sessionCreate() throws IOException {
        this.sessionCreate(0);
    }

    public void sessionCreate(int timeout) throws IOException {
        this.sessionCreate(0, timeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sessionCreate(int port, int timeout) throws IOException {
        if (DebugOptions.CLIENT_TRACING) {
            System.out.println("sessionCreate(" + port + "," + timeout + ")");
        }
        this.sessSvrSock = ServerSocketChannel.open();
        InetSocketAddress isa = new InetSocketAddress(port);
        if (DebugOptions.CLIENT_TRACING) {
            System.out.println("bind(" + isa.toString() + ")");
        }
        this.sessSvrSock.socket().bind(isa);
        if (timeout > 0) {
            this.sessSvrSock.socket().setSoTimeout(timeout);
        }
        this.sessPort = this.sessSvrSock.socket().getLocalPort();
        SessionState sessionState = this.state;
        synchronized (sessionState) {
            this.state = SessionState.WAITING;
        }
        if (DebugOptions.CLIENT_TRACING) {
            System.out.println("port=" + this.sessPort);
        }
        this.acceptThread = new Thread("Proxy Client Accept Thread"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Loose catch block
             */
            public void run() {
                block55: {
                    boolean error;
                    block59: {
                        error = false;
                        try {
                            if (DebugOptions.CLIENT_TRACING) {
                                System.out.println("accept thread starting...");
                            }
                            AbstractProxyClient.this.sessSock = AbstractProxyClient.this.sessSvrSock.accept();
                            AbstractProxyClient.this.sessInput = AbstractProxyClient.this.sessSock;
                            AbstractProxyClient.this.sessOutput = AbstractProxyClient.this.sessSock;
                        }
                        catch (SocketTimeoutException socketTimeoutException) {
                            block54: {
                                error = true;
                                AbstractProxyClient.this.fireProxyTimeoutEvent(new ProxyTimeoutEvent());
                                try {
                                    AbstractProxyClient.this.sessSvrSock.close();
                                }
                                catch (IOException iOException) {
                                    if (!DebugOptions.CLIENT_TRACING) break block54;
                                    System.out.println("IO Exception trying to close server socket (non fatal)");
                                }
                            }
                            SessionState sessionState = AbstractProxyClient.this.state;
                            synchronized (sessionState) {
                                if (this.isInterrupted()) {
                                    error = true;
                                    AbstractProxyClient.this.fireProxyMessageEvent(new ProxyMessageEvent(IProxyMessageEvent.Level.WARNING, "Connection cancelled by user"));
                                }
                                if (!error && AbstractProxyClient.this.state == SessionState.WAITING) {
                                    AbstractProxyClient.this.state = SessionState.CONNECTED;
                                    AbstractProxyClient.this.fireProxyConnectedEvent(new ProxyConnectedEvent());
                                } else {
                                    AbstractProxyClient.this.state = SessionState.SHUTDOWN;
                                }
                            }
                            if (DebugOptions.CLIENT_TRACING) {
                                System.out.println("accept thread exiting...");
                            }
                            break block55;
                        }
                        catch (ClosedByInterruptException closedByInterruptException) {
                            block56: {
                                error = true;
                                AbstractProxyClient.this.fireProxyMessageEvent(new ProxyMessageEvent(IProxyMessageEvent.Level.WARNING, "Accept cancelled by user"));
                                try {
                                    AbstractProxyClient.this.sessSvrSock.close();
                                }
                                catch (IOException iOException) {
                                    if (!DebugOptions.CLIENT_TRACING) break block56;
                                    System.out.println("IO Exception trying to close server socket (non fatal)");
                                }
                            }
                            SessionState sessionState = AbstractProxyClient.this.state;
                            synchronized (sessionState) {
                                if (this.isInterrupted()) {
                                    error = true;
                                    AbstractProxyClient.this.fireProxyMessageEvent(new ProxyMessageEvent(IProxyMessageEvent.Level.WARNING, "Connection cancelled by user"));
                                }
                                if (!error && AbstractProxyClient.this.state == SessionState.WAITING) {
                                    AbstractProxyClient.this.state = SessionState.CONNECTED;
                                    AbstractProxyClient.this.fireProxyConnectedEvent(new ProxyConnectedEvent());
                                } else {
                                    AbstractProxyClient.this.state = SessionState.SHUTDOWN;
                                }
                            }
                            if (DebugOptions.CLIENT_TRACING) {
                                System.out.println("accept thread exiting...");
                            }
                            break block55;
                        }
                        catch (IOException iOException) {
                            block57: {
                                error = true;
                                AbstractProxyClient.this.fireProxyMessageEvent(new ProxyMessageEvent(IProxyMessageEvent.Level.FATAL, "IOException in accept"));
                                {
                                    catch (Throwable throwable) {
                                        block58: {
                                            try {
                                                AbstractProxyClient.this.sessSvrSock.close();
                                            }
                                            catch (IOException iOException2) {
                                                if (!DebugOptions.CLIENT_TRACING) break block58;
                                                System.out.println("IO Exception trying to close server socket (non fatal)");
                                            }
                                        }
                                        SessionState sessionState = AbstractProxyClient.this.state;
                                        synchronized (sessionState) {
                                            if (this.isInterrupted()) {
                                                error = true;
                                                AbstractProxyClient.this.fireProxyMessageEvent(new ProxyMessageEvent(IProxyMessageEvent.Level.WARNING, "Connection cancelled by user"));
                                            }
                                            if (!error && AbstractProxyClient.this.state == SessionState.WAITING) {
                                                AbstractProxyClient.this.state = SessionState.CONNECTED;
                                                AbstractProxyClient.this.fireProxyConnectedEvent(new ProxyConnectedEvent());
                                            } else {
                                                AbstractProxyClient.this.state = SessionState.SHUTDOWN;
                                            }
                                        }
                                        if (DebugOptions.CLIENT_TRACING) {
                                            System.out.println("accept thread exiting...");
                                        }
                                        throw throwable;
                                    }
                                }
                                try {
                                    AbstractProxyClient.this.sessSvrSock.close();
                                }
                                catch (IOException iOException3) {
                                    if (!DebugOptions.CLIENT_TRACING) break block57;
                                    System.out.println("IO Exception trying to close server socket (non fatal)");
                                }
                            }
                            SessionState sessionState = AbstractProxyClient.this.state;
                            synchronized (sessionState) {
                                if (this.isInterrupted()) {
                                    error = true;
                                    AbstractProxyClient.this.fireProxyMessageEvent(new ProxyMessageEvent(IProxyMessageEvent.Level.WARNING, "Connection cancelled by user"));
                                }
                                if (!error && AbstractProxyClient.this.state == SessionState.WAITING) {
                                    AbstractProxyClient.this.state = SessionState.CONNECTED;
                                    AbstractProxyClient.this.fireProxyConnectedEvent(new ProxyConnectedEvent());
                                } else {
                                    AbstractProxyClient.this.state = SessionState.SHUTDOWN;
                                }
                            }
                            if (DebugOptions.CLIENT_TRACING) {
                                System.out.println("accept thread exiting...");
                            }
                            break block55;
                        }
                        try {
                            AbstractProxyClient.this.sessSvrSock.close();
                        }
                        catch (IOException iOException) {
                            if (!DebugOptions.CLIENT_TRACING) break block59;
                            System.out.println("IO Exception trying to close server socket (non fatal)");
                        }
                    }
                    SessionState sessionState = AbstractProxyClient.this.state;
                    synchronized (sessionState) {
                        if (this.isInterrupted()) {
                            error = true;
                            AbstractProxyClient.this.fireProxyMessageEvent(new ProxyMessageEvent(IProxyMessageEvent.Level.WARNING, "Connection cancelled by user"));
                        }
                        if (!error && AbstractProxyClient.this.state == SessionState.WAITING) {
                            AbstractProxyClient.this.state = SessionState.CONNECTED;
                            AbstractProxyClient.this.fireProxyConnectedEvent(new ProxyConnectedEvent());
                        } else {
                            AbstractProxyClient.this.state = SessionState.SHUTDOWN;
                        }
                    }
                    if (DebugOptions.CLIENT_TRACING) {
                        System.out.println("accept thread exiting...");
                    }
                }
            }
        };
        this.acceptThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sessionCreate(OutputStream output, InputStream input) {
        if (DebugOptions.CLIENT_TRACING) {
            System.out.println("sessionCreate(stdin, stdout)");
        }
        this.sessInput = Channels.newChannel(input);
        this.sessOutput = Channels.newChannel(output);
        SessionState sessionState = this.state;
        synchronized (sessionState) {
            this.state = SessionState.CONNECTED;
        }
        this.fireProxyConnectedEvent(new ProxyConnectedEvent());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sessionFinish() throws IOException {
        SessionState sessionState = this.state;
        synchronized (sessionState) {
            switch (this.state) {
                case WAITING: {
                    if (this.acceptThread.isAlive()) {
                        this.acceptThread.interrupt();
                    }
                    this.state = SessionState.SHUTTING_DOWN;
                    break;
                }
                case CONNECTED: {
                    try {
                        this.sessSock.close();
                        this.state = SessionState.SHUTTING_DOWN;
                    }
                    catch (IOException iOException) {
                        this.state = SessionState.SHUTDOWN;
                    }
                    break;
                }
                case RUNNING: {
                    ProxyQuitCommand cmd = new ProxyQuitCommand();
                    try {
                        this.sendCommand(cmd);
                        this.state = SessionState.SHUTTING_DOWN;
                        break;
                    }
                    catch (IOException iOException) {
                        this.state = SessionState.SHUTDOWN;
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sessionHandleEvents() throws IOException {
        this.eventThread = new Thread("Proxy Client Event Thread"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                SessionState sessionState;
                boolean error = false;
                int errorCount = 0;
                if (DebugOptions.CLIENT_TRACING) {
                    System.out.println("event thread starting...");
                }
                try {
                    while (errorCount < 5 && !this.isInterrupted()) {
                        sessionState = AbstractProxyClient.this.state;
                        synchronized (sessionState) {
                            if (AbstractProxyClient.this.state == SessionState.SHUTDOWN) {
                                break;
                            }
                        }
                        if (AbstractProxyClient.this.sessionProgress()) continue;
                        ++errorCount;
                    }
                }
                catch (IOException e) {
                    SessionState sessionState2 = AbstractProxyClient.this.state;
                    synchronized (sessionState2) {
                        if (!this.isInterrupted() && AbstractProxyClient.this.state != SessionState.SHUTTING_DOWN) {
                            error = true;
                            if (DebugOptions.CLIENT_TRACING) {
                                System.out.println("event thread IOException . . . " + e.getMessage());
                            }
                        }
                    }
                }
                if (errorCount >= 5) {
                    error = true;
                }
                try {
                    AbstractProxyClient.this.sessSock.close();
                }
                catch (IOException iOException) {}
                sessionState = AbstractProxyClient.this.state;
                synchronized (sessionState) {
                    AbstractProxyClient.this.state = SessionState.SHUTDOWN;
                }
                AbstractProxyClient.this.fireProxyDisconnectedEvent(new ProxyDisconnectedEvent(error));
                if (DebugOptions.CLIENT_TRACING) {
                    System.out.println("event thread exited");
                }
            }
        };
        SessionState sessionState = this.state;
        synchronized (sessionState) {
            if (this.state != SessionState.CONNECTED) {
                throw new IOException("Not ready to receive events");
            }
            this.state = SessionState.RUNNING;
        }
        this.eventThread.start();
    }

    public void setEventFactory(IProxyEventFactory factory) {
        this.proxyEventFactory = factory;
    }

    private boolean sessionProgress() throws IOException {
        ProxyPacket packet = new ProxyPacket();
        if (DebugOptions.PROTOCOL_TRACING) {
            packet.setDebug(true);
        }
        if (!packet.read(this.sessInput)) {
            return false;
        }
        IProxyEvent e = this.proxyEventFactory.toEvent(packet);
        if (e != null) {
            if (e instanceof IProxyMessageEvent) {
                this.fireProxyMessageEvent((IProxyMessageEvent)e);
            } else if (e instanceof IProxyOKEvent) {
                this.fireProxyOKEvent((IProxyOKEvent)e);
            } else if (e instanceof IProxyErrorEvent) {
                this.fireProxyErrorEvent((IProxyErrorEvent)e);
            } else if (e instanceof IProxyShutdownEvent) {
                if (this.state == SessionState.SHUTTING_DOWN) {
                    this.state = SessionState.SHUTDOWN;
                }
            } else if (e instanceof IProxyExtendedEvent) {
                this.fireProxyExtendedEvent((IProxyExtendedEvent)e);
            }
            return true;
        }
        return false;
    }

    protected void fireProxyConnectedEvent(IProxyConnectedEvent event) {
        IProxyEventListener[] la;
        IProxyEventListener[] iProxyEventListenerArray = la = this.listeners.toArray(new IProxyEventListener[0]);
        int n = la.length;
        int n2 = 0;
        while (n2 < n) {
            IProxyEventListener listener = iProxyEventListenerArray[n2];
            listener.handleEvent(event);
            ++n2;
        }
    }

    protected void fireProxyDisconnectedEvent(IProxyDisconnectedEvent event) {
        IProxyEventListener[] la;
        IProxyEventListener[] iProxyEventListenerArray = la = this.listeners.toArray(new IProxyEventListener[0]);
        int n = la.length;
        int n2 = 0;
        while (n2 < n) {
            IProxyEventListener listener = iProxyEventListenerArray[n2];
            listener.handleEvent(event);
            ++n2;
        }
    }

    protected void fireProxyErrorEvent(IProxyErrorEvent event) {
        IProxyEventListener[] la;
        IProxyEventListener[] iProxyEventListenerArray = la = this.listeners.toArray(new IProxyEventListener[0]);
        int n = la.length;
        int n2 = 0;
        while (n2 < n) {
            IProxyEventListener listener = iProxyEventListenerArray[n2];
            listener.handleEvent(event);
            ++n2;
        }
    }

    protected void fireProxyExtendedEvent(IProxyExtendedEvent event) {
        IProxyEventListener[] la;
        IProxyEventListener[] iProxyEventListenerArray = la = this.listeners.toArray(new IProxyEventListener[0]);
        int n = la.length;
        int n2 = 0;
        while (n2 < n) {
            IProxyEventListener listener = iProxyEventListenerArray[n2];
            listener.handleEvent(event);
            ++n2;
        }
    }

    protected void fireProxyMessageEvent(IProxyMessageEvent event) {
        IProxyEventListener[] la;
        IProxyEventListener[] iProxyEventListenerArray = la = this.listeners.toArray(new IProxyEventListener[0]);
        int n = la.length;
        int n2 = 0;
        while (n2 < n) {
            IProxyEventListener listener = iProxyEventListenerArray[n2];
            listener.handleEvent(event);
            ++n2;
        }
    }

    protected void fireProxyOKEvent(IProxyOKEvent event) {
        IProxyEventListener[] la;
        IProxyEventListener[] iProxyEventListenerArray = la = this.listeners.toArray(new IProxyEventListener[0]);
        int n = la.length;
        int n2 = 0;
        while (n2 < n) {
            IProxyEventListener listener = iProxyEventListenerArray[n2];
            listener.handleEvent(event);
            ++n2;
        }
    }

    protected void fireProxyTimeoutEvent(IProxyTimeoutEvent event) {
        IProxyEventListener[] la;
        IProxyEventListener[] iProxyEventListenerArray = la = this.listeners.toArray(new IProxyEventListener[0]);
        int n = la.length;
        int n2 = 0;
        while (n2 < n) {
            IProxyEventListener listener = iProxyEventListenerArray[n2];
            listener.handleEvent(event);
            ++n2;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum SessionState {
        WAITING,
        CONNECTED,
        RUNNING,
        SHUTTING_DOWN,
        SHUTDOWN;

    }
}

