/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.cell.utils.linux.findutils;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import org.eclipse.cdt.utils.spawner.ProcessFactory;
import org.eclipse.ptp.cell.utils.debug.Debug;
import org.eclipse.ptp.cell.utils.linux.findutils.Messages;
import org.eclipse.ptp.cell.utils.process.ProcessController;

public class Find {
    protected static final String PROCESS_NAME = "find";
    protected static final String FIND = "find";
    protected static final String FIND_NAME_FLAG = "-name";
    protected static final String FIND_WHOLENAME_FLAG = "-wholename";
    protected static final long TIMEOUT = Long.MAX_VALUE;
    protected static final String WHITESPACE = " ";
    public static final String EMPTY_PATH = "";

    public static String findFile(String startSearchDirectory, String fileName) {
        Debug.read();
        Debug.POLICY.enter(Debug.DEBUG_LINUX, new Object[]{startSearchDirectory, fileName});
        String outputLine = EMPTY_PATH;
        String command = "find " + startSearchDirectory + WHITESPACE + FIND_NAME_FLAG + WHITESPACE + fileName;
        try {
            Debug.POLICY.trace(Debug.DEBUG_LINUX, command);
            Process process = ProcessFactory.getFactory().exec(command);
            ProcessController processController = new ProcessController("find", process, Long.MAX_VALUE);
            processController.start();
            BufferedReader processOutput = new BufferedReader(new InputStreamReader(process.getInputStream()));
            outputLine = processOutput.readLine();
            Debug.POLICY.trace(Debug.DEBUG_LINUX_MORE, outputLine);
            processController.interrupt();
        }
        catch (IOException e) {
            Debug.POLICY.error(Debug.DEBUG_LINUX, e);
            Debug.POLICY.exit(Debug.DEBUG_LINUX, EMPTY_PATH);
            Debug.POLICY.logError(e, Messages.Find_FailedExecution, command);
            return EMPTY_PATH;
        }
        if (outputLine == null) {
            Debug.POLICY.exit(Debug.DEBUG_LINUX, EMPTY_PATH);
            return EMPTY_PATH;
        }
        Debug.POLICY.exit(Debug.DEBUG_LINUX, outputLine);
        return outputLine;
    }

    public static String findWholename(String startSearchDirectory, String pathNamePattern) {
        Debug.read();
        Debug.POLICY.enter(Debug.DEBUG_LINUX, new Object[]{startSearchDirectory, pathNamePattern});
        String outputLine = EMPTY_PATH;
        String command = "find " + startSearchDirectory + WHITESPACE + FIND_WHOLENAME_FLAG + WHITESPACE + pathNamePattern;
        try {
            Debug.POLICY.trace(Debug.DEBUG_LINUX, command);
            Process process = ProcessFactory.getFactory().exec(command);
            ProcessController processController = new ProcessController("find", process, Long.MAX_VALUE);
            processController.start();
            BufferedReader processOutput = new BufferedReader(new InputStreamReader(process.getInputStream()));
            outputLine = processOutput.readLine();
            Debug.POLICY.trace(Debug.DEBUG_LINUX_MORE, outputLine);
            processController.interrupt();
        }
        catch (IOException e) {
            Debug.POLICY.error(Debug.DEBUG_LINUX, e);
            Debug.POLICY.exit(Debug.DEBUG_LINUX, EMPTY_PATH);
            Debug.POLICY.logError(e, Messages.Find_FailedExecution, command);
            return EMPTY_PATH;
        }
        if (outputLine == null) {
            Debug.POLICY.exit(Debug.DEBUG_LINUX, EMPTY_PATH);
            return EMPTY_PATH;
        }
        Debug.POLICY.exit(Debug.DEBUG_LINUX, outputLine);
        return outputLine;
    }
}

