/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rdt.services.internal.core;

import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.eclipse.ptp.rdt.services.core.IService;
import org.eclipse.ptp.rdt.services.core.IServiceCategory;
import org.eclipse.ptp.rdt.services.core.IServiceProvider;
import org.eclipse.ptp.rdt.services.core.IServiceProviderDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Service
implements IService {
    private String fServiceId;
    private String fServiceName;
    private Integer fServicePriority = Integer.MAX_VALUE;
    private Set<String> fServiceNatures;
    private Set<IServiceProviderDescriptor> fServiceProviderDescriptors = new HashSet<IServiceProviderDescriptor>();
    private Map<String, IServiceProviderDescriptor> fIdToServiceProviderDescriptorMap = new HashMap<String, IServiceProviderDescriptor>();
    private IServiceCategory category;
    private IServiceProvider nullProvider;

    public Service(String id, String name, String priority, Set<String> natures) {
        this.fServiceId = id;
        this.fServiceName = name;
        if (priority != null) {
            try {
                this.fServicePriority = Integer.parseInt(priority);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        this.fServiceNatures = natures;
    }

    public void addServiceProvider(IServiceProviderDescriptor provider) {
        this.fServiceProviderDescriptors.add(provider);
        this.fIdToServiceProviderDescriptorMap.put(provider.getId(), provider);
    }

    public void setNullServiceProvider(IServiceProvider nullProvider) {
        this.nullProvider = nullProvider;
    }

    @Override
    public IServiceProvider getNullProvider() {
        return this.nullProvider;
    }

    public boolean equals(Object o) {
        if (o instanceof IService) {
            return ((IService)o).getId().equals(this.fServiceId);
        }
        return false;
    }

    @Override
    public String getId() {
        return this.fServiceId;
    }

    @Override
    public String getName() {
        return this.fServiceName;
    }

    @Override
    public Set<String> getNatures() {
        return this.fServiceNatures;
    }

    @Override
    public Integer getPriority() {
        return this.fServicePriority;
    }

    @Override
    public IServiceProviderDescriptor getProviderDescriptor(String id) {
        return this.fIdToServiceProviderDescriptorMap.get(id);
    }

    @Override
    public Set<IServiceProviderDescriptor> getProviders() {
        return this.fServiceProviderDescriptors;
    }

    @Override
    public SortedSet<IServiceProviderDescriptor> getProvidersByPriority() {
        TreeSet<IServiceProviderDescriptor> sortedProviders = new TreeSet<IServiceProviderDescriptor>(new Comparator<IServiceProviderDescriptor>(){

            @Override
            public int compare(IServiceProviderDescriptor o1, IServiceProviderDescriptor o2) {
                int cmp = o1.getPriority().compareTo(o2.getPriority());
                if (cmp != 0) {
                    return cmp;
                }
                return o1.getId().compareTo(o2.getId());
            }
        });
        for (IServiceProviderDescriptor p : this.getProviders()) {
            sortedProviders.add(p);
        }
        return sortedProviders;
    }

    public int hashCode() {
        return this.fServiceId.hashCode();
    }

    @Override
    public void removeServiceProvider(IServiceProviderDescriptor provider) {
        this.fServiceProviderDescriptors.remove(provider);
        this.fIdToServiceProviderDescriptorMap.remove(provider.getId());
    }

    public String toString() {
        return "Service(" + this.fServiceId + ")";
    }

    public void setCategory(IServiceCategory category) {
        this.category = category;
    }

    @Override
    public IServiceCategory getCategory() {
        return this.category;
    }
}

