/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.debug.core;

import java.io.InputStream;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.ptp.core.attributes.EnumeratedAttribute;
import org.eclipse.ptp.core.attributes.IAttributeDefinition;
import org.eclipse.ptp.core.attributes.StringAttribute;
import org.eclipse.ptp.core.elements.IPProcess;
import org.eclipse.ptp.core.elements.attributes.ProcessAttributes;
import org.eclipse.ptp.core.elements.events.IProcessChangeEvent;
import org.eclipse.ptp.core.elements.listeners.IProcessListener;

public class ProcessInputStream
extends InputStream
implements IProcessListener {
    protected List<String> buffers;
    protected int pos;
    protected int count;
    private String currentBuffer;
    private IPProcess process;

    public ProcessInputStream(IPProcess process) {
        this.process = process;
        this.buffers = Collections.synchronizedList(new LinkedList());
        process.addElementListener((IProcessListener)this);
    }

    public IPProcess getProcess() {
        return this.process;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addInput(String buffer) {
        List<String> list = this.buffers;
        synchronized (list) {
            this.buffers.add(buffer == null ? "" : buffer);
            this.buffers.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getBuffer() {
        List<String> list = this.buffers;
        synchronized (list) {
            while (true) {
                if (!this.buffers.isEmpty()) {
                    String buffer = this.buffers.remove(0);
                    this.reset(buffer.length());
                    return buffer;
                }
                try {
                    this.buffers.wait();
                }
                catch (InterruptedException interruptedException) {
                    String string = "";
                }
            }
        }
    }

    public void restart() {
        this.process.addElementListener((IProcessListener)this);
    }

    public void close() {
        this.addInput("");
        this.process.addElementListener((IProcessListener)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read() {
        List<String> list = this.buffers;
        synchronized (list) {
            if (this.count <= this.pos) {
                this.currentBuffer = this.getBuffer();
            }
            return this.pos < this.count ? this.currentBuffer.charAt(this.pos++) & 0xFF : -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read(byte[] b, int off, int len) {
        List<String> list = this.buffers;
        synchronized (list) {
            String buffer;
            block10: {
                block9: {
                    buffer = this.getBuffer();
                    if (b == null) {
                        throw new NullPointerException();
                    }
                    if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
                        throw new IndexOutOfBoundsException();
                    }
                    if (this.pos < this.count) break block9;
                    return -1;
                }
                if (this.pos + len > this.count) {
                    len = this.count - this.pos;
                }
                if (len > 0) break block10;
                return 0;
            }
            int cnt = len;
            while (--cnt >= 0) {
                b[off++] = (byte)buffer.charAt(this.pos++);
            }
            return len;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset(int len) {
        List<String> list = this.buffers;
        synchronized (list) {
            this.pos = 0;
            this.count = len;
        }
    }

    public void handleEvent(IProcessChangeEvent e) {
        StringAttribute stdoutAttr;
        ProcessAttributes.State state;
        EnumeratedAttribute stateAttr = (EnumeratedAttribute)e.getAttributes().getAttribute((IAttributeDefinition)ProcessAttributes.getStateAttributeDefinition());
        if (stateAttr != null && ((state = (ProcessAttributes.State)stateAttr.getValue()) == ProcessAttributes.State.EXITED || state == ProcessAttributes.State.EXITED_SIGNALLED || state == ProcessAttributes.State.ERROR)) {
            this.close();
        }
        if ((stdoutAttr = (StringAttribute)e.getAttributes().getAttribute((IAttributeDefinition)ProcessAttributes.getStdoutAttributeDefinition())) != null) {
            this.addInput(String.valueOf(stdoutAttr.getValue()) + "\n");
        }
    }
}

