/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.debug.core.pdi.request;

import org.eclipse.ptp.core.util.BitList;
import org.eclipse.ptp.debug.core.pdi.IPDIDebugger;
import org.eclipse.ptp.debug.core.pdi.PDIException;
import org.eclipse.ptp.debug.core.pdi.model.aif.IAIF;
import org.eclipse.ptp.debug.core.pdi.request.AbstractEventResultRequest;
import org.eclipse.ptp.debug.core.pdi.request.IPDIDataEvaluateExpressionRequest;

public abstract class AbstractDataEvaluateExpressionRequest
extends AbstractEventResultRequest
implements IPDIDataEvaluateExpressionRequest {
    private String expr;

    public AbstractDataEvaluateExpressionRequest(BitList tasks, String expr) {
        super(tasks);
        this.expr = expr;
    }

    public void doExecute(IPDIDebugger debugger) throws PDIException {
        debugger.dataEvaluateExpression(this.tasks, this.expr);
    }

    public IAIF getAIF(BitList qTasks) throws PDIException {
        this.waitUntilCompleted(qTasks);
        Object obj = this.getResult(qTasks);
        if (obj instanceof IAIF) {
            return (IAIF)obj;
        }
        throw new PDIException(qTasks, "Variable " + this.expr + ": No value found");
    }

    public String getName() {
        return "Data evaluate expression request";
    }
}

