/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.debug.internal.core.pdi.model;

import org.eclipse.ptp.core.util.BitList;
import org.eclipse.ptp.debug.core.pdi.IPDISession;
import org.eclipse.ptp.debug.core.pdi.PDIException;
import org.eclipse.ptp.debug.core.pdi.SessionObject;
import org.eclipse.ptp.debug.core.pdi.model.IPDIStackFrame;
import org.eclipse.ptp.debug.core.pdi.model.IPDIThread;
import org.eclipse.ptp.debug.core.pdi.model.IPDIVariableDescriptor;
import org.eclipse.ptp.debug.core.pdi.model.aif.IAIF;
import org.eclipse.ptp.debug.core.pdi.request.IPDIGetPartialAIFRequest;
import org.eclipse.ptp.debug.internal.core.pdi.model.StackFrame;
import org.eclipse.ptp.debug.internal.core.pdi.model.Target;
import org.eclipse.ptp.debug.internal.core.pdi.model.Thread;

public abstract class VariableDescriptor
extends SessionObject
implements IPDIVariableDescriptor {
    protected String[] castingTypes;
    protected int castingIndex;
    protected int castingLength;
    protected String fName;
    protected int position;
    protected IPDIStackFrame fStackFrame;
    protected IPDIThread fThread;
    protected int stackdepth;
    protected String qualifiedName = null;
    protected String fFullName = null;
    protected String fTypename = null;
    protected String varid = null;
    protected IAIF aif = null;

    public static boolean equalsCasting(VariableDescriptor var1, VariableDescriptor var2) {
        String[] castings1 = var1.getCastingTypes();
        String[] castings2 = var2.getCastingTypes();
        if (castings1 == null && castings2 == null) {
            return true;
        }
        if (castings1 != null && castings2 != null && castings1.length == castings2.length) {
            int i = 0;
            while (i < castings1.length) {
                if (!castings1[i].equals(castings2[i])) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    public VariableDescriptor(IPDISession session, BitList tasks, IPDIThread thread, IPDIStackFrame stack, String n, String fn, int pos, int depth) {
        super(session, tasks);
        this.fName = n;
        this.fFullName = fn;
        this.fStackFrame = stack;
        this.fThread = thread;
        this.position = pos;
        this.stackdepth = depth;
    }

    public VariableDescriptor(IPDISession session, IPDIVariableDescriptor desc) {
        super(session, desc.getTasks());
        this.fName = desc.getName();
        this.fFullName = desc.getFullName();
        try {
            this.fStackFrame = (StackFrame)desc.getStackFrame();
            this.fThread = (Thread)desc.getThread();
        }
        catch (PDIException pDIException) {}
        this.position = desc.getPosition();
        this.stackdepth = desc.getStackDepth();
        this.castingIndex = desc.getCastingArrayStart();
        this.castingLength = desc.getCastingArrayEnd();
        this.castingTypes = desc.getCastingTypes();
    }

    public String encodeVariable() {
        String fn = this.getFullName();
        if (this.castingLength > 0 || this.castingIndex > 0) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("*(");
            buffer.append('(').append(fn).append(')');
            buffer.append('+').append(this.castingIndex).append(')');
            buffer.append('@').append(this.castingLength);
            fn = buffer.toString();
        } else if (this.castingTypes != null && this.castingTypes.length > 0) {
            StringBuffer buffer = new StringBuffer();
            int i = 0;
            while (i < this.castingTypes.length) {
                if (this.castingTypes[i] != null && this.castingTypes[i].length() > 0) {
                    if (buffer.length() == 0) {
                        buffer.append('(').append(this.castingTypes[i]).append(')');
                        buffer.append(fn);
                    } else {
                        buffer.insert(0, '(');
                        buffer.append(')');
                        StringBuffer b = new StringBuffer();
                        b.append('(').append(this.castingTypes[i]).append(')');
                        buffer.insert(0, b.toString());
                    }
                }
                ++i;
            }
            fn = buffer.toString();
        }
        return fn;
    }

    public boolean equalDescriptors(IPDIVariableDescriptor varDesc) {
        VariableDescriptor desc;
        if (varDesc instanceof VariableDescriptor && (desc = (VariableDescriptor)varDesc).getName().equals(this.getName()) && desc.getCastingArrayStart() == this.getCastingArrayStart() && desc.getCastingArrayEnd() == this.getCastingArrayEnd() && VariableDescriptor.equalsCasting(desc, this)) {
            IPDIThread varThread = null;
            IPDIThread ourThread = null;
            try {
                varThread = desc.getThread();
                ourThread = this.getThread();
            }
            catch (PDIException pDIException) {}
            if (ourThread == null && varThread == null || varThread != null && ourThread != null && varThread.equals(ourThread)) {
                IPDIStackFrame varFrame = null;
                IPDIStackFrame ourFrame = null;
                try {
                    varFrame = desc.getStackFrame();
                    ourFrame = this.getStackFrame();
                }
                catch (PDIException pDIException) {}
                if (ourFrame == null && varFrame == null) {
                    return true;
                }
                if (varFrame != null && ourFrame != null && varFrame.equals(ourFrame) && desc.getStackDepth() == this.getStackDepth() && desc.getPosition() == this.getPosition()) {
                    return true;
                }
            }
            return false;
        }
        return super.equals(varDesc);
    }

    public IAIF getAIF() throws PDIException {
        if (this.aif == null) {
            Target target = (Target)this.fStackFrame.getTarget();
            Thread currentThread = target.getCurrentThread();
            IPDIStackFrame currentFrame = currentThread.getCurrentStackFrame();
            target.lockTarget();
            try {
                target.setCurrentThread(this.fStackFrame.getThread(), false);
                ((Thread)this.fStackFrame.getThread()).setCurrentStackFrame(this.fStackFrame, false);
                IPDIGetPartialAIFRequest request = this.session.getRequestFactory().getGetPartialAIFRequest(this.getTasks(), this.getQualifiedName(), this.varid);
                this.session.getEventRequestManager().addEventRequest(request);
                this.aif = request.getPartialAIF(this.getTasks());
                this.varid = request.getVarId(this.getTasks());
            }
            finally {
                target.setCurrentThread(currentThread, false);
                currentThread.setCurrentStackFrame(currentFrame, false);
                target.releaseTarget();
            }
        }
        return this.aif;
    }

    public int getCastingArrayEnd() {
        return this.castingLength;
    }

    public int getCastingArrayStart() {
        return this.castingIndex;
    }

    public String[] getCastingTypes() {
        return this.castingTypes;
    }

    public String getFullName() {
        if (this.fFullName == null) {
            this.fFullName = this.getName();
        }
        return this.fFullName;
    }

    public String getName() {
        return this.fName;
    }

    public int getPosition() {
        return this.position;
    }

    public String getQualifiedName() throws PDIException {
        if (this.qualifiedName == null) {
            this.qualifiedName = this.encodeVariable();
        }
        return this.qualifiedName;
    }

    public int getStackDepth() {
        return this.stackdepth;
    }

    public IPDIStackFrame getStackFrame() throws PDIException {
        return this.fStackFrame;
    }

    public IPDIThread getThread() throws PDIException {
        return this.fThread;
    }

    public String getTypeName() throws PDIException {
        if (this.fTypename == null) {
            this.fTypename = this.getAIF().getType().toString();
        }
        return this.fTypename;
    }

    public IPDIVariableDescriptor getVariableDescriptorAsArray(int start, int length) throws PDIException {
        return this.session.getVariableManager().getVariableDescriptorAsArray(this, start, length);
    }

    public IPDIVariableDescriptor getVariableDescriptorAsType(String type) throws PDIException {
        return this.session.getVariableManager().getVariableDescriptorAsType(this, type);
    }

    public String getVarId() {
        return this.varid;
    }

    public void setAIF(IAIF aif) {
        this.aif = aif;
    }

    public void setCastingArrayEnd(int end) {
        this.castingLength = end;
    }

    public void setCastingArrayStart(int start) {
        this.castingIndex = start;
    }

    public void setCastingTypes(String[] t) {
        this.castingTypes = t;
    }

    public int sizeof() throws PDIException {
        return this.getAIF().getType().sizeof();
    }
}

