/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.cell.environment.cellsimulator.core.remote;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ptp.cell.environment.cellsimulator.CellSimulatorTargetPlugin;
import org.eclipse.ptp.cell.environment.cellsimulator.core.remote.Messages;
import org.eclipse.ptp.cell.simulator.core.AbstractSimulatorDelegate;
import org.eclipse.ptp.cell.simulator.core.ISimulatorParameters;
import org.eclipse.ptp.cell.simulator.core.SimulatorException;
import org.eclipse.ptp.cell.simulator.core.SimulatorOperationException;
import org.eclipse.ptp.remotetools.core.IRemoteCopyTools;
import org.eclipse.ptp.remotetools.core.IRemoteDirectory;
import org.eclipse.ptp.remotetools.core.IRemoteDownloadExecution;
import org.eclipse.ptp.remotetools.core.IRemoteExecutionManager;
import org.eclipse.ptp.remotetools.core.IRemoteExecutionTools;
import org.eclipse.ptp.remotetools.core.IRemoteFile;
import org.eclipse.ptp.remotetools.core.IRemoteFileTools;
import org.eclipse.ptp.remotetools.core.IRemoteItem;
import org.eclipse.ptp.remotetools.core.IRemotePathTools;
import org.eclipse.ptp.remotetools.core.IRemoteScript;
import org.eclipse.ptp.remotetools.core.IRemoteUploadExecution;
import org.eclipse.ptp.remotetools.core.RemoteProcess;
import org.eclipse.ptp.remotetools.exception.CancelException;
import org.eclipse.ptp.remotetools.exception.RemoteConnectionException;
import org.eclipse.ptp.remotetools.exception.RemoteException;
import org.eclipse.ptp.remotetools.exception.RemoteExecutionException;
import org.eclipse.ptp.remotetools.exception.RemoteOperationException;
import org.eclipse.ptp.utils.core.linux.ArgumentParser;

public class RemoteSimulatorDelegate
extends AbstractSimulatorDelegate {
    IRemoteExecutionManager executionManager;
    RemoteProcess simulatorProcess;
    int simulatorPID;
    boolean hasSimulatorPID = false;

    public RemoteSimulatorDelegate(ISimulatorParameters configuration, IRemoteExecutionManager executionManager) {
        super(configuration);
        this.executionManager = executionManager;
    }

    public String[] createCellSimEnvironment() throws SimulatorException {
        HashMap env = new HashMap();
        this.addDefaultVariables(env);
        String[] strings = this.toVariablesArray(env);
        return strings;
    }

    public Process createGenericProcess(String workDirectory, String[] cmdarray, String[] environment) throws SimulatorException {
        if (this.executionManager == null) {
            throw new SimulatorException(Messages.RemoteSimulatorDelegate_TargetHostNotConnected);
        }
        IRemoteExecutionTools executionTools = null;
        IRemoteScript script = null;
        try {
            executionTools = this.executionManager.getExecutionTools();
            script = executionTools.createScript();
        }
        catch (RemoteConnectionException e) {
            throw new SimulatorException(Messages.RemoteSimulatorDelegate_TargetHostConnectionFailed, (Throwable)e);
        }
        if (environment != null) {
            script.addEnvironment(environment);
        }
        String commandLine = new ArgumentParser(cmdarray).getCommandLine(true);
        script.setScript(new String[]{"cd " + workDirectory, commandLine});
        try {
            RemoteProcess process = executionTools.executeProcess(script);
            return process;
        }
        catch (RemoteException e) {
            throw new SimulatorException(NLS.bind((String)Messages.RemoteSimulatorDelegate_ErrorCreatingProcess, (Object[])new String[]{commandLine, e.getMessage()}), (Throwable)e);
        }
        catch (CancelException e) {
            throw new SimulatorException(NLS.bind((String)Messages.RemoteSimulatorDelegate_ErrorCreatingProcess, (Object[])new String[]{commandLine, e.getMessage()}), (Throwable)e);
        }
    }

    public Process createSimulatorProcess(String workDirectory, String[] cmdarray, String[] environment) throws SimulatorException {
        if (this.executionManager == null) {
            throw new SimulatorException(Messages.RemoteSimulatorDelegate_TargetHostNotConnected);
        }
        IRemoteExecutionTools executionTools = null;
        IRemoteScript script = null;
        try {
            executionTools = this.executionManager.getExecutionTools();
            script = executionTools.createScript();
            script.setForwardX11(true);
        }
        catch (RemoteConnectionException e) {
            throw new SimulatorException(Messages.RemoteSimulatorDelegate_TargetHostConnectionFailed, (Throwable)e);
        }
        if (environment != null) {
            script.addEnvironment(environment);
        }
        String commandLine = new ArgumentParser(cmdarray).getCommandLine(true);
        script.setScript(new String[]{"cd " + workDirectory, "export", commandLine});
        try {
            this.simulatorProcess = executionTools.executeProcess(script);
            this.hasSimulatorPID = false;
        }
        catch (RemoteException e) {
            throw new SimulatorException(NLS.bind((String)Messages.RemoteSimulatorDelegate_ErrorCreatingProcess, (Object[])new String[]{commandLine, e.getMessage()}), (Throwable)e);
        }
        catch (CancelException e) {
            throw new SimulatorException(NLS.bind((String)Messages.RemoteSimulatorDelegate_ErrorCreatingProcess, (Object[])new String[]{commandLine, e.getMessage()}), (Throwable)e);
        }
        return this.simulatorProcess;
    }

    public void stopSimulatorProcess(Process process) throws SimulatorException {
        if (this.executionManager == null) {
            throw new IllegalStateException(Messages.RemoteSimulatorDelegate_TargetHostNotConnected);
        }
        try {
            this.readSimulatorPID();
            IRemoteExecutionTools executionTools = this.executionManager.getExecutionTools();
            int result = executionTools.executeWithExitValue("kill -TERM " + Integer.toString(this.simulatorPID));
            if (result != 0) {
                throw new SimulatorException(Messages.RemoteSimulatorDelegate_CannotSendSignalToSimulator);
            }
        }
        catch (SimulatorException e) {
            throw new SimulatorException(Messages.RemoteSimulatorDelegate_CannotReadSimulatorPID, (Throwable)e);
        }
        catch (RemoteConnectionException e) {
            throw new SimulatorException(Messages.RemoteSimulatorDelegate_CannotSendSignalToSimulator, (Throwable)e);
        }
        catch (RemoteExecutionException e) {
            throw new SimulatorException(Messages.RemoteSimulatorDelegate_CannotSendSignalToSimulator, (Throwable)e);
        }
        catch (CancelException e) {
            throw new SimulatorException(Messages.RemoteSimulatorDelegate_CannotSendSignalToSimulator, (Throwable)e);
        }
    }

    private void readSimulatorPID() throws SimulatorException {
        if (!this.hasSimulatorPID) {
            String pidFile = this.getConfiguration().getPIDPath();
            try {
                ByteArrayOutputStream stream = new ByteArrayOutputStream();
                IRemoteCopyTools copyTools = this.executionManager.getRemoteCopyTools();
                IRemoteDownloadExecution execution = copyTools.executeDownload(pidFile, (OutputStream)stream);
                execution.waitForEndOfExecution();
                String content = new String(stream.toByteArray());
                this.simulatorPID = Integer.parseInt(content.trim());
                this.hasSimulatorPID = true;
            }
            catch (NumberFormatException e) {
                throw new SimulatorException(Messages.RemoteSimulatorDelegate_CannotReadSimulatorPIDInFile, (Throwable)e);
            }
            catch (RemoteConnectionException e) {
                throw new SimulatorException(Messages.RemoteSimulatorDelegate_CannotReadSimulatorPIDInFile, (Throwable)e);
            }
            catch (RemoteExecutionException e) {
                throw new SimulatorException(Messages.RemoteSimulatorDelegate_CannotReadSimulatorPIDInFile, (Throwable)e);
            }
            catch (CancelException e) {
                throw new SimulatorException(Messages.RemoteSimulatorDelegate_CannotReadSimulatorPIDInFile, (Throwable)e);
            }
        }
    }

    public void destroySimulatorProcess(Process simulatorProcess) {
        if (this.executionManager == null) {
            throw new IllegalStateException(Messages.RemoteSimulatorDelegate_TargetHostNotConnected);
        }
        try {
            this.readSimulatorPID();
            IRemoteExecutionTools executionTools = this.executionManager.getExecutionTools();
            executionTools.executeWithExitValue("kill -9 " + Integer.toString(this.simulatorPID));
        }
        catch (RemoteConnectionException e) {
            e.printStackTrace();
        }
        catch (RemoteExecutionException e) {
            e.printStackTrace();
        }
        catch (CancelException e) {
            e.printStackTrace();
        }
        catch (SimulatorException e) {
            e.printStackTrace();
        }
    }

    public void writeFile(String path, InputStream contentInputStrean) throws SimulatorException {
        try {
            IRemoteCopyTools copyTools = this.executionManager.getRemoteCopyTools();
            IRemoteUploadExecution execution = copyTools.executeUpload(path, contentInputStrean);
            execution.waitForEndOfExecution();
        }
        catch (RemoteConnectionException e) {
            throw new SimulatorException(Messages.RemoteSimulatorDelegate_CannotUploadFile, (Throwable)e);
        }
        catch (RemoteExecutionException e) {
            throw new SimulatorException(Messages.RemoteSimulatorDelegate_CannotUploadFile, (Throwable)e);
        }
        catch (CancelException e) {
            throw new SimulatorException(Messages.RemoteSimulatorDelegate_CannotUploadFile, (Throwable)e);
        }
    }

    public void readFile(String path, OutputStream contentOutputStream) throws SimulatorException {
        try {
            IRemoteCopyTools copyTools = this.executionManager.getRemoteCopyTools();
            IRemoteDownloadExecution execution = copyTools.executeDownload(path, contentOutputStream);
            execution.waitForEndOfExecution();
        }
        catch (RemoteConnectionException e) {
            throw new SimulatorException(Messages.RemoteSimulatorDelegate_CannotDownloadFile, (Throwable)e);
        }
        catch (RemoteExecutionException e) {
            throw new SimulatorException(Messages.RemoteSimulatorDelegate_CannotDownloadFile, (Throwable)e);
        }
        catch (CancelException e) {
            throw new SimulatorException(Messages.RemoteSimulatorDelegate_CannotDownloadFile, (Throwable)e);
        }
    }

    public void removeFile(String path) throws SimulatorException {
        try {
            IRemoteFileTools fileTools = this.executionManager.getRemoteFileTools();
            fileTools.removeFile(path);
        }
        catch (RemoteConnectionException e) {
            throw new SimulatorException(Messages.RemoteSimulatorDelegate_CannotDeletePath, (Throwable)e);
        }
        catch (RemoteOperationException e) {
            throw new SimulatorException(Messages.RemoteSimulatorDelegate_CannotDeletePath, (Throwable)e);
        }
        catch (CancelException e) {
            throw new SimulatorException(Messages.RemoteSimulatorDelegate_CannotDeletePath, (Throwable)e);
        }
    }

    public void logError(String string) {
        ILog log = CellSimulatorTargetPlugin.getDefault().getLog();
        Status status = new Status(4, CellSimulatorTargetPlugin.getDefault().getBundle().getSymbolicName(), 0, string, null);
        log.log((IStatus)status);
    }

    public void logError(String string, Exception e) {
        ILog log = CellSimulatorTargetPlugin.getDefault().getLog();
        Status status = new Status(4, CellSimulatorTargetPlugin.getDefault().getBundle().getSymbolicName(), 0, string, (Throwable)e);
        log.log((IStatus)status);
    }

    public boolean fileExists(String logDirectory) throws SimulatorException {
        try {
            IRemoteFileTools fileTools = this.executionManager.getRemoteFileTools();
            return fileTools.hasDirectory(logDirectory);
        }
        catch (RemoteConnectionException e) {
            throw new SimulatorException(Messages.RemoteSimulatorDelegate_CannotCheckPath, (Throwable)e);
        }
        catch (RemoteOperationException e) {
            throw new SimulatorException(Messages.RemoteSimulatorDelegate_CannotCheckPath, (Throwable)e);
        }
        catch (CancelException e) {
            throw new SimulatorException(Messages.RemoteSimulatorDelegate_CannotCheckPath, (Throwable)e);
        }
    }

    public void recursiveCreateDirectory(String path) throws Exception {
        try {
            IRemoteFileTools fileTools = this.executionManager.getRemoteFileTools();
            fileTools.createDirectory(path);
        }
        catch (Exception e) {
            throw new Exception(NLS.bind((String)Messages.RemoteSimulatorDelegate_CreateRemoteDirFailed, (Object)path), e);
        }
    }

    public void verifyPath(int options, String path) throws Exception {
        IRemoteItem item;
        Assert.isNotNull((Object)this.executionManager);
        IRemoteFileTools fileTools = this.executionManager.getRemoteFileTools();
        IRemotePathTools pathTools = this.executionManager.getRemotePathTools();
        if (!pathTools.isAbsolute(path)) {
            throw new SimulatorOperationException(10001, path);
        }
        try {
            item = fileTools.getItem(path);
        }
        catch (RemoteOperationException remoteOperationException) {
            throw new SimulatorOperationException(10002, path);
        }
        if (!item.exists()) {
            throw new SimulatorOperationException(10002, path);
        }
        if ((options & 2) != 0 && !(item instanceof IRemoteFile)) {
            throw new SimulatorOperationException(10003, path);
        }
        if ((options & 4) != 0 && !(item instanceof IRemoteDirectory)) {
            throw new SimulatorOperationException(10004, path);
        }
        if ((options & 8) != 0 && !item.isReadable()) {
            throw new SimulatorOperationException(10005, path);
        }
        if ((options & 0x10) != 0 && !item.isWritable()) {
            throw new SimulatorOperationException(10006, path);
        }
    }
}

