/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.remotetools.internal.common;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.ptp.remotetools.core.IRemoteScript;

public class RemoteScript
implements IRemoteScript {
    private List environment = new LinkedList();
    private boolean willForwardX11 = false;
    private InputStream inputStream = null;
    private OutputStream outputStream = null;
    private OutputStream errorStream = null;
    String[] script;
    private boolean fetchProcessErrorStream = false;
    private boolean fetchProcessInputStream = false;
    private boolean fetchProcessOutputStream = false;
    private boolean allocateTerminal = false;

    public void addEnvironment(String variable) {
        this.environment.add(variable);
    }

    public void addEnvironment(String[] environment) {
        this.environment.addAll(Arrays.asList(environment));
    }

    public void setProcessInputStream(InputStream input) {
        this.inputStream = input;
        this.fetchProcessInputStream = false;
    }

    public void setProcessOutputStream(OutputStream output) {
        this.outputStream = output;
        this.fetchProcessOutputStream = false;
    }

    public void setProcessErrorStream(OutputStream output) {
        this.errorStream = output;
        this.fetchProcessErrorStream = false;
    }

    public void setForwardX11(boolean willForward) {
        this.willForwardX11 = willForward;
    }

    public void setScript(String script) {
        this.script = new String[1];
        this.script[0] = script;
    }

    public void setScript(String[] script) {
        this.script = script;
    }

    public String getScriptString() {
        if (this.script == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        Iterator it = this.environment.iterator();
        if (this.environment.size() > 0) {
            sb.append("declare -x ");
        }
        while (it.hasNext()) {
            sb.append("\"" + (String)it.next() + "\" ");
        }
        if (this.environment.size() > 0) {
            sb.append("; ");
        }
        int i = 0;
        while (i < this.script.length) {
            sb.append(String.valueOf(this.script[i]) + "; ");
            ++i;
        }
        return sb.toString();
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public OutputStream getOutputStream() {
        return this.outputStream;
    }

    public OutputStream getErrorStream() {
        return this.errorStream;
    }

    public boolean willForwardX11() {
        return this.willForwardX11;
    }

    public void setFetchProcessErrorStream(boolean flag) {
        this.fetchProcessErrorStream = flag;
        this.errorStream = null;
    }

    public void setFetchProcessInputStream(boolean flag) {
        this.fetchProcessInputStream = flag;
        this.inputStream = null;
    }

    public void setFetchProcessOutputStream(boolean flag) {
        this.fetchProcessOutputStream = flag;
        this.outputStream = null;
    }

    public boolean getFetchProcessErrorStream() {
        return this.fetchProcessErrorStream;
    }

    public boolean getFetchProcessOutputStream() {
        return this.fetchProcessOutputStream;
    }

    public boolean getFetchProcessInputStream() {
        return this.fetchProcessInputStream;
    }

    public void setAllocateTerminal(boolean flag) {
        this.allocateTerminal = flag;
    }

    public boolean getAllocateTerminal() {
        return this.allocateTerminal;
    }
}

