/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.index.composite.cpp;

import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPNamespace;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPNamespaceScope;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPUsingDirective;
import org.eclipse.cdt.core.index.IIndexBinding;
import org.eclipse.cdt.core.index.IIndexFileSet;
import org.eclipse.cdt.core.index.IIndexName;
import org.eclipse.cdt.internal.core.index.IIndexFragmentBinding;
import org.eclipse.cdt.internal.core.index.IIndexScope;
import org.eclipse.cdt.internal.core.index.composite.CompositeScope;
import org.eclipse.cdt.internal.core.index.composite.ICompositesFactory;

class CompositeCPPNamespaceScope
extends CompositeScope
implements ICPPNamespaceScope {
    ICPPNamespace[] namespaces;

    public CompositeCPPNamespaceScope(ICompositesFactory cf, ICPPNamespace[] namespaces) {
        super(cf, (IIndexFragmentBinding)((Object)namespaces[0]));
        this.namespaces = namespaces;
    }

    public void addUsingDirective(ICPPUsingDirective directive) throws DOMException {
        this.fail();
    }

    public ICPPUsingDirective[] getUsingDirectives() throws DOMException {
        return new ICPPUsingDirective[0];
    }

    public IBinding getBinding(IASTName name, boolean resolve, IIndexFileSet fileSet) throws DOMException {
        IBinding preresult = null;
        int i = 0;
        while (preresult == null && i < this.namespaces.length) {
            preresult = this.namespaces[i].getNamespaceScope().getBinding(name, resolve, fileSet);
            ++i;
        }
        return this.processUncertainBinding(preresult);
    }

    public IBinding[] getBindings(IASTName name, boolean resolve, boolean prefixLookup, IIndexFileSet fileSet) throws DOMException {
        IIndexFragmentBinding[][] preresult = new IIndexFragmentBinding[this.namespaces.length][];
        int i = 0;
        while (i < this.namespaces.length) {
            IBinding[] raw = this.namespaces[i].getNamespaceScope().getBindings(name, resolve, prefixLookup, fileSet);
            preresult[i] = new IIndexFragmentBinding[raw.length];
            System.arraycopy(raw, 0, preresult[i], 0, raw.length);
            ++i;
        }
        return this.cf.getCompositeBindings(preresult);
    }

    public final IBinding[] find(String name) throws DOMException {
        IIndexFragmentBinding[][] preresult = new IIndexFragmentBinding[this.namespaces.length][];
        int i = 0;
        while (i < this.namespaces.length) {
            IBinding[] raw = this.namespaces[i].getNamespaceScope().find(name);
            preresult[i] = new IIndexFragmentBinding[raw.length];
            System.arraycopy(raw, 0, preresult[i], 0, raw.length);
            ++i;
        }
        return this.cf.getCompositeBindings(preresult);
    }

    public IIndexBinding getScopeBinding() {
        return this.cf.getCompositeBinding(this.rbinding);
    }

    public IIndexName getScopeName() {
        int i = 0;
        while (i < this.namespaces.length) {
            IIndexScope s;
            IIndexName nm;
            if (this.namespaces[i] instanceof IIndexScope && (nm = (s = (IIndexScope)((Object)this.namespaces[i])).getScopeName()) != null) {
                return nm;
            }
            ++i;
        }
        return null;
    }
}

