/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.c;

import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTSimpleDeclaration;
import org.eclipse.cdt.core.dom.ast.gnu.c.ICASTKnRFunctionDeclarator;
import org.eclipse.cdt.internal.core.dom.parser.c.CASTDeclarator;

public class CASTKnRFunctionDeclarator
extends CASTDeclarator
implements ICASTKnRFunctionDeclarator {
    IASTName[] parameterNames = IASTName.EMPTY_NAME_ARRAY;
    IASTDeclaration[] parameterDeclarations = IASTDeclaration.EMPTY_DECLARATION_ARRAY;

    public CASTKnRFunctionDeclarator() {
    }

    public CASTKnRFunctionDeclarator(IASTName[] parameterNames, IASTDeclaration[] parameterDeclarations) {
        this.setParameterNames(parameterNames);
        this.setParameterDeclarations(parameterDeclarations);
    }

    public void setParameterNames(IASTName[] names) {
        this.parameterNames = names;
        int i = 0;
        while (i < names.length) {
            IASTName name = names[i];
            if (name != null) {
                name.setParent(this);
                name.setPropertyInParent(PARAMETER_NAME);
            }
            ++i;
        }
    }

    public IASTName[] getParameterNames() {
        return this.parameterNames;
    }

    public void setParameterDeclarations(IASTDeclaration[] decls) {
        this.parameterDeclarations = decls;
        int i = 0;
        while (i < this.parameterDeclarations.length) {
            IASTDeclaration decl = this.parameterDeclarations[i];
            if (decl != null) {
                decl.setParent(this);
                decl.setPropertyInParent(FUNCTION_PARAMETER);
            }
            ++i;
        }
    }

    public IASTDeclaration[] getParameterDeclarations() {
        return this.parameterDeclarations;
    }

    protected boolean postAccept(ASTVisitor action) {
        IASTName[] ns = this.getParameterNames();
        int i = 0;
        while (i < ns.length) {
            if (!ns[i].accept(action)) {
                return false;
            }
            ++i;
        }
        IASTDeclaration[] params = this.getParameterDeclarations();
        int i2 = 0;
        while (i2 < params.length) {
            if (!params[i2].accept(action)) {
                return false;
            }
            ++i2;
        }
        return true;
    }

    public IASTDeclarator getDeclaratorForParameterName(IASTName name) {
        boolean found = false;
        int i = 0;
        while (i < this.parameterNames.length) {
            if (this.parameterNames[i] == name) {
                found = true;
            }
            ++i;
        }
        if (!found) {
            return null;
        }
        i = 0;
        while (i < this.parameterDeclarations.length) {
            if (this.parameterDeclarations[i] instanceof IASTSimpleDeclaration) {
                IASTDeclarator[] decltors = ((IASTSimpleDeclaration)this.parameterDeclarations[i]).getDeclarators();
                int j = 0;
                while (j < decltors.length) {
                    if (decltors[j].getName().toString().equals(name.toString())) {
                        return decltors[j];
                    }
                    ++j;
                }
            }
            ++i;
        }
        return null;
    }

    public int getRoleForName(IASTName name) {
        IASTName[] n = this.getParameterNames();
        int i = 0;
        while (i < n.length) {
            if (n[i] == name) {
                return 3;
            }
            ++i;
        }
        return super.getRoleForName(name);
    }
}

