/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import org.eclipse.cdt.core.dom.ILinkage;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTCompositeTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTSimpleDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IField;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.ITypedef;
import org.eclipse.cdt.core.dom.ast.cpp.CPPASTVisitor;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTCompositeTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTElaboratedTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTQualifiedName;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTemplateDeclaration;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTemplateId;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPBase;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPBlockScope;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassScope;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPConstructor;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPField;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunctionScope;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPMethod;
import org.eclipse.cdt.core.index.IIndex;
import org.eclipse.cdt.core.index.IIndexBinding;
import org.eclipse.cdt.core.parser.util.ArrayUtil;
import org.eclipse.cdt.core.parser.util.CharArrayUtils;
import org.eclipse.cdt.core.parser.util.ObjectSet;
import org.eclipse.cdt.internal.core.dom.Linkage;
import org.eclipse.cdt.internal.core.dom.parser.ASTNode;
import org.eclipse.cdt.internal.core.dom.parser.ProblemBinding;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ClassTypeMixin;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPInternalClassTypeMixinHost;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPVisitor;
import org.eclipse.cdt.internal.core.index.IIndexType;
import org.eclipse.core.runtime.PlatformObject;

public class CPPClassType
extends PlatformObject
implements ICPPInternalClassTypeMixinHost {
    private IASTName definition;
    private IASTName[] declarations;
    private boolean checked = false;
    private ICPPClassType typeInIndex;
    private ClassTypeMixin mixin;

    public static ICPPMethod[] getMethods(ICPPClassType ct) throws DOMException {
        ICPPBase[] bases;
        ObjectSet<ICPPMethod> set = new ObjectSet<ICPPMethod>(4);
        set.addAll(ct.getDeclaredMethods());
        ICPPClassScope scope = (ICPPClassScope)ct.getCompositeScope();
        set.addAll(scope.getImplicitMethods());
        ICPPBase[] iCPPBaseArray = bases = ct.getBases();
        int n = bases.length;
        int n2 = 0;
        while (n2 < n) {
            ICPPBase base = iCPPBaseArray[n2];
            IBinding b = base.getBaseClass();
            if (b instanceof ICPPClassType) {
                set.addAll(((ICPPClassType)b).getMethods());
            }
            ++n2;
        }
        return set.keyArray(ICPPMethod.class);
    }

    public CPPClassType(IASTName name, IBinding indexBinding) {
        if (name instanceof ICPPASTQualifiedName) {
            IASTName[] ns = ((ICPPASTQualifiedName)name).getNames();
            name = ns[ns.length - 1];
        }
        IASTNode parent = name.getParent();
        while (parent instanceof IASTName) {
            parent = parent.getParent();
        }
        if (parent instanceof IASTCompositeTypeSpecifier) {
            this.definition = name;
        } else {
            this.declarations = new IASTName[]{name};
        }
        name.setBinding(this);
        if (indexBinding instanceof ICPPClassType && indexBinding instanceof IIndexBinding) {
            this.typeInIndex = (ICPPClassType)indexBinding;
        }
        this.mixin = new ClassTypeMixin(this);
    }

    public IASTNode[] getDeclarations() {
        return this.declarations;
    }

    public IASTNode getDefinition() {
        return this.definition;
    }

    public void checkForDefinition() {
        if (!this.checked) {
            FindDefinitionAction action = new FindDefinitionAction();
            IASTNode node = CPPVisitor.getContainingBlockItem(this.getPhysicalNode()).getParent();
            if (node instanceof ICPPASTCompositeTypeSpecifier) {
                node = CPPVisitor.getContainingBlockItem(node.getParent());
            }
            while (node instanceof ICPPASTTemplateDeclaration) {
                node = node.getParent();
            }
            node.accept(action);
            this.definition = action.result;
            if (this.definition == null) {
                IIndex index;
                IASTTranslationUnit translationUnit = node.getTranslationUnit();
                translationUnit.accept(action);
                this.definition = action.result;
                if (this.definition == null && this.typeInIndex == null && (index = translationUnit.getIndex()) != null) {
                    this.typeInIndex = (ICPPClassType)((Object)index.adaptBinding(this));
                }
            }
            this.checked = true;
        }
    }

    public ICPPASTCompositeTypeSpecifier getCompositeTypeSpecifier() {
        if (this.definition != null) {
            IASTNode node = this.definition;
            while (node instanceof IASTName) {
                node = node.getParent();
            }
            if (node instanceof ICPPASTCompositeTypeSpecifier) {
                return (ICPPASTCompositeTypeSpecifier)node;
            }
        }
        return null;
    }

    private ICPPASTElaboratedTypeSpecifier getElaboratedTypeSpecifier() {
        if (this.declarations != null) {
            IASTNode node = this.declarations[0];
            while (node instanceof IASTName) {
                node = node.getParent();
            }
            if (node instanceof ICPPASTElaboratedTypeSpecifier) {
                return (ICPPASTElaboratedTypeSpecifier)node;
            }
        }
        return null;
    }

    public String getName() {
        return this.definition != null ? this.definition.toString() : this.declarations[0].toString();
    }

    public char[] getNameCharArray() {
        return this.definition != null ? this.definition.toCharArray() : this.declarations[0].toCharArray();
    }

    public IScope getScope() {
        IASTNode node;
        IASTName name = this.definition != null ? this.definition : this.declarations[0];
        IScope scope = CPPVisitor.getContainingScope(name);
        if (this.definition == null && name.getPropertyInParent() != ICPPASTQualifiedName.SEGMENT_NAME && (!((node = this.declarations[0].getParent().getParent()) instanceof IASTSimpleDeclaration) || ((IASTSimpleDeclaration)node).getDeclarators().length != 0 || this.getElaboratedTypeSpecifier().isFriend())) {
            while (scope instanceof ICPPClassScope || scope instanceof ICPPFunctionScope) {
                try {
                    scope = scope.getParent();
                }
                catch (DOMException dOMException) {}
            }
        }
        return scope;
    }

    public IScope getCompositeScope() {
        if (this.definition == null) {
            this.checkForDefinition();
        }
        if (this.definition != null) {
            return this.getCompositeTypeSpecifier().getScope();
        }
        if (this.typeInIndex != null) {
            try {
                return this.typeInIndex.getCompositeScope();
            }
            catch (DOMException dOMException) {}
        }
        return null;
    }

    public IASTNode getPhysicalNode() {
        return this.definition != null ? this.definition : this.declarations[0];
    }

    public int getKey() {
        if (this.definition != null) {
            return this.getCompositeTypeSpecifier().getKey();
        }
        return this.getElaboratedTypeSpecifier().getKind();
    }

    public void addDefinition(IASTNode node) {
        if (node instanceof ICPPASTCompositeTypeSpecifier) {
            this.definition = ((ICPPASTCompositeTypeSpecifier)node).getName();
        }
    }

    public void addDeclaration(IASTNode node) {
        if (!(node instanceof ICPPASTElaboratedTypeSpecifier)) {
            return;
        }
        IASTName name = ((ICPPASTElaboratedTypeSpecifier)node).getName();
        if (this.declarations == null) {
            this.declarations = new IASTName[]{name};
            return;
        }
        this.declarations = this.declarations.length > 0 && ((ASTNode)node).getOffset() < ((ASTNode)((Object)this.declarations[0])).getOffset() ? (IASTName[])ArrayUtil.prepend(IASTName.class, this.declarations, name) : (IASTName[])ArrayUtil.append(IASTName.class, this.declarations, name);
    }

    public void removeDeclaration(IASTNode node) {
        if (this.definition == node) {
            this.definition = null;
            return;
        }
        ArrayUtil.remove(this.declarations, node);
    }

    public String[] getQualifiedName() {
        return CPPVisitor.getQualifiedName(this);
    }

    public char[][] getQualifiedNameCharArray() {
        return CPPVisitor.getQualifiedNameCharArray(this);
    }

    public boolean isGloballyQualified() throws DOMException {
        IScope scope = this.getScope();
        while (scope != null) {
            if (scope instanceof ICPPBlockScope) {
                return false;
            }
            scope = scope.getParent();
        }
        return true;
    }

    public ILinkage getLinkage() {
        return Linkage.CPP_LINKAGE;
    }

    public boolean isSameType(IType type) {
        if (type == this) {
            return true;
        }
        if (type instanceof ITypedef || type instanceof IIndexType) {
            return type.isSameType(this);
        }
        return false;
    }

    public ICPPBase[] getBases() {
        return this.mixin.getBases();
    }

    public IField[] getFields() throws DOMException {
        return this.mixin.getFields();
    }

    public ICPPField[] getDeclaredFields() throws DOMException {
        return this.mixin.getDeclaredFields();
    }

    public ICPPMethod[] getMethods() throws DOMException {
        return CPPClassType.getMethods(this);
    }

    public ICPPMethod[] getAllDeclaredMethods() throws DOMException {
        return this.mixin.getAllDeclaredMethods();
    }

    public ICPPMethod[] getDeclaredMethods() throws DOMException {
        return this.mixin.getDeclaredMethods();
    }

    public ICPPConstructor[] getConstructors() throws DOMException {
        return this.mixin.getConstructors();
    }

    public IBinding[] getFriends() {
        return this.mixin.getFriends();
    }

    public ICPPClassType[] getNestedClasses() {
        return this.mixin.getNestedClasses();
    }

    public IField findField(String name) throws DOMException {
        return this.mixin.findField(name);
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public String toString() {
        return this.getName();
    }

    public static class CPPClassTypeProblem
    extends ProblemBinding
    implements ICPPClassType {
        public CPPClassTypeProblem(IASTNode node, int id, char[] arg) {
            super(node, id, arg);
        }

        public ICPPBase[] getBases() throws DOMException {
            throw new DOMException(this);
        }

        public IField[] getFields() throws DOMException {
            throw new DOMException(this);
        }

        public ICPPField[] getDeclaredFields() throws DOMException {
            throw new DOMException(this);
        }

        public ICPPMethod[] getMethods() throws DOMException {
            throw new DOMException(this);
        }

        public ICPPMethod[] getAllDeclaredMethods() throws DOMException {
            throw new DOMException(this);
        }

        public ICPPMethod[] getDeclaredMethods() throws DOMException {
            throw new DOMException(this);
        }

        public ICPPConstructor[] getConstructors() throws DOMException {
            throw new DOMException(this);
        }

        public ICPPMethod[] getDeclaredConversionOperators() throws DOMException {
            throw new DOMException(this);
        }

        public int getKey() throws DOMException {
            throw new DOMException(this);
        }

        public IField findField(String name) throws DOMException {
            throw new DOMException(this);
        }

        public IScope getCompositeScope() throws DOMException {
            throw new DOMException(this);
        }

        public IScope getParent() throws DOMException {
            throw new DOMException(this);
        }

        public IBinding[] find(String name) throws DOMException {
            throw new DOMException(this);
        }

        public IBinding[] getFriends() throws DOMException {
            throw new DOMException(this);
        }

        public String[] getQualifiedName() throws DOMException {
            throw new DOMException(this);
        }

        public char[][] getQualifiedNameCharArray() throws DOMException {
            throw new DOMException(this);
        }

        public boolean isGloballyQualified() throws DOMException {
            throw new DOMException(this);
        }

        public ICPPClassType[] getNestedClasses() throws DOMException {
            throw new DOMException(this);
        }
    }

    private class FindDefinitionAction
    extends CPPASTVisitor {
        private char[] nameArray;
        public IASTName result;

        private FindDefinitionAction() {
            this.nameArray = CPPClassType.this.getNameCharArray();
            this.result = null;
            this.shouldVisitNames = true;
            this.shouldVisitDeclarations = true;
            this.shouldVisitDeclSpecifiers = true;
            this.shouldVisitDeclarators = true;
        }

        public int visit(IASTName name) {
            IBinding binding;
            if (name instanceof ICPPASTTemplateId) {
                return 1;
            }
            if (name instanceof ICPPASTQualifiedName) {
                return 3;
            }
            char[] c = name.toCharArray();
            if (name.getParent() instanceof ICPPASTQualifiedName) {
                IASTName[] ns = ((ICPPASTQualifiedName)name.getParent()).getNames();
                if (ns[ns.length - 1] != name) {
                    return 3;
                }
                name = (IASTName)name.getParent();
            }
            if (name.getParent() instanceof ICPPASTCompositeTypeSpecifier && CharArrayUtils.equals(c, this.nameArray) && (binding = name.resolveBinding()) == CPPClassType.this) {
                if (name instanceof ICPPASTQualifiedName) {
                    IASTName[] ns = ((ICPPASTQualifiedName)name).getNames();
                    name = ns[ns.length - 1];
                }
                this.result = name;
                return 2;
            }
            return 3;
        }

        public int visit(IASTDeclaration declaration) {
            if (declaration instanceof IASTSimpleDeclaration || declaration instanceof ICPPASTTemplateDeclaration) {
                return 3;
            }
            return 1;
        }

        public int visit(IASTDeclSpecifier declSpec) {
            return declSpec instanceof ICPPASTCompositeTypeSpecifier ? 3 : 1;
        }

        public int visit(IASTDeclarator declarator) {
            return 1;
        }
    }
}

