/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.dom.lrparser.action;

import java.util.Arrays;
import java.util.List;
import lpg.lpgjavaruntime.IToken;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.lrparser.action.ITokenMap;
import org.eclipse.cdt.internal.core.dom.parser.ASTNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ParserUtil {
    private ParserUtil() {
    }

    public static int offset(IToken token) {
        return token.getStartOffset();
    }

    public static int offset(IASTNode node) {
        return ((ASTNode)node).getOffset();
    }

    public static int length(IToken token) {
        return ParserUtil.endOffset(token) - ParserUtil.offset(token);
    }

    public static int length(IASTNode node) {
        return ((ASTNode)node).getLength();
    }

    public static int endOffset(IASTNode node) {
        return ParserUtil.offset(node) + ParserUtil.length(node);
    }

    public static int endOffset(IToken token) {
        return token.getEndOffset();
    }

    public static void setOffsetAndLength(IASTNode node, IToken token) {
        ((ASTNode)node).setOffsetAndLength(ParserUtil.offset(token), ParserUtil.length(token));
    }

    public static void setOffsetAndLength(IASTNode node, int offset, int length) {
        ((ASTNode)node).setOffsetAndLength(offset, length);
    }

    public static void setOffsetAndLength(IASTNode node, IASTNode from) {
        ParserUtil.setOffsetAndLength(node, ParserUtil.offset(from), ParserUtil.length(from));
    }

    public static boolean isSameName(IASTName name1, IASTName name2) {
        return Arrays.equals(name1.toCharArray(), name2.toCharArray());
    }

    public static boolean matchTokens(List<IToken> source, ITokenMap tokenMap, Integer ... pattern) {
        if (source.size() != pattern.length) {
            return false;
        }
        int i = 0;
        int n = pattern.length;
        while (i < n) {
            if (tokenMap.mapKind(source.get(i).getKind()) != pattern[i].intValue()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static List<IToken> tokenOffsetSubList(List<IToken> tokens, int startOffset, int endOffset) {
        int first = 0;
        int last = 0;
        int i = 0;
        for (IToken t : tokens) {
            if (ParserUtil.offset(t) == startOffset) {
                first = i;
            }
            if (ParserUtil.endOffset(t) == endOffset) {
                last = i;
                break;
            }
            ++i;
        }
        return tokens.subList(first, last + 1);
    }
}

