/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.c;

import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTSimpleDeclaration;
import org.eclipse.cdt.core.parser.util.ArrayUtil;
import org.eclipse.cdt.internal.core.dom.parser.c.CASTNode;

public class CASTSimpleDeclaration
extends CASTNode
implements IASTSimpleDeclaration {
    private IASTDeclarator[] declarators = null;
    private int declaratorsPos = -1;
    private IASTDeclSpecifier declSpecifier;

    public CASTSimpleDeclaration() {
    }

    public CASTSimpleDeclaration(IASTDeclSpecifier declSpecifier) {
        this.setDeclSpecifier(declSpecifier);
    }

    public IASTDeclSpecifier getDeclSpecifier() {
        return this.declSpecifier;
    }

    public IASTDeclarator[] getDeclarators() {
        if (this.declarators == null) {
            return IASTDeclarator.EMPTY_DECLARATOR_ARRAY;
        }
        this.declarators = (IASTDeclarator[])ArrayUtil.removeNullsAfter(IASTDeclarator.class, this.declarators, this.declaratorsPos);
        return this.declarators;
    }

    public void addDeclarator(IASTDeclarator d) {
        if (d != null) {
            d.setParent(this);
            d.setPropertyInParent(DECLARATOR);
            this.declarators = (IASTDeclarator[])ArrayUtil.append(IASTDeclarator.class, this.declarators, ++this.declaratorsPos, d);
        }
    }

    public void setDeclSpecifier(IASTDeclSpecifier declSpecifier) {
        this.declSpecifier = declSpecifier;
        if (declSpecifier != null) {
            declSpecifier.setParent(this);
            declSpecifier.setPropertyInParent(DECL_SPECIFIER);
        }
    }

    public boolean accept(ASTVisitor action) {
        if (action.shouldVisitDeclarations) {
            switch (action.visit(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        if (this.declSpecifier != null && !this.declSpecifier.accept(action)) {
            return false;
        }
        IASTDeclarator[] dtors = this.getDeclarators();
        int i = 0;
        while (i < dtors.length) {
            if (!dtors[i].accept(action)) {
                return false;
            }
            ++i;
        }
        if (action.shouldVisitDeclarations) {
            switch (action.leave(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        return true;
    }
}

