/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import org.eclipse.cdt.core.dom.ILinkage;
import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTCompletionContext;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNameOwner;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTTypeId;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTAmbiguousTemplateArgument;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTemplateId;
import org.eclipse.cdt.core.parser.util.ArrayUtil;
import org.eclipse.cdt.internal.core.dom.Linkage;
import org.eclipse.cdt.internal.core.dom.parser.IASTAmbiguityParent;
import org.eclipse.cdt.internal.core.dom.parser.IASTInternalNameOwner;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTName;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTNode;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPTemplates;

public class CPPASTTemplateId
extends CPPASTNode
implements ICPPASTTemplateId,
IASTAmbiguityParent {
    private IASTName templateName;
    private IASTNode[] templateArguments = null;
    private IBinding binding = null;
    private int fResolutionDepth = 0;

    public CPPASTTemplateId() {
    }

    public CPPASTTemplateId(IASTName templateName) {
        this.setTemplateName(templateName);
    }

    public IASTName getTemplateName() {
        return this.templateName;
    }

    public void setTemplateName(IASTName name) {
        this.templateName = name;
        if (name != null) {
            name.setParent(this);
            name.setPropertyInParent(TEMPLATE_NAME);
        }
    }

    public void addTemplateArgument(IASTTypeId typeId) {
        this.templateArguments = (IASTNode[])ArrayUtil.append(IASTNode.class, this.templateArguments, typeId);
        if (typeId != null) {
            typeId.setParent(this);
            typeId.setPropertyInParent(TEMPLATE_ID_ARGUMENT);
        }
    }

    public void addTemplateArgument(IASTExpression expression) {
        this.templateArguments = (IASTNode[])ArrayUtil.append(IASTNode.class, this.templateArguments, expression);
        if (expression != null) {
            expression.setParent(this);
            expression.setPropertyInParent(TEMPLATE_ID_ARGUMENT);
        }
    }

    public void addTemplateArgument(ICPPASTAmbiguousTemplateArgument ata) {
        this.templateArguments = (IASTNode[])ArrayUtil.append(IASTNode.class, this.templateArguments, ata);
        if (ata != null) {
            ata.setParent(this);
            ata.setPropertyInParent(TEMPLATE_ID_ARGUMENT);
        }
    }

    public IASTNode[] getTemplateArguments() {
        if (this.templateArguments == null) {
            return ICPPASTTemplateId.EMPTY_ARG_ARRAY;
        }
        return (IASTNode[])ArrayUtil.trim(IASTNode.class, this.templateArguments);
    }

    public IBinding resolveBinding() {
        if (this.binding == null) {
            this.binding = ++this.fResolutionDepth > 5 ? new CPPASTName.RecursionResolvingBinding(this) : CPPTemplates.createBinding(this);
        }
        return this.binding;
    }

    public IASTCompletionContext getCompletionContext() {
        return null;
    }

    public char[] toCharArray() {
        return this.templateName.toCharArray();
    }

    public String toString() {
        return this.templateName.toString();
    }

    public boolean accept(ASTVisitor action) {
        if (action.shouldVisitNames) {
            switch (action.visit(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        if (this.templateName != null && !this.templateName.accept(action)) {
            return false;
        }
        IASTNode[] nodes = this.getTemplateArguments();
        int i = 0;
        while (i < nodes.length) {
            if (!nodes[i].accept(action)) {
                return false;
            }
            ++i;
        }
        if (action.shouldVisitNames) {
            switch (action.leave(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        return true;
    }

    public boolean isDeclaration() {
        return false;
    }

    public boolean isReference() {
        return true;
    }

    public int getRoleForName(IASTName n) {
        if (n == this.templateName) {
            return 1;
        }
        return 3;
    }

    public IBinding getBinding() {
        return this.binding;
    }

    public void setBinding(IBinding binding) {
        this.binding = binding;
        this.fResolutionDepth = 0;
    }

    public void replace(IASTNode child, IASTNode other) {
        if (this.templateArguments == null) {
            return;
        }
        int i = 0;
        while (i < this.templateArguments.length) {
            if (child == this.templateArguments[i]) {
                other.setPropertyInParent(child.getPropertyInParent());
                other.setParent(child.getParent());
                this.templateArguments[i] = other;
            }
            ++i;
        }
    }

    public int getRoleOfName(boolean allowResolution) {
        IASTNode parent = this.getParent();
        if (parent instanceof IASTInternalNameOwner) {
            return ((IASTInternalNameOwner)((Object)parent)).getRoleForName(this, allowResolution);
        }
        if (parent instanceof IASTNameOwner) {
            return ((IASTNameOwner)((Object)parent)).getRoleForName(this);
        }
        return 3;
    }

    public boolean isDefinition() {
        IASTNode parent = this.getParent();
        if (parent instanceof IASTNameOwner) {
            int role = ((IASTNameOwner)((Object)parent)).getRoleForName(this);
            return role == 2;
        }
        return false;
    }

    public void incResolutionDepth() {
        if (this.binding == null && ++this.fResolutionDepth > 5) {
            this.binding = new CPPASTName.RecursionResolvingBinding(this);
        }
    }

    public ILinkage getLinkage() {
        return Linkage.CPP_LINKAGE;
    }

    public IASTName getLastName() {
        return this;
    }
}

