/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import org.eclipse.cdt.core.dom.ast.IASTBinaryExpression;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum OverloadableOperator {
    GT(">"),
    LT("<"),
    NOT("!"),
    BITCOMPLEMENT("~"),
    BITOR("|"),
    AMPER("&"),
    XOR("^"),
    MOD("%"),
    DIV("/"),
    STAR("*"),
    PLUS("+"),
    BRACKET("[]"),
    PAREN("()"),
    ARROW("->"),
    ARROWSTAR("->*"),
    COMMA(","),
    MINUS("-"),
    DECR("--"),
    INCR("++"),
    OR("||"),
    AND("&&"),
    ASSIGN("="),
    GTEQUAL(">="),
    LTEQUAL("<="),
    NOTEQUAL("!="),
    EQUAL("=="),
    SHIFTR(">>"),
    SHIFTL("<<"),
    SHIFTLASSIGN("<<="),
    SHIFTRASSIGN(">>="),
    BITORASSIGN("|="),
    AMPERASSIGN("&="),
    XORASSIGN("^="),
    MODASSIGN("%="),
    DIVASSIGN("/="),
    STARASSIGN("*="),
    MINUSASSIGN("-="),
    PLUSASSIGN("+="),
    NEW("new"),
    DELETE_ARRAY("delete[]"),
    DELETE("delete"),
    NEW_ARRAY("new[]");

    private final char[] rep;

    private OverloadableOperator(String rep) {
        this.rep = ("operator " + rep).toCharArray();
    }

    public char[] toCharArray() {
        return this.rep;
    }

    public static OverloadableOperator fromBinaryExpression(IASTBinaryExpression expression) {
        switch (expression.getOperator()) {
            case 12: {
                return AMPER;
            }
            case 25: {
                return AMPERASSIGN;
            }
            case 31: {
                return ARROW;
            }
            case 14: {
                return BITOR;
            }
            case 27: {
                return BITORASSIGN;
            }
            case 6: {
                return SHIFTL;
            }
            case 23: {
                return SHIFTLASSIGN;
            }
            case 7: {
                return SHIFTR;
            }
            case 24: {
                return SHIFTRASSIGN;
            }
            case 13: {
                return XOR;
            }
            case 26: {
                return XORASSIGN;
            }
            case 15: {
                return AND;
            }
            case 16: {
                return OR;
            }
            case 2: {
                return DIV;
            }
            case 19: {
                return DIVASSIGN;
            }
            case 5: {
                return MINUS;
            }
            case 22: {
                return MINUSASSIGN;
            }
            case 3: {
                return MOD;
            }
            case 20: {
                return MODASSIGN;
            }
            case 4: {
                return PLUS;
            }
            case 21: {
                return PLUSASSIGN;
            }
            case 1: {
                return STAR;
            }
            case 18: {
                return STARASSIGN;
            }
            case 28: {
                return EQUAL;
            }
            case 29: {
                return NOTEQUAL;
            }
            case 9: {
                return GT;
            }
            case 11: {
                return GTEQUAL;
            }
            case 8: {
                return LT;
            }
            case 10: {
                return LTEQUAL;
            }
            case 17: {
                return ASSIGN;
            }
        }
        return null;
    }

    public static OverloadableOperator valueOf(String string) {
        return Enum.valueOf(OverloadableOperator.class, string);
    }
}

